/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.joint.skeleton;

import com.google.common.collect.Maps;
import com.trainguy9512.locomotion.animation.joint.skeleton.SkeletonPropertyDefinition;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.Mth;

public class BlendProfile
extends SkeletonPropertyDefinition<Float> {
    private BlendProfile(Map<String, Float> jointProperties, Map<String, Float> customAttributeProperties, boolean mirrored) {
        super(jointProperties, customAttributeProperties, mirrored, Float.valueOf(1.0f));
    }

    public BlendProfile getMirrored() {
        return new BlendProfile(this.jointProperties, this.customAttributeProperties, !this.isMirrored);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, Float> jointDurationMultipliers = Maps.newHashMap();
        private final Map<String, Float> customAttributeDurationMultipliers = Maps.newHashMap();

        public Builder defineForJoint(String jointName, float durationMultiplier) {
            this.jointDurationMultipliers.put(jointName, Float.valueOf(Mth.clamp((float)durationMultiplier, (float)0.001f, (float)1.0f)));
            return this;
        }

        public Builder defineForMultipleJoints(Set<String> jointNames, float durationMultiplier) {
            jointNames.forEach(jointName -> this.defineForJoint((String)jointName, durationMultiplier));
            return this;
        }

        public Builder defineForCustomAttribute(String customAttributeName, float weight) {
            this.customAttributeDurationMultipliers.put(customAttributeName, Float.valueOf(Mth.clamp((float)weight, (float)0.0f, (float)1.0f)));
            return this;
        }

        public Builder defineForMultipleCustomAttributes(Set<String> customAttributeNames, float weight) {
            customAttributeNames.forEach(jointName -> this.defineForJoint((String)jointName, weight));
            return this;
        }

        public BlendProfile build() {
            return new BlendProfile(this.jointDurationMultipliers, this.customAttributeDurationMultipliers, false);
        }
    }
}

