/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.pose.function;

import com.trainguy9512.locomotion.animation.pose.LocalSpacePose;
import com.trainguy9512.locomotion.animation.pose.function.PoseFunction;
import com.trainguy9512.locomotion.animation.sequence.AnimationSequence;
import com.trainguy9512.locomotion.util.TimeSpan;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class SequenceEvaluatorFunction
implements PoseFunction<LocalSpacePose> {
    private final Function<PoseFunction.FunctionInterpolationContext, ResourceLocation> animationSequenceFunction;
    private final Function<PoseFunction.FunctionInterpolationContext, TimeSpan> sequenceTimeFunction;

    private SequenceEvaluatorFunction(Function<PoseFunction.FunctionInterpolationContext, ResourceLocation> animationSequenceFunction, Function<PoseFunction.FunctionInterpolationContext, TimeSpan> sequenceTimeFunction) {
        this.animationSequenceFunction = animationSequenceFunction;
        this.sequenceTimeFunction = sequenceTimeFunction;
    }

    public static Builder builder(Function<PoseFunction.FunctionInterpolationContext, ResourceLocation> animationSequenceFunction) {
        return new Builder(animationSequenceFunction);
    }

    public static Builder builder(ResourceLocation animationSequence) {
        return SequenceEvaluatorFunction.builder((PoseFunction.FunctionInterpolationContext context) -> animationSequence);
    }

    @Override
    @NotNull
    public LocalSpacePose compute(PoseFunction.FunctionInterpolationContext context) {
        TimeSpan time = this.sequenceTimeFunction.apply(context);
        return AnimationSequence.samplePose(context.driverContainer().getJointSkeleton(), this.animationSequenceFunction.apply(context), time, false);
    }

    @Override
    public void tick(PoseFunction.FunctionEvaluationState evaluationState) {
    }

    @Override
    public PoseFunction<LocalSpacePose> wrapUnique() {
        return new SequenceEvaluatorFunction(this.animationSequenceFunction, this.sequenceTimeFunction);
    }

    @Override
    public Optional<PoseFunction<?>> searchDownChainForMostRelevant(Predicate<PoseFunction<?>> findCondition) {
        return findCondition.test(this) ? Optional.of(this) : Optional.empty();
    }

    public static class Builder {
        private final Function<PoseFunction.FunctionInterpolationContext, ResourceLocation> animationSequenceFunction;
        private Function<PoseFunction.FunctionInterpolationContext, TimeSpan> sequenceTimeFunction;

        public Builder(Function<PoseFunction.FunctionInterpolationContext, ResourceLocation> animationSequenceFunction) {
            this.animationSequenceFunction = animationSequenceFunction;
            this.sequenceTimeFunction = context -> TimeSpan.ZERO;
        }

        public Builder evaluatesPoseAt(Function<PoseFunction.FunctionInterpolationContext, TimeSpan> sequenceTimeFunction) {
            this.sequenceTimeFunction = sequenceTimeFunction;
            return this;
        }

        public Builder evaluatesPoseAt(TimeSpan sequenceTime) {
            this.sequenceTimeFunction = context -> sequenceTime;
            return this;
        }

        public SequenceEvaluatorFunction build() {
            return new SequenceEvaluatorFunction(this.animationSequenceFunction, this.sequenceTimeFunction);
        }
    }
}

