/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.config;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.trainguy9512.locomotion.animation.animator.JointAnimatorDispatcher;
import com.trainguy9512.locomotion.config.LocomotionConfigScreen;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocomotionConfig {
    private static final Logger LOGGER = LogManager.getLogger((String)"Locomotion/Config");
    private static final Path CONFIG_FILE_PATH = Path.of("config", new String[0]).resolve("locomotion.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).excludeFieldsWithModifiers(new int[]{2}).create();
    private Data configData = new Data();

    public Data data() {
        return this.configData;
    }

    public void load() {
        block8: {
            if (Files.exists(CONFIG_FILE_PATH, new LinkOption[0])) {
                try (FileReader reader = new FileReader(CONFIG_FILE_PATH.toFile());){
                    this.configData = (Data)GSON.fromJson((Reader)reader, Data.class);
                    break block8;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load locomotion config file", e);
                }
            }
            this.configData = new Data();
        }
        this.save();
    }

    public void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_FILE_PATH, new OpenOption[0]);){
            writer.write(GSON.toJson((Object)this.configData));
        }
        catch (Exception e) {
            LOGGER.error("Failed to write config to path {}", (Object)CONFIG_FILE_PATH.toAbsolutePath());
        }
        JointAnimatorDispatcher.getInstance().reInitializeData();
    }

    public Function<Screen, Screen> getConfigScreen(Predicate<String> ifModLoaded) {
        if (ifModLoaded.test("yet_another_config_lib_v3")) {
            return LocomotionConfigScreen::createConfigScreen;
        }
        return parent -> new AlertScreen(() -> Minecraft.getInstance().setScreen(parent), (Component)Component.translatable((String)"locomotion.config.yacl_not_found.header"), (Component)Component.translatable((String)"locomotion.config.yacl_not_found.description"), (Component)Component.translatable((String)"locomotion.config.yacl_not_found.close"), true);
    }

    public static class Data {
        public final FirstPersonPlayer firstPersonPlayer = new FirstPersonPlayer();

        public static class FirstPersonPlayer {
            public boolean enableRenderer = true;
            public boolean enableCameraRotationDamping = true;
            public float cameraRotationStiffnessFactor = 0.3f;
            public float cameraRotationDampingFactor = 0.65f;
            public float cameraShakeMasterIntensity = 1.0f;
            public float cameraShakeMovementIntensity = 1.0f;
            public float cameraShakeItemInteractionIntensity = 0.5f;
            public float miningAnimationSpeedMultiplier = 1.0f;
            public float mapMovementAnimationIntensity = 0.2f;
        }
    }
}

