/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.mixin.game;

import com.trainguy9512.locomotion.animation.animator.JointAnimatorDispatcher;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonDrivers;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonUseAnimations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiPlayerGameMode.class})
public class MixinMultiPlayerGameMode {
    @Shadow
    @Final
    private Minecraft minecraft;

    @Inject(method={"stopDestroyBlock()V"}, at={@At(value="HEAD")})
    public void disableMiningAnimationOnNoLongerMining(CallbackInfo ci) {
        assert (this.minecraft.player != null);
        if (!this.minecraft.player.getAbilities().instabuild) {
            JointAnimatorDispatcher.getInstance().getFirstPersonPlayerDataContainer().ifPresent(dataContainer -> {
                if (dataContainer.getDriver(FirstPersonDrivers.IS_MINING).getPreviousValue().booleanValue()) {
                    dataContainer.getDriver(FirstPersonDrivers.IS_MINING).setValue(false);
                }
            });
        }
    }

    @Inject(method={"startDestroyBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z"}, at={@At(value="HEAD")})
    public void enableMiningAnimationOnBeginMining(BlockPos loc, Direction face, CallbackInfoReturnable<Boolean> cir) {
        assert (this.minecraft.player != null);
        if (!this.minecraft.player.getAbilities().instabuild) {
            JointAnimatorDispatcher.getInstance().getFirstPersonPlayerDataContainer().ifPresent(dataContainer -> dataContainer.getDriver(FirstPersonDrivers.IS_MINING).setValue(true));
        }
    }

    @Inject(method={"continueDestroyBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z"}, at={@At(value="HEAD")})
    public void enableMiningAnimationOnContinueMining(BlockPos loc, Direction face, CallbackInfoReturnable<Boolean> cir) {
        assert (this.minecraft.player != null);
        if (!this.minecraft.player.getAbilities().instabuild) {
            JointAnimatorDispatcher.getInstance().getFirstPersonPlayerDataContainer().ifPresent(dataContainer -> dataContainer.getDriver(FirstPersonDrivers.IS_MINING).setValue(true));
        }
    }

    @Inject(method={"destroyBlock(Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="RETURN")})
    public void destroyBlockInCreativeInstantly(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        assert (this.minecraft.player != null);
        if (((Boolean)cir.getReturnValue()).booleanValue() && this.minecraft.player.getAbilities().instabuild) {
            JointAnimatorDispatcher.getInstance().getFirstPersonPlayerDataContainer().ifPresent(dataContainer -> dataContainer.getDriver(FirstPersonDrivers.HAS_ATTACKED).trigger());
        }
    }

    @Inject(method={"useItem(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="RETURN")})
    public void triggerUseItemAnimation(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        Object object = cir.getReturnValue();
        if (object instanceof InteractionResult.Success) {
            InteractionResult.Success success = (InteractionResult.Success)object;
            FirstPersonUseAnimations.triggerUseAnimation(hand, FirstPersonUseAnimations.UseAnimationType.USE_ITEM, success.swingSource());
        }
    }

    @Inject(method={"useItemOn(Lnet/minecraft/client/player/LocalPlayer;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="RETURN")})
    public void triggerUseItemOnAnimation(LocalPlayer player, InteractionHand hand, BlockHitResult result, CallbackInfoReturnable<InteractionResult> cir) {
        Object object = cir.getReturnValue();
        if (object instanceof InteractionResult.Success) {
            InteractionResult.Success success = (InteractionResult.Success)object;
            FirstPersonUseAnimations.triggerUseAnimation(hand, FirstPersonUseAnimations.UseAnimationType.USE_ITEM_ON_BLOCK, success.swingSource());
        }
    }

    @Inject(method={"interactAt(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/EntityHitResult;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="RETURN")})
    public void triggerInteractAtAnimation(Player player, Entity target, EntityHitResult ray, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        Object object = cir.getReturnValue();
        if (object instanceof InteractionResult.Success) {
            InteractionResult.Success success = (InteractionResult.Success)object;
            FirstPersonUseAnimations.triggerUseAnimation(hand, FirstPersonUseAnimations.UseAnimationType.INTERACT_AT_ENTITY, success.swingSource());
        }
    }

    @Inject(method={"interact(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="RETURN")})
    public void triggerInteractAnimation(Player player, Entity target, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        Object object = cir.getReturnValue();
        if (object instanceof InteractionResult.Success) {
            InteractionResult.Success success = (InteractionResult.Success)object;
            FirstPersonUseAnimations.triggerUseAnimation(hand, FirstPersonUseAnimations.UseAnimationType.INTERACT_ENTITY, success.swingSource());
        }
    }
}

