/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.mixin.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.trainguy9512.locomotion.LocomotionMain;
import com.trainguy9512.locomotion.access.FirstPersonPlayerRendererGetter;
import com.trainguy9512.locomotion.animation.animator.JointAnimator;
import com.trainguy9512.locomotion.animation.animator.JointAnimatorDispatcher;
import com.trainguy9512.locomotion.animation.animator.JointAnimatorRegistry;
import com.trainguy9512.locomotion.animation.data.AnimationDataContainer;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class MixinGameRenderer {
    @Shadow
    @Final
    private Minecraft minecraft;

    @Inject(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Camera;setup(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/entity/Entity;ZZF)V")})
    private void computePosePriorToRendering(DeltaTracker deltaTracker, CallbackInfo ci) {
        if (LocomotionMain.CONFIG.data().firstPersonPlayer.enableRenderer) {
            JointAnimatorDispatcher jointAnimatorDispatcher = JointAnimatorDispatcher.getInstance();
            jointAnimatorDispatcher.getFirstPersonPlayerDataContainer().ifPresent(dataContainer -> JointAnimatorRegistry.getFirstPersonPlayerJointAnimator().ifPresent(jointAnimator -> jointAnimatorDispatcher.calculateInterpolatedFirstPersonPlayerPose((JointAnimator<?>)jointAnimator, (AnimationDataContainer)dataContainer, deltaTracker.getGameTimeDeltaPartialTick(true))));
        }
    }

    @Inject(method={"bobHurt(Lcom/mojang/blaze3d/vertex/PoseStack;F)V"}, at={@At(value="HEAD")})
    private void addCameraRotation(PoseStack poseStack, float partialTicks, CallbackInfo ci) {
        if (LocomotionMain.CONFIG.data().firstPersonPlayer.enableRenderer) {
            ((FirstPersonPlayerRendererGetter)this.minecraft.getEntityRenderDispatcher()).locomotion$getFirstPersonPlayerRenderer().ifPresent(firstPersonPlayerRenderer -> firstPersonPlayerRenderer.transformCamera(poseStack));
        }
    }

    @Inject(method={"bobView(Lcom/mojang/blaze3d/vertex/PoseStack;F)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void removeViewBobbing(PoseStack poseStack, float partialTicks, CallbackInfo ci) {
        if (LocomotionMain.CONFIG.data().firstPersonPlayer.enableRenderer) {
            ci.cancel();
        }
    }
}

