/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.util;

import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class TimeSpan
implements Comparable<TimeSpan> {
    public static final TimeSpan ZERO = TimeSpan.ofTicks(0.0f);
    private final float timeInTicks;

    private TimeSpan(float timeInTicks) {
        this.timeInTicks = timeInTicks;
    }

    public static TimeSpan ofTicks(float timeInTicks) {
        return new TimeSpan(timeInTicks);
    }

    public static TimeSpan ofSeconds(float timeInSeconds) {
        return new TimeSpan(timeInSeconds * 20.0f);
    }

    public static TimeSpan ofFramesPerSecond(float frames, float framesPerSecond) {
        return new TimeSpan(20.0f * frames / framesPerSecond);
    }

    public static TimeSpan of60FramesPerSecond(float frames) {
        return TimeSpan.ofFramesPerSecond(frames, 60.0f);
    }

    public static TimeSpan of30FramesPerSecond(float frames) {
        return TimeSpan.ofFramesPerSecond(frames, 30.0f);
    }

    public static TimeSpan of24FramesPerSecond(float frames) {
        return TimeSpan.ofFramesPerSecond(frames, 24.0f);
    }

    public float inTicks() {
        return this.timeInTicks;
    }

    public float inSeconds() {
        return this.timeInTicks / 20.0f;
    }

    public float inFramesPerSecond(float framesPerSecond) {
        return this.timeInTicks * framesPerSecond / 20.0f;
    }

    public float in60FramesPerSecond() {
        return this.inFramesPerSecond(60.0f);
    }

    public float in30FramesPerSecond() {
        return this.inFramesPerSecond(30.0f);
    }

    public float in24FramesPerSecond() {
        return this.inFramesPerSecond(24.0f);
    }

    public TimeSpan interpolated(TimeSpan other, float alpha) {
        float blendedTicks = Mth.lerp((float)alpha, (float)this.timeInTicks, (float)other.timeInTicks);
        return TimeSpan.ofTicks(blendedTicks);
    }

    @Override
    public int compareTo(@NotNull TimeSpan timeSpan) {
        if (this.timeInTicks == timeSpan.timeInTicks) {
            return 0;
        }
        return this.timeInTicks > timeSpan.timeInTicks ? 1 : -1;
    }
}

