/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.animator;

import com.trainguy9512.locomotion.LocomotionMain;
import com.trainguy9512.locomotion.access.MatrixModelPart;
import com.trainguy9512.locomotion.animation.animator.JointAnimator;
import com.trainguy9512.locomotion.animation.animator.JointAnimatorRegistry;
import com.trainguy9512.locomotion.animation.animator.entity.EntityJointAnimator;
import com.trainguy9512.locomotion.animation.data.AnimationDataContainer;
import com.trainguy9512.locomotion.animation.joint.skeleton.JointSkeleton;
import com.trainguy9512.locomotion.animation.pose.ComponentSpacePose;
import com.trainguy9512.locomotion.animation.pose.LocalSpacePose;
import com.trainguy9512.locomotion.animation.pose.Pose;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.class_10017;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_583;
import net.minecraft.class_630;

public class JointAnimatorDispatcher {
    private static final JointAnimatorDispatcher INSTANCE = new JointAnimatorDispatcher();
    private final WeakHashMap<UUID, AnimationDataContainer> entityAnimationDataContainerStorage = new WeakHashMap();
    private AnimationDataContainer firstPersonPlayerDataContainer;
    private ComponentSpacePose interpolatedFirstPersonPlayerPose;

    public static JointAnimatorDispatcher getInstance() {
        return INSTANCE;
    }

    public void reInitializeData() {
        this.firstPersonPlayerDataContainer = null;
        this.entityAnimationDataContainerStorage.clear();
    }

    public <T extends class_1297> void tickEntityJointAnimators(Iterable<T> entitiesForRendering) {
        entitiesForRendering.forEach(entity -> JointAnimatorRegistry.getThirdPersonJointAnimator(entity).ifPresent(jointAnimator -> this.getEntityAnimationDataContainer(entity).ifPresent(dataContainer -> this.tickJointAnimator((JointAnimator)jointAnimator, (Object)entity, (AnimationDataContainer)dataContainer))));
    }

    public void tickFirstPersonPlayerJointAnimator() {
        if (LocomotionMain.CONFIG.data().firstPersonPlayer.enableRenderer) {
            JointAnimatorRegistry.getFirstPersonPlayerJointAnimator().ifPresent(jointAnimator -> this.getFirstPersonPlayerDataContainer().ifPresent(dataContainer -> this.tickJointAnimator((JointAnimator)jointAnimator, (Object)class_310.method_1551().field_1724, (AnimationDataContainer)dataContainer)));
        }
    }

    private <T> void tickJointAnimator(JointAnimator<T> jointAnimator, T dataReference, AnimationDataContainer dataContainer) {
        dataContainer.preTick();
        jointAnimator.extractAnimationData(dataReference, dataContainer, dataContainer.getMontageManager());
        dataContainer.tick();
        if (jointAnimator.getPoseCalulationFrequency() == JointAnimator.PoseCalculationFrequency.CALCULATE_ONCE_PER_TICK) {
            dataContainer.getDriver(dataContainer.getPerTickCalculatedPoseDriverKey()).setValue(dataContainer.computePose(1.0f));
        }
        dataContainer.postTick();
    }

    public <T extends class_1297> Optional<AnimationDataContainer> getEntityAnimationDataContainer(T entity) {
        UUID uuid = entity.method_5667();
        if (!this.entityAnimationDataContainerStorage.containsKey(uuid)) {
            JointAnimatorRegistry.getThirdPersonJointAnimator(entity).ifPresent(jointAnimator -> this.entityAnimationDataContainerStorage.put(uuid, this.createDataContainer((JointAnimator<?>)jointAnimator)));
        }
        return Optional.ofNullable(this.entityAnimationDataContainerStorage.get(uuid));
    }

    public Optional<AnimationDataContainer> getFirstPersonPlayerDataContainer() {
        if (this.firstPersonPlayerDataContainer == null) {
            JointAnimatorRegistry.getFirstPersonPlayerJointAnimator().ifPresent(jointAnimator -> {
                this.firstPersonPlayerDataContainer = this.createDataContainer((JointAnimator<?>)jointAnimator);
            });
        }
        return Optional.ofNullable(this.firstPersonPlayerDataContainer);
    }

    public Optional<ComponentSpacePose> getInterpolatedFirstPersonPlayerPose() {
        return Optional.ofNullable(this.interpolatedFirstPersonPlayerPose);
    }

    public void calculateInterpolatedFirstPersonPlayerPose(JointAnimator<?> jointAnimator, AnimationDataContainer dataContainer, float partialTicks) {
        this.interpolatedFirstPersonPlayerPose = this.getInterpolatedAnimationPose(jointAnimator, dataContainer, partialTicks);
    }

    private AnimationDataContainer createDataContainer(JointAnimator<?> jointAnimator) {
        return AnimationDataContainer.of(jointAnimator);
    }

    public ComponentSpacePose getInterpolatedAnimationPose(JointAnimator<?> jointAnimator, AnimationDataContainer dataContainer, float partialTicks) {
        return switch (jointAnimator.getPoseCalulationFrequency()) {
            default -> throw new MatchException(null, null);
            case JointAnimator.PoseCalculationFrequency.CALCULATE_EVERY_FRAME -> dataContainer.computePose(partialTicks).convertedToComponentSpace();
            case JointAnimator.PoseCalculationFrequency.CALCULATE_ONCE_PER_TICK -> ((LocalSpacePose)dataContainer.getInterpolatedDriverValue(dataContainer.getPerTickCalculatedPoseDriverKey(), partialTicks)).convertedToComponentSpace();
        };
    }

    public <S extends class_10017> void setupAnimWithAnimationPose(class_583<S> entityModel, S entityRenderState, Pose pose, EntityJointAnimator<?, S> entityJointAnimator) {
        entityModel.method_63514();
        JointSkeleton jointSkeleton = pose.getJointSkeleton();
        Function partLookup = entityModel.method_63512().method_72015();
        jointSkeleton.getJoints().forEach(joint -> {
            class_630 modelPart;
            String modelPartIdentifier = jointSkeleton.getJointConfiguration((String)joint).modelPartIdentifier();
            if (modelPartIdentifier != null && (modelPart = (class_630)partLookup.apply(modelPartIdentifier)) != null) {
                ((MatrixModelPart)modelPart).locomotion$setMatrix(pose.getJointChannel((String)joint).getTransform());
            }
        });
        entityJointAnimator.postProcessModelParts(entityModel, entityRenderState);
    }
}

