/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.animator.entity.firstperson;

import com.trainguy9512.locomotion.LocomotionMain;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonDrivers;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonHandPose;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonMontages;
import com.trainguy9512.locomotion.animation.data.OnTickDriverContainer;
import com.trainguy9512.locomotion.animation.pose.function.montage.MontageConfiguration;
import com.trainguy9512.locomotion.animation.pose.function.montage.MontageManager;
import com.trainguy9512.locomotion.util.TimeSpan;
import com.trainguy9512.locomotion.util.Transition;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_9278;
import net.minecraft.class_9334;

public class FirstPersonItemUpdateAnimations {
    private static final ArrayList<ItemUpdateAnimationRule> ITEM_UPDATE_ANIMATION_RULES = new ArrayList();
    private static final List<class_1792> FULL_BUCKET_ITEMS;

    private static boolean shouldPlayCrossbowFire(ItemUpdateAnimationConditionContext context) {
        boolean bothItemsAreCrossbows = context.bothItemsMeetPredicate(itemStack -> itemStack.method_57826(class_9334.field_49649));
        if (!bothItemsAreCrossbows) {
            return false;
        }
        boolean currentCrossbowHasCharge = !((class_9278)context.currentItem.method_58694(class_9334.field_49649)).method_57442();
        boolean previousCrossbowHasCharge = !((class_9278)context.previousItem.method_58694(class_9334.field_49649)).method_57442();
        return !currentCrossbowHasCharge && previousCrossbowHasCharge;
    }

    private static boolean shouldPlayBucketCollect(ItemUpdateAnimationConditionContext context) {
        boolean previousItemIsEmptyBucket = context.previousItem().method_31574(class_1802.field_8550);
        boolean currentItemIsCollectedBucket = FULL_BUCKET_ITEMS.contains(context.currentItem().method_7909());
        return previousItemIsEmptyBucket && currentItemIsCollectedBucket;
    }

    private static boolean shouldPlayBucketEmpty(ItemUpdateAnimationConditionContext context) {
        boolean currentItemIsEmptyBucket = context.currentItem().method_31574(class_1802.field_8550);
        boolean previousItemIsCollectedBucket = FULL_BUCKET_ITEMS.contains(context.previousItem().method_7909());
        return currentItemIsEmptyBucket && previousItemIsCollectedBucket;
    }

    public static void register(ItemUpdateAnimationRule itemUpdateAnimationRule) {
        ITEM_UPDATE_ANIMATION_RULES.addFirst(itemUpdateAnimationRule);
    }

    public static void testForAndPlayItemUpdateAnimations(OnTickDriverContainer driverContainer, MontageManager montageManager, class_1268 interactionHand) {
        if (((Boolean)driverContainer.getDriverValue(FirstPersonDrivers.HAS_DROPPED_ITEM)).booleanValue()) {
            return;
        }
        if (driverContainer.getDriver(FirstPersonDrivers.HOTBAR_SLOT).hasValueChanged()) {
            return;
        }
        if (((Boolean)driverContainer.getDriverValue(FirstPersonDrivers.HAS_SCREEN_OPEN)).booleanValue()) {
            return;
        }
        class_1799 currentItem = driverContainer.getDriver(FirstPersonDrivers.getItemCopyReferenceDriver(interactionHand)).getCurrentValue();
        class_1799 previousItem = driverContainer.getDriver(FirstPersonDrivers.getItemCopyReferenceDriver(interactionHand)).getPreviousValue();
        class_1799 renderedItem = (class_1799)driverContainer.getDriverValue(FirstPersonDrivers.getRenderedItemDriver(interactionHand));
        ItemUpdateAnimationConditionContext context = new ItemUpdateAnimationConditionContext(currentItem, previousItem);
        for (ItemUpdateAnimationRule rule : ITEM_UPDATE_ANIMATION_RULES) {
            if (!rule.shouldPlayAnimation.test(context)) continue;
            LocomotionMain.DEBUG_LOGGER.info("Playing item update animation \"{}\"", (Object)rule.identifier);
            MontageConfiguration montage = rule.montageProvider.apply(interactionHand);
            for (String slot : montage.slots()) {
                montageManager.interruptMontagesInSlot(slot, Transition.builder(TimeSpan.ofSeconds(0.2f)).build());
            }
            montageManager.playMontage(rule.montageProvider.apply(interactionHand));
            if (FirstPersonHandPose.fromItemStack(renderedItem) == FirstPersonHandPose.fromItemStack(currentItem)) {
                FirstPersonDrivers.updateRenderedItem(driverContainer, interactionHand);
            }
            return;
        }
    }

    static {
        FirstPersonItemUpdateAnimations.register(ItemUpdateAnimationRule.of(LocomotionMain.makeResourceLocation("crossbow_fire"), FirstPersonMontages::getCrossbowFireMontage, FirstPersonItemUpdateAnimations::shouldPlayCrossbowFire));
        FirstPersonItemUpdateAnimations.register(ItemUpdateAnimationRule.of(LocomotionMain.makeResourceLocation("bucket_collect"), FirstPersonMontages::getBucketCollectMontage, FirstPersonItemUpdateAnimations::shouldPlayBucketCollect));
        FirstPersonItemUpdateAnimations.register(ItemUpdateAnimationRule.of(LocomotionMain.makeResourceLocation("bucket_empty"), FirstPersonMontages::getBucketEmptyMontage, FirstPersonItemUpdateAnimations::shouldPlayBucketEmpty));
        FULL_BUCKET_ITEMS = List.of(class_1802.field_8705, class_1802.field_8187, class_1802.field_28354, class_1802.field_8666, class_1802.field_27876, class_1802.field_8108, class_1802.field_8714, class_1802.field_37533, class_1802.field_8478);
    }

    public record ItemUpdateAnimationConditionContext(class_1799 currentItem, class_1799 previousItem) {
        boolean bothItemsMeetPredicate(Predicate<class_1799> predicate) {
            return predicate.test(this.currentItem) && predicate.test(this.previousItem);
        }
    }

    public record ItemUpdateAnimationRule(class_2960 identifier, Function<class_1268, MontageConfiguration> montageProvider, Predicate<ItemUpdateAnimationConditionContext> shouldPlayAnimation) {
        public static ItemUpdateAnimationRule of(class_2960 identifier, Function<class_1268, MontageConfiguration> montageProvider, Predicate<ItemUpdateAnimationConditionContext> shouldPlayAnimation) {
            return new ItemUpdateAnimationRule(identifier, montageProvider, shouldPlayAnimation);
        }
    }
}

