/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.animator.entity.firstperson;

import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonAnimationSequences;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonDrivers;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonGenericItems;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonHandPose;
import com.trainguy9512.locomotion.animation.joint.skeleton.BlendProfile;
import com.trainguy9512.locomotion.animation.pose.LocalSpacePose;
import com.trainguy9512.locomotion.animation.pose.function.MirrorFunction;
import com.trainguy9512.locomotion.animation.pose.function.PoseFunction;
import com.trainguy9512.locomotion.animation.pose.function.SequencePlayerFunction;
import com.trainguy9512.locomotion.animation.pose.function.cache.CachedPoseContainer;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateAlias;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateDefinition;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateMachineFunction;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateTransition;
import com.trainguy9512.locomotion.util.Easing;
import com.trainguy9512.locomotion.util.TimeSpan;
import com.trainguy9512.locomotion.util.Transition;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_9278;
import net.minecraft.class_9334;

public class FirstPersonTwoHandedActions {
    public static final String TWO_HANDED_ACTION_NORMAL_STATE = "normal";
    public static final String TWO_HANDED_ACTION_BOW_PULL_MAIN_HAND_STATE = "bow_pull_main_hand";
    public static final String TWO_HANDED_ACTION_BOW_PULL_OFF_HAND_STATE = "bow_pull_off_hand";
    public static final String TWO_HANDED_ACTION_BOW_RELEASE_MAIN_HAND_STATE = "bow_release_main_hand";
    public static final String TWO_HANDED_ACTION_BOW_RELEASE_OFF_HAND_STATE = "bow_release_off_hand";
    public static final String TWO_HANDED_ACTION_CROSSBOW_RELOAD_MAIN_HAND_STATE = "crossbow_reload_main_hand";
    public static final String TWO_HANDED_ACTION_CROSSBOW_RELOAD_MAIN_OFF_STATE = "crossbow_reload_off_hand";
    public static final String TWO_HANDED_ACTION_CROSSBOW_FINISH_RELOAD_MAIN_HAND_STATE = "crossbow_finish_reload_main_hand";
    public static final String TWO_HANDED_ACTION_CROSSBOW_FINISH_RELOAD_OFF_HAND_STATE = "crossbow_finish_reload_off_hand";

    public static PoseFunction<LocalSpacePose> constructPoseFunction(PoseFunction<LocalSpacePose> normalPoseFunction, CachedPoseContainer cachedPoseContainer) {
        StateMachineFunction.Builder builder = StateMachineFunction.builder(FirstPersonTwoHandedActions::getTwoHandedEntryState).bindDriverToCurrentActiveState(FirstPersonDrivers.CURRENT_TWO_HANDED_OVERRIDE_STATE).defineState(StateDefinition.builder(TWO_HANDED_ACTION_NORMAL_STATE, normalPoseFunction).resetsPoseFunctionUponEntry(true).build());
        FirstPersonTwoHandedActions.defineBowStatesForHand(builder, class_1268.field_5808);
        FirstPersonTwoHandedActions.defineBowStatesForHand(builder, class_1268.field_5810);
        FirstPersonTwoHandedActions.defineCrossbowStatesForHand(builder, class_1268.field_5808);
        FirstPersonTwoHandedActions.defineCrossbowStatesForHand(builder, class_1268.field_5810);
        return builder.build();
    }

    public static void defineBowStatesForHand(StateMachineFunction.Builder stateMachineBuilder, class_1268 interactionHand) {
        class_1268 oppositeHand = interactionHand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
        String bowPullState = FirstPersonTwoHandedActions.getBowPullState(interactionHand);
        String bowReleaseState = FirstPersonTwoHandedActions.getBowReleaseState(interactionHand);
        PoseFunction<LocalSpacePose> pullPoseFunction = ((SequencePlayerFunction.Builder)((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_BOW_PULL).bindToTimeMarker("arrow_placed_in_bow", evaluationState -> {
            evaluationState.driverContainer().getDriver(FirstPersonDrivers.getRenderedItemDriver(oppositeHand)).setValue(class_1799.field_8037);
            evaluationState.driverContainer().getDriver(FirstPersonDrivers.getHandPoseDriver(oppositeHand)).setValue(FirstPersonHandPose.EMPTY);
            evaluationState.driverContainer().getDriver(FirstPersonDrivers.getGenericItemPoseDriver(oppositeHand)).setValue(FirstPersonGenericItems.getFallback());
        })).bindToTimeMarker("get_new_arrow", evaluationState -> {})).build();
        PoseFunction<LocalSpacePose> releasePoseFunction = SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_BOW_RELEASE).build();
        BlendProfile releaseBlendProfile = BlendProfile.builder().defineForCustomAttribute("is_using_property", 0.0f).defineForCustomAttribute("use_duration_property", 0.0f).build();
        if (interactionHand == class_1268.field_5810) {
            pullPoseFunction = MirrorFunction.of(pullPoseFunction);
            releasePoseFunction = MirrorFunction.of(releasePoseFunction);
        }
        BlendProfile blendOffhandArrowMoreQuickly = BlendProfile.builder().defineForJoint("hand_L_jnt", 0.2f).build();
        if (interactionHand == class_1268.field_5810) {
            blendOffhandArrowMoreQuickly = blendOffhandArrowMoreQuickly.getMirrored();
        }
        stateMachineBuilder.defineState(StateDefinition.builder(bowPullState, pullPoseFunction).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(bowReleaseState).isTakenIfTrue(StateTransition.takeIfBooleanDriverTrue(FirstPersonDrivers.getUsingItemDriver(interactionHand)).negate().and(StateTransition.CURRENT_TRANSITION_FINISHED)).bindToOnTransitionTaken(evaluationState -> {
            evaluationState.driverContainer().getDriver(FirstPersonDrivers.getRenderedItemDriver(oppositeHand)).setValue(class_1799.field_8037);
            evaluationState.driverContainer().getDriver(FirstPersonDrivers.getHandPoseDriver(oppositeHand)).setValue(FirstPersonHandPose.EMPTY);
            evaluationState.driverContainer().getDriver(FirstPersonDrivers.getGenericItemPoseDriver(oppositeHand)).setValue(FirstPersonGenericItems.getFallback());
        }).setTiming(Transition.builder(TimeSpan.ofTicks(1.0f)).setBlendProfile(releaseBlendProfile).build()).build()).build()).defineState(StateDefinition.builder(bowReleaseState, releasePoseFunction).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(TWO_HANDED_ACTION_NORMAL_STATE).isTakenOnAnimationFinished(1.0f).setTiming(Transition.builder(TimeSpan.of60FramesPerSecond(20.0f)).build()).build()).build()).addStateAlias(StateAlias.builder(Set.of(TWO_HANDED_ACTION_NORMAL_STATE, bowReleaseState)).addOutboundTransition(StateTransition.builder(bowPullState).isTakenIfTrue(StateTransition.takeIfBooleanDriverTrue(FirstPersonDrivers.getUsingItemDriver(interactionHand)).and(transitionContext -> transitionContext.driverContainer().getDriverValue(FirstPersonDrivers.getHandPoseDriver(interactionHand)) == FirstPersonHandPose.BOW).and(transitionContext -> ((class_1799)transitionContext.driverContainer().getDriverValue(FirstPersonDrivers.getItemDriver(interactionHand))).method_7976() == class_1839.field_8953)).bindToOnTransitionTaken(evaluationState -> {
            class_1799 projectileStack = (class_1799)evaluationState.driverContainer().getDriverValue(FirstPersonDrivers.PROJECTILE_ITEM);
            evaluationState.driverContainer().getDriver(FirstPersonDrivers.getRenderedItemDriver(oppositeHand)).setValue(projectileStack);
            evaluationState.driverContainer().getDriver(FirstPersonDrivers.getGenericItemPoseDriver(oppositeHand)).setValue(FirstPersonGenericItems.getConfigurationFromItem(projectileStack));
            evaluationState.driverContainer().getDriver(FirstPersonDrivers.getHandPoseDriver(oppositeHand)).setValue(FirstPersonHandPose.GENERIC_ITEM);
        }).setTiming(Transition.builder(TimeSpan.of60FramesPerSecond(12.0f)).setEasement(Easing.SINE_IN_OUT).setBlendProfile(blendOffhandArrowMoreQuickly).build()).build()).build()).addStateAlias(StateAlias.builder(Set.of(bowPullState, bowReleaseState)).addOutboundTransition(StateTransition.builder(TWO_HANDED_ACTION_NORMAL_STATE).isTakenIfTrue(transitionContext -> ((class_1799)transitionContext.driverContainer().getDriverValue(FirstPersonDrivers.getItemDriver(interactionHand))).method_7976() != class_1839.field_8953).setTiming(Transition.builder(TimeSpan.of60FramesPerSecond(10.0f)).setEasement(Easing.SINE_IN_OUT).build()).build()).build());
    }

    public static void defineCrossbowStatesForHand(StateMachineFunction.Builder stateMachineBuilder, class_1268 interactionHand) {
        class_1268 oppositeHand = interactionHand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
        String crossbowReloadState = FirstPersonTwoHandedActions.getCrossbowReloadState(interactionHand);
        String crossbowFinishReloadState = FirstPersonTwoHandedActions.getCrossbowFinishReloadState(interactionHand);
        PoseFunction<LocalSpacePose> crossbowReloadPoseFunction = ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_CROSSBOW_RELOAD).setPlayRate(evaluationState -> (Float)evaluationState.driverContainer().getDriverValue(FirstPersonDrivers.CROSSBOW_RELOAD_SPEED))).build();
        PoseFunction<LocalSpacePose> crossbowFinishReloadPoseFunction = SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_CROSSBOW_RELOAD_FINISH).build();
        Predicate<StateTransition.TransitionContext> isReloadingEmptyCrossbow = transitionContext -> {
            if (!transitionContext.driverContainer().getDriver(FirstPersonDrivers.getUsingItemDriver(interactionHand)).getPreviousValue().booleanValue()) {
                return false;
            }
            if (transitionContext.driverContainer().getDriverValue(FirstPersonDrivers.getHandPoseDriver(interactionHand)) != FirstPersonHandPose.CROSSBOW) {
                return false;
            }
            if (((class_1799)transitionContext.driverContainer().getDriverValue(FirstPersonDrivers.getItemDriver(interactionHand))).method_7976() != class_1839.field_8947) {
                return false;
            }
            class_9278 chargedProjectiles = (class_9278)transitionContext.driverContainer().getDriver(FirstPersonDrivers.getItemDriver(interactionHand)).getCurrentValue().method_58694(class_9334.field_49649);
            if (chargedProjectiles == null) {
                return false;
            }
            return chargedProjectiles.method_57442();
        };
        if (interactionHand == class_1268.field_5810) {
            crossbowReloadPoseFunction = MirrorFunction.of(crossbowReloadPoseFunction);
            crossbowFinishReloadPoseFunction = MirrorFunction.of(crossbowFinishReloadPoseFunction);
        }
        stateMachineBuilder.defineState(StateDefinition.builder(crossbowReloadState, crossbowReloadPoseFunction).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(crossbowFinishReloadState).isTakenIfTrue(isReloadingEmptyCrossbow.negate()).bindToOnTransitionTaken(evaluationState -> FirstPersonDrivers.updateRenderedItem(evaluationState.driverContainer(), interactionHand)).setTiming(Transition.SINGLE_TICK).build()).build()).defineState(StateDefinition.builder(crossbowFinishReloadState, crossbowFinishReloadPoseFunction).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(TWO_HANDED_ACTION_NORMAL_STATE).isTakenOnAnimationFinished(1.0f).setTiming(Transition.builder(TimeSpan.of60FramesPerSecond(20.0f)).build()).build()).build()).addStateAlias(StateAlias.builder(Set.of(TWO_HANDED_ACTION_NORMAL_STATE)).addOutboundTransition(StateTransition.builder(crossbowReloadState).isTakenIfTrue(isReloadingEmptyCrossbow).bindToOnTransitionTaken(evaluationState -> {
            evaluationState.driverContainer().getDriver(FirstPersonDrivers.getRenderedItemDriver(oppositeHand)).setValue(class_1799.field_8037);
            evaluationState.driverContainer().getDriver(FirstPersonDrivers.getHandPoseDriver(oppositeHand)).setValue(FirstPersonHandPose.EMPTY);
            evaluationState.driverContainer().getDriver(FirstPersonDrivers.getGenericItemPoseDriver(oppositeHand)).setValue(FirstPersonGenericItems.getFallback());
        }).setTiming(Transition.builder(TimeSpan.of60FramesPerSecond(12.0f)).setEasement(Easing.SINE_IN_OUT).build()).build()).build()).addStateAlias(StateAlias.builder(Set.of(crossbowReloadState, crossbowFinishReloadState)).addOutboundTransition(StateTransition.builder(TWO_HANDED_ACTION_NORMAL_STATE).isTakenIfTrue(transitionContext -> ((class_1799)transitionContext.driverContainer().getDriverValue(FirstPersonDrivers.getItemDriver(interactionHand))).method_7976() != class_1839.field_8947).setTiming(Transition.builder(TimeSpan.of60FramesPerSecond(10.0f)).setEasement(Easing.SINE_IN_OUT).build()).bindToOnTransitionTaken(evaluationState -> {}).build()).build());
    }

    private static String getTwoHandedEntryState(PoseFunction.FunctionEvaluationState evaluationState) {
        return TWO_HANDED_ACTION_NORMAL_STATE;
    }

    private static String getBowPullState(class_1268 hand) {
        return switch (hand) {
            default -> throw new MatchException(null, null);
            case class_1268.field_5808 -> TWO_HANDED_ACTION_BOW_PULL_MAIN_HAND_STATE;
            case class_1268.field_5810 -> TWO_HANDED_ACTION_BOW_PULL_OFF_HAND_STATE;
        };
    }

    private static String getBowReleaseState(class_1268 hand) {
        return switch (hand) {
            default -> throw new MatchException(null, null);
            case class_1268.field_5808 -> TWO_HANDED_ACTION_BOW_RELEASE_MAIN_HAND_STATE;
            case class_1268.field_5810 -> TWO_HANDED_ACTION_BOW_RELEASE_OFF_HAND_STATE;
        };
    }

    private static String getCrossbowReloadState(class_1268 hand) {
        return switch (hand) {
            default -> throw new MatchException(null, null);
            case class_1268.field_5808 -> TWO_HANDED_ACTION_CROSSBOW_RELOAD_MAIN_HAND_STATE;
            case class_1268.field_5810 -> TWO_HANDED_ACTION_CROSSBOW_RELOAD_MAIN_OFF_STATE;
        };
    }

    private static String getCrossbowFinishReloadState(class_1268 hand) {
        return switch (hand) {
            default -> throw new MatchException(null, null);
            case class_1268.field_5808 -> TWO_HANDED_ACTION_CROSSBOW_FINISH_RELOAD_MAIN_HAND_STATE;
            case class_1268.field_5810 -> TWO_HANDED_ACTION_CROSSBOW_FINISH_RELOAD_OFF_HAND_STATE;
        };
    }
}

