/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.joint.skeleton;

import com.google.common.collect.Maps;
import com.trainguy9512.locomotion.animation.joint.JointChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_5603;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JointSkeleton {
    private static final Logger LOGGER = LogManager.getLogger((String)"Locomotion.JointSkeleton");
    private final Map<String, JointConfiguration> joints;
    private final String rootJoint;
    private final Map<String, Float> customAttributeDefaults;

    private JointSkeleton(Map<String, JointConfiguration> joints, String rootJoint, Map<String, Float> customAttributeDefaults) {
        this.joints = joints;
        this.rootJoint = rootJoint;
        this.customAttributeDefaults = customAttributeDefaults;
    }

    public static Builder of(String rootJoint) {
        return new Builder(rootJoint);
    }

    public Map<String, Float> getCustomAttributeDefaults() {
        return new HashMap<String, Float>(this.customAttributeDefaults);
    }

    public Set<String> getCustomAttributes() {
        return this.customAttributeDefaults.keySet();
    }

    public boolean containsCustomAttribute(String customAttributeName) {
        return this.customAttributeDefaults.containsKey(customAttributeName);
    }

    public List<String> getDirectChildrenOfJoint(String joint) {
        return this.joints.get(joint).children();
    }

    public boolean jointIsParentOfChild(String parent, String child) {
        return Objects.equals(this.joints.get(child).parent(), parent);
    }

    public void printHierarchy() {
        this.printHierarchyChild(this.getRootJoint(), 1);
        LOGGER.info("--".concat(this.getRootJoint()));
    }

    private void printHierarchyChild(String joint, int size) {
        String dashes = "";
        for (int i = 0; i <= size; ++i) {
            dashes = dashes.concat("--");
        }
        String finalDashes = dashes;
        this.getDirectChildrenOfJoint(joint).forEach(child -> {
            LOGGER.info(finalDashes.concat((String)child));
            this.printHierarchyChild((String)child, size + 1);
        });
    }

    public String getRootJoint() {
        return this.rootJoint;
    }

    public Set<String> getJoints() {
        return this.joints.keySet();
    }

    public JointConfiguration getJointConfiguration(String joint) {
        return this.joints.get(joint);
    }

    public boolean containsJoint(String joint) {
        return this.joints.containsKey(joint);
    }

    public static class Builder {
        private final Map<String, JointConfiguration> joints = Maps.newHashMap();
        private final String rootJoint;
        private final Map<String, Float> customAttributeDefaults;

        protected Builder(String rootJoint) {
            this.rootJoint = rootJoint;
            this.customAttributeDefaults = Maps.newHashMap();
        }

        public Builder defineJoint(String jointName, JointConfiguration jointConfiguration) {
            this.joints.put(jointName, jointConfiguration);
            return this;
        }

        public Builder defineCustomAttribute(String customAttributeName, float defaultValue) {
            this.customAttributeDefaults.put(customAttributeName, Float.valueOf(defaultValue));
            return this;
        }

        public JointSkeleton build() {
            HashMap jointsBuilt = Maps.newHashMap();
            return new JointSkeleton(this.joints, this.rootJoint, this.customAttributeDefaults);
        }
    }

    public record JointConfiguration(String parent, List<String> children, JointChannel referencePose, String mirrorJoint, String modelPartIdentifier, class_5603 modelPartOffset) {
        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String parent = null;
            private final List<String> children = new ArrayList<String>();
            private JointChannel referencePose;
            private String mirrorJoint = null;
            private String modelPartIdentifier = null;
            private class_5603 modelPartOffset = class_5603.field_27701;

            private Builder() {
            }

            public Builder addChild(String child) {
                this.children.add(child);
                return this;
            }

            public Builder setParent(String parent) {
                this.parent = parent;
                return this;
            }

            public Builder setReferencePose(JointChannel referencePose) {
                this.referencePose = referencePose;
                return this;
            }

            public Builder setMirrorJoint(String mirrorJoint) {
                this.mirrorJoint = mirrorJoint;
                return this;
            }

            public Builder setModelPartIdentifier(String modelPartIdentifier) {
                this.modelPartIdentifier = modelPartIdentifier;
                return this;
            }

            public Builder setModelPartOffset(class_5603 modelPartOffset) {
                this.modelPartOffset = modelPartOffset;
                return this;
            }

            public JointConfiguration build() {
                return new JointConfiguration(this.parent, this.children, this.referencePose, this.mirrorJoint, this.modelPartIdentifier, this.modelPartOffset);
            }
        }
    }
}

