/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.pose;

import com.google.common.collect.Maps;
import com.trainguy9512.locomotion.animation.joint.JointChannel;
import com.trainguy9512.locomotion.animation.joint.skeleton.JointSkeleton;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_4587;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public abstract class Pose {
    protected final JointSkeleton jointSkeleton;
    protected final Map<String, JointChannel> jointChannels;
    protected final Map<String, Float> customAttributes;
    private final Map<String, Matrix4f> jointParentMatrices;

    protected Pose(JointSkeleton jointSkeleton) {
        this.jointSkeleton = jointSkeleton;
        this.jointChannels = Maps.newHashMap();
        this.customAttributes = jointSkeleton.getCustomAttributeDefaults();
        this.jointParentMatrices = Maps.newHashMap();
        for (String joint : jointSkeleton.getJoints()) {
            this.setJointChannel(joint, jointSkeleton.getJointConfiguration(joint).referencePose());
        }
    }

    protected Pose(Pose pose) {
        this.jointSkeleton = pose.jointSkeleton;
        this.jointChannels = Maps.newHashMap();
        pose.jointChannels.forEach((joint, channel) -> {
            JointChannel duplicateJointChannel = JointChannel.of(channel);
            this.jointChannels.put((String)joint, duplicateJointChannel);
        });
        this.customAttributes = new HashMap<String, Float>(pose.customAttributes);
        this.jointParentMatrices = new HashMap<String, Matrix4f>(pose.jointParentMatrices);
    }

    public JointSkeleton getJointSkeleton() {
        return this.jointSkeleton;
    }

    public void setJointChannel(String joint, JointChannel jointChannel) {
        if (this.jointSkeleton.containsJoint(joint)) {
            this.jointChannels.put(joint, jointChannel);
        }
    }

    public JointChannel getJointChannel(String joint) {
        return JointChannel.of(this.jointChannels.getOrDefault(joint, JointChannel.ZERO));
    }

    public void setIdentity() {
        this.jointChannels.values().forEach(JointChannel::setIdentity);
    }

    public void loadCustomAttributeValue(String customAttributeName, float value) {
        this.customAttributes.put(customAttributeName, Float.valueOf(value));
    }

    public float getCustomAttributeValue(String customAttributeName) {
        if (!this.customAttributes.containsKey(customAttributeName)) {
            throw new IllegalArgumentException("Custom attribute \"" + customAttributeName + "\" cannot be accessed from pose, not included in the following curves: " + String.valueOf(this.customAttributes.keySet()));
        }
        return this.customAttributes.get(customAttributeName).floatValue();
    }

    public boolean getCustomAttributeValueAsBoolean(String customAttributeName) {
        return (double)this.getCustomAttributeValue(customAttributeName) > 0.5;
    }

    public void copyCustomAttributesFrom(Pose other) {
        this.customAttributes.putAll(other.customAttributes);
    }

    protected void convertChildrenJointsToComponentSpace(String parent, class_4587 poseStack) {
        JointChannel localParentJointChannel = this.getJointChannel(parent);
        poseStack.method_22903();
        poseStack.method_34425((Matrix4fc)localParentJointChannel.getTransform());
        this.getJointSkeleton().getDirectChildrenOfJoint(parent).forEach(child -> this.convertChildrenJointsToComponentSpace((String)child, poseStack));
        Matrix4f componentSpaceMatrix = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        this.jointParentMatrices.put(parent, componentSpaceMatrix);
        this.setJointChannel(parent, JointChannel.of(componentSpaceMatrix, localParentJointChannel.getVisibility()));
        poseStack.method_22909();
    }

    protected void convertChildrenJointsToLocalSpace(String parent, Matrix4f parentMatrix) {
        this.getJointSkeleton().getDirectChildrenOfJoint(parent).forEach(child -> this.convertChildrenJointsToLocalSpace((String)child, this.jointParentMatrices.get(parent)));
        JointChannel parentJointChannel = this.getJointChannel(parent);
        parentJointChannel.multiply(parentMatrix.invert(new Matrix4f()), JointChannel.TransformSpace.LOCAL, JointChannel.TransformType.ADD);
        this.setJointChannel(parent, parentJointChannel);
    }
}

