/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.pose.function.statemachine;

import com.google.common.collect.Maps;
import com.trainguy9512.locomotion.animation.driver.DriverKey;
import com.trainguy9512.locomotion.animation.driver.VariableDriver;
import com.trainguy9512.locomotion.animation.pose.LocalSpacePose;
import com.trainguy9512.locomotion.animation.pose.function.PoseFunction;
import com.trainguy9512.locomotion.animation.pose.function.TimeBasedPoseFunction;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateAlias;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateDefinition;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateTransition;
import com.trainguy9512.locomotion.util.TimeSpan;
import com.trainguy9512.locomotion.util.Transition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StateMachineFunction
extends TimeBasedPoseFunction<LocalSpacePose> {
    private static final Logger LOGGER = LogManager.getLogger((String)"Locomotion/StateMachineFunction");
    private final Map<String, StateDefinition> states;
    private final Function<PoseFunction.FunctionEvaluationState, String> initialStateFunction;
    private final List<StateBlendLayer> stateBlendLayerStack;
    private long lastUpdateTick;
    private final boolean resetsUponRelevant;
    private final List<DriverKey<VariableDriver<String>>> driversToUpdateOnStateChanged;

    private StateMachineFunction(Map<String, StateDefinition> states, Function<PoseFunction.FunctionEvaluationState, String> initialStateFunction, boolean resetsUponRelevant, List<DriverKey<VariableDriver<String>>> driversToUpdateOnStateChanged) {
        super(evaluationState -> true, evaluationState -> Float.valueOf(1.0f), TimeSpan.ZERO);
        this.states = states;
        this.initialStateFunction = initialStateFunction;
        this.stateBlendLayerStack = new ArrayList<StateBlendLayer>();
        this.lastUpdateTick = 0L;
        this.resetsUponRelevant = resetsUponRelevant;
        this.driversToUpdateOnStateChanged = driversToUpdateOnStateChanged;
    }

    @Override
    @NotNull
    public LocalSpacePose compute(PoseFunction.FunctionInterpolationContext context) {
        if (this.stateBlendLayerStack.isEmpty()) {
            LOGGER.error("State machine active states list found to be empty. Throwing error...");
            LOGGER.error("States in state machine: {}", this.states.keySet());
            throw new IllegalStateException("State machine found to have no active states");
        }
        Set<String> uniqueStatesInLayerStack = this.getStatesInLayerStack();
        HashMap layerStackPoses = Maps.newHashMapWithExpectedSize((int)uniqueStatesInLayerStack.size());
        for (String stateIdentifier : uniqueStatesInLayerStack) {
            layerStackPoses.put(stateIdentifier, this.states.get((Object)stateIdentifier).inputFunction.compute(context));
        }
        LocalSpacePose pose = (LocalSpacePose)layerStackPoses.get(this.stateBlendLayerStack.getFirst().identifier);
        if (this.stateBlendLayerStack.size() > 1) {
            for (StateBlendLayer stateBlendLayer : this.stateBlendLayerStack.subList(1, this.stateBlendLayerStack.size())) {
                pose.interpolatedByTransition((LocalSpacePose)layerStackPoses.get(stateBlendLayer.identifier), stateBlendLayer.weight.getValueInterpolated(context.partialTicks()).floatValue(), stateBlendLayer.entranceTransition.transition(), null);
            }
        }
        return pose;
    }

    @Override
    public void tick(PoseFunction.FunctionEvaluationState evaluationState) {
        super.tick(evaluationState);
        this.takeInitialStateIfResetting(evaluationState);
        this.lastUpdateTick = evaluationState.currentTick();
        Optional<StateTransition> potentialStateTransition = this.testForOutboundTransition(evaluationState);
        String stateBeingEntered = null;
        if (potentialStateTransition.isPresent()) {
            StateTransition transition = potentialStateTransition.get();
            this.takeTransition(evaluationState, transition);
            stateBeingEntered = transition.target();
        }
        this.stateBlendLayerStack.forEach(StateBlendLayer::tick);
        this.popOverriddenStates();
        this.tickPoseFunctionsInActiveStates(evaluationState, stateBeingEntered);
    }

    private void takeInitialStateIfResetting(PoseFunction.FunctionEvaluationState evaluationState) {
        boolean hasBecomeRelevant;
        boolean layerStackIsEmpty = this.stateBlendLayerStack.isEmpty();
        boolean bl = hasBecomeRelevant = evaluationState.currentTick() - 1L > this.lastUpdateTick;
        if (layerStackIsEmpty || hasBecomeRelevant && this.resetsUponRelevant) {
            this.stateBlendLayerStack.clear();
            String initialStateIdentifier = this.initialStateFunction.apply(evaluationState);
            if (this.states.containsKey(initialStateIdentifier)) {
                this.stateBlendLayerStack.addLast(new StateBlendLayer(initialStateIdentifier, StateTransition.builder(initialStateIdentifier).setTiming(Transition.INSTANT).isTakenIfTrue(transitionContext -> true).build()));
            } else {
                throw new IllegalStateException("Initial state " + initialStateIdentifier + " not found to be present in the state machine");
            }
        }
    }

    private Optional<StateTransition> testForOutboundTransition(PoseFunction.FunctionEvaluationState evaluationState) {
        String currentActiveStateIdentifier = this.stateBlendLayerStack.getLast().identifier;
        StateDefinition currentActiveStateDefinition = this.states.get(currentActiveStateIdentifier);
        return currentActiveStateDefinition.outboundTransitions.stream().filter(stateTransition -> {
            boolean targetIsNotCurrentActiveState;
            boolean transitionTargetIncludedInThisMachine = this.states.containsKey(stateTransition.target());
            boolean bl = targetIsNotCurrentActiveState = !Objects.equals(stateTransition.target(), currentActiveStateIdentifier);
            if (transitionTargetIncludedInThisMachine && targetIsNotCurrentActiveState) {
                StateTransition.TransitionContext transitionContext = StateTransition.TransitionContext.of(evaluationState.driverContainer(), TimeSpan.ofTicks(((Float)this.ticksElapsed.getCurrentValue()).floatValue()), this.stateBlendLayerStack.getLast().weight.getCurrentValue().floatValue(), this.stateBlendLayerStack.getLast().weight.getPreviousValue().floatValue(), this.states.get((Object)currentActiveStateIdentifier).inputFunction, stateTransition.transition().duration());
                return stateTransition.conditionPredicate().test(transitionContext);
            }
            return false;
        }).collect(Collectors.collectingAndThen(Collectors.toList(), collected -> {
            Collections.shuffle(collected);
            return collected;
        })).stream().sorted().findFirst();
    }

    private void takeTransition(PoseFunction.FunctionEvaluationState evaluationState, StateTransition transition) {
        transition.onTransitionTakenListener().accept(evaluationState);
        this.driversToUpdateOnStateChanged.forEach(driverKey -> {
            LOGGER.info(driverKey.getIdentifier());
            ((VariableDriver)evaluationState.driverContainer().getDriver(driverKey)).setValue(transition.target());
        });
        this.stateBlendLayerStack.addLast(new StateBlendLayer(transition.target(), transition));
        this.resetTime();
    }

    private void popOverriddenStates() {
        boolean higherStateIsFullyOverriding = false;
        ArrayList<StateBlendLayer> inactiveLayers = new ArrayList<StateBlendLayer>();
        for (StateBlendLayer stateBlendLayer : this.stateBlendLayerStack.reversed()) {
            if (higherStateIsFullyOverriding) {
                inactiveLayers.add(stateBlendLayer);
                continue;
            }
            if (!stateBlendLayer.isIsFullyActive) continue;
            higherStateIsFullyOverriding = true;
        }
        this.stateBlendLayerStack.removeAll(inactiveLayers);
    }

    private void tickPoseFunctionsInActiveStates(PoseFunction.FunctionEvaluationState evaluationState, @Nullable String stateBeingEntered) {
        for (String stateIdentifier : this.getStatesInLayerStack()) {
            StateDefinition stateDefinition = this.states.get(stateIdentifier);
            PoseFunction<LocalSpacePose> statePoseFunction = stateDefinition.inputFunction;
            boolean shouldResetStatePoseFunction = Objects.equals(stateBeingEntered, stateIdentifier) && stateDefinition.resetUponEntry;
            statePoseFunction.tick(shouldResetStatePoseFunction ? evaluationState.markedForReset() : evaluationState);
        }
    }

    private Set<String> getStatesInLayerStack() {
        HashSet<String> set = new HashSet<String>();
        this.stateBlendLayerStack.forEach(stateBlendLayer -> set.add(stateBlendLayer.identifier));
        return set;
    }

    @Override
    public PoseFunction<LocalSpacePose> wrapUnique() {
        Builder builder = StateMachineFunction.builder(this.initialStateFunction);
        builder.resetsUponRelevant(this.resetsUponRelevant);
        this.driversToUpdateOnStateChanged.forEach(builder::bindDriverToCurrentActiveState);
        this.states.forEach((identifier, state) -> builder.defineState(StateDefinition.builder(state).wrapUniquePoseFunction().build()));
        return builder.build();
    }

    @Override
    public Optional<PoseFunction<?>> searchDownChainForMostRelevant(Predicate<PoseFunction<?>> findCondition) {
        if (findCondition.test(this)) {
            return Optional.of(this);
        }
        for (StateBlendLayer stateBlendLayer : this.stateBlendLayerStack.reversed()) {
            Optional<PoseFunction<?>> potentialPlayer = this.states.get((Object)stateBlendLayer.identifier).inputFunction.searchDownChainForMostRelevant(findCondition);
            if (!potentialPlayer.isPresent()) continue;
            return potentialPlayer;
        }
        return Optional.empty();
    }

    public static Builder builder(Function<PoseFunction.FunctionEvaluationState, String> entryStateFunction) {
        return new Builder(entryStateFunction);
    }

    private static class StateBlendLayer {
        private final String identifier;
        private final StateTransition entranceTransition;
        private final VariableDriver<Float> weight;
        private final float weightIncrement;
        private boolean isIsFullyActive;

        private StateBlendLayer(String identifier, StateTransition entranceTransition) {
            this.identifier = identifier;
            this.entranceTransition = entranceTransition;
            this.weight = VariableDriver.ofFloat(() -> Float.valueOf(0.0f));
            this.weightIncrement = 1.0f / Math.max(this.entranceTransition.transition().duration().inTicks(), 0.01f);
            this.isIsFullyActive = false;
        }

        private void tick() {
            this.weight.pushCurrentToPrevious();
            this.weight.modifyValue(currentValue -> Float.valueOf(Math.min(1.0f, currentValue.floatValue() + this.weightIncrement)));
            if (this.weight.getCurrentValue().floatValue() == 1.0f && this.weight.getPreviousValue().floatValue() == 1.0f) {
                this.isIsFullyActive = true;
            }
        }

        public String toString() {
            return "StateBlendLayer{" + this.identifier + " " + String.valueOf(this.weight.getCurrentValue()) + "}";
        }
    }

    public static class Builder {
        private final Function<PoseFunction.FunctionEvaluationState, String> initialState;
        private final Map<String, StateDefinition> states;
        private final List<StateAlias> stateAliases;
        private boolean resetUponRelevant;
        private final List<DriverKey<VariableDriver<String>>> driversToUpdateOnStateChanged;

        protected Builder(Function<PoseFunction.FunctionEvaluationState, String> initialState) {
            this.initialState = initialState;
            this.states = Maps.newHashMap();
            this.stateAliases = new ArrayList<StateAlias>();
            this.resetUponRelevant = false;
            this.driversToUpdateOnStateChanged = new ArrayList<DriverKey<VariableDriver<String>>>();
        }

        public Builder defineState(StateDefinition stateDefinition) {
            if (this.states.containsKey(stateDefinition.identifier)) {
                throw new IllegalStateException("Cannot add state " + stateDefinition.identifier + " twice to the same state machine.");
            }
            this.states.put(stateDefinition.identifier, stateDefinition);
            return this;
        }

        public Builder resetsUponRelevant(boolean resetUponRelevant) {
            this.resetUponRelevant = resetUponRelevant;
            return this;
        }

        public Builder addStateAlias(StateAlias stateAlias) {
            this.stateAliases.add(stateAlias);
            return this;
        }

        public Builder bindDriverToCurrentActiveState(DriverKey<VariableDriver<String>> driverKey) {
            this.driversToUpdateOnStateChanged.add(driverKey);
            return this;
        }

        public PoseFunction<LocalSpacePose> build() {
            for (StateAlias stateAlias : this.stateAliases) {
                for (String originState : stateAlias.originStates()) {
                    if (this.states.containsKey(originState)) {
                        StateDefinition.Builder stateBuilder = StateDefinition.builder(this.states.get(originState));
                        this.states.put(originState, stateBuilder.addOutboundTransitions(stateAlias.outboundTransitions()).build());
                        continue;
                    }
                    LOGGER.error("Failed to apply state alias for state {}, as it hasn't been added to the state machine builder.", (Object)originState);
                    throw new IllegalArgumentException("State machine transition validation failed, state alias contains states not found in state machine.");
                }
            }
            for (StateDefinition stateDefinition : this.states.values()) {
                for (StateTransition transition : stateDefinition.outboundTransitions) {
                    if (this.states.containsKey(transition.target())) continue;
                    LOGGER.error("State transition from states {} to {} not valid because state {} is not present in the state machine.", (Object)stateDefinition.identifier, (Object)transition.target(), (Object)transition.target());
                    throw new IllegalArgumentException("State machine transition validation failed, transition target not found in state machine.");
                }
            }
            for (StateDefinition stateDefinition : this.states.values()) {
                if (!stateDefinition.outboundTransitions.isEmpty()) continue;
                LOGGER.warn("State {} in state machine contains no outbound transitions. If this state is entered, it will have no valid path out without re-initializing the state!", (Object)stateDefinition.identifier);
            }
            return new StateMachineFunction(this.states, this.initialState, this.resetUponRelevant, this.driversToUpdateOnStateChanged);
        }
    }
}

