/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.render;

import com.trainguy9512.locomotion.access.FirstPersonSingleBlockRenderer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_11659;
import net.minecraft.class_1306;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class FirstPersonBlockItemRenderer {
    private static List<BlockRenderConfiguration> BLOCK_RENDER_CONFIGURATIONS = new ArrayList<BlockRenderConfiguration>();

    public static void register(BlockRenderConfiguration blockRenderConfiguration) {
        BLOCK_RENDER_CONFIGURATIONS.add(blockRenderConfiguration);
        BLOCK_RENDER_CONFIGURATIONS = new ArrayList<BlockRenderConfiguration>(BLOCK_RENDER_CONFIGURATIONS.stream().sorted(Comparator.comparingInt(BlockRenderConfiguration::evaluationPriority).reversed()).toList());
    }

    public static void renderSingleBlock(BlockSubmitContext context) {
        FirstPersonBlockItemRenderer.submitSingleBlock(context.nodeCollector(), context.poseStack(), context.blockState(), context.combinedLight());
    }

    public static void renderDoorBlock(BlockSubmitContext context) {
        FirstPersonBlockItemRenderer.submitSingleBlock(context.nodeCollector(), context.poseStack(), context.blockState(), context.combinedLight());
        FirstPersonBlockItemRenderer.renderUpperHalfBlock(context);
    }

    private static void renderUpperHalfBlock(BlockSubmitContext context) {
        context.poseStack().method_46416(0.0f, 1.0f, 0.0f);
        class_2680 upperHalfBlockstate = (class_2680)context.blockState().method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609);
        FirstPersonBlockItemRenderer.submitSingleBlock(context.nodeCollector(), context.poseStack(), upperHalfBlockstate, context.combinedLight());
    }

    public static void submit(class_1799 itemStack, class_4587 poseStack, class_11659 nodeCollector, int combinedLight, class_1306 side) {
        class_1792 class_17922 = itemStack.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return;
        }
        class_1747 blockItem = (class_1747)class_17922;
        if (side == class_1306.field_6182) {
            poseStack.method_46416(-1.0f, 0.0f, 0.0f);
        }
        class_2248 block = blockItem.method_7711();
        class_2680 blockState = block.method_9564();
        for (BlockRenderConfiguration configuration : BLOCK_RENDER_CONFIGURATIONS) {
            if (!configuration.shouldChoose().test(block)) continue;
            configuration.renderer.accept(new BlockSubmitContext(blockState, poseStack, nodeCollector, combinedLight, side));
            return;
        }
    }

    private static void submitSingleBlock(class_11659 nodeCollector, class_4587 poseStack, class_2680 blockState, int combinedLight) {
        ((FirstPersonSingleBlockRenderer)class_310.method_1551().method_1541()).locomotion$submitSingleBlockWithEmission(blockState, poseStack, nodeCollector, combinedLight);
    }

    static {
        FirstPersonBlockItemRenderer.register(BlockRenderConfiguration.of(FirstPersonBlockItemRenderer::renderSingleBlock, block -> true, 0));
        FirstPersonBlockItemRenderer.register(BlockRenderConfiguration.of(FirstPersonBlockItemRenderer::renderDoorBlock, block -> block instanceof class_2323, 10));
    }

    public record BlockSubmitContext(class_2680 blockState, class_4587 poseStack, class_11659 nodeCollector, int combinedLight, class_1306 side) {
    }

    public record BlockRenderConfiguration(Consumer<BlockSubmitContext> renderer, Predicate<class_2248> shouldChoose, int evaluationPriority) {
        public static BlockRenderConfiguration of(Consumer<BlockSubmitContext> renderer, Predicate<class_2248> shouldChoose, int evaluationPriority) {
            return new BlockRenderConfiguration(renderer, shouldChoose, evaluationPriority);
        }
    }
}

