/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.resource;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.trainguy9512.locomotion.animation.joint.skeleton.JointSkeleton;
import com.trainguy9512.locomotion.animation.sequence.AnimationSequence;
import com.trainguy9512.locomotion.resource.json.GsonConfiguration;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3518;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocomotionResources
implements class_3302 {
    private static final Logger LOGGER = LogManager.getLogger((String)"Locomotion/Resources");
    public static final class_2960 RELOADER_IDENTIFIER = class_2960.method_60655((String)"locomotion", (String)"locomotion_asset_loader");
    private static final String JOINT_SKELETON_PATH = "skeletons";
    private static final String ANIMATION_SEQUENCE_PATH = "sequences";
    private static final Map<class_2960, AnimationSequence> ANIMATION_SEQUENCES;
    private static final Map<class_2960, JointSkeleton> JOINT_SKELETONS;

    public static Map<class_2960, JointSkeleton> getJointSkeletons() {
        return JOINT_SKELETONS;
    }

    public static Map<class_2960, AnimationSequence> getAnimationSequences() {
        return ANIMATION_SEQUENCES;
    }

    public static JointSkeleton getOrThrowJointSkeleton(class_2960 jointSkeletonLocation) {
        if (JOINT_SKELETONS.containsKey(jointSkeletonLocation)) {
            return JOINT_SKELETONS.get(jointSkeletonLocation);
        }
        throw new IllegalArgumentException("Tried to access joint skeleton from resource location " + String.valueOf(jointSkeletonLocation) + ", but it was not found in the loaded data: " + String.valueOf(JOINT_SKELETONS.keySet()));
    }

    public static AnimationSequence getOrThrowAnimationSequence(class_2960 sequenceLocation) {
        if (ANIMATION_SEQUENCES.containsKey(sequenceLocation)) {
            return ANIMATION_SEQUENCES.get(sequenceLocation);
        }
        throw new IllegalArgumentException("Tried to access animation sequence from resource location " + String.valueOf(sequenceLocation) + ", but it was not found in the loaded data.");
    }

    public CompletableFuture<Void> method_25931(class_3302.class_11558 sharedState, Executor exectutor, class_3302.class_4045 barrier, Executor applyExectutor) {
        CompletableFuture<Map<class_2960, JointSkeleton>> loadedJointSkeletons = LocomotionResources.loadJointSkeletons(sharedState.method_72361(), exectutor);
        CompletableFuture<Map<class_2960, AnimationSequence>> loadedAnimationSequences = LocomotionResources.loadAnimationSequences(sharedState.method_72361(), exectutor);
        return ((CompletableFuture)CompletableFuture.allOf(loadedJointSkeletons, loadedAnimationSequences).thenCompose(arg_0 -> ((class_3302.class_4045)barrier).method_18352(arg_0))).thenCompose(voided -> CompletableFuture.runAsync(() -> {
            JOINT_SKELETONS.clear();
            JOINT_SKELETONS.putAll((Map)loadedJointSkeletons.join());
            ANIMATION_SEQUENCES.clear();
            ANIMATION_SEQUENCES.putAll((Map)loadedAnimationSequences.join());
            ANIMATION_SEQUENCES.replaceAll((resourceLocation, animationSequence) -> animationSequence.getBaked());
            LOGGER.info("Cleared and replaced Locomotion resource data.");
        }));
    }

    private static CompletableFuture<Map<class_2960, AnimationSequence>> loadAnimationSequences(class_3300 manager, Executor backgroundExecutor) {
        return LocomotionResources.loadJsonResources(manager, backgroundExecutor, AnimationSequence.class, ANIMATION_SEQUENCE_PATH, resourceLocation -> LOGGER.info("Successfully loaded animation sequence {}", resourceLocation));
    }

    private static CompletableFuture<Map<class_2960, JointSkeleton>> loadJointSkeletons(class_3300 manager, Executor backgroundExecutor) {
        return LocomotionResources.loadJsonResources(manager, backgroundExecutor, JointSkeleton.class, JOINT_SKELETON_PATH, resourceLocation -> LOGGER.info("Successfully loaded joint skeleton {}", resourceLocation));
    }

    private static <D> CompletableFuture<Map<class_2960, D>> loadJsonResources(class_3300 manager, Executor backgroundExecutor, Class<D> type, String pathToListFrom, Consumer<class_2960> onSuccessfullyLoaded) {
        return CompletableFuture.supplyAsync(() -> {
            Predicate<class_2960> isAssetJson = resourceLocation -> resourceLocation.method_12832().endsWith(".json");
            Map foundResources = manager.method_14488(pathToListFrom, isAssetJson);
            HashMap deserializedResources = Maps.newHashMap();
            foundResources.forEach((resourceLocation, resource) -> {
                try {
                    try (BufferedReader reader = resource.method_43039();){
                        JsonElement jsonElement = (JsonElement)class_3518.method_15276((Gson)GsonConfiguration.getInstance(), (Reader)reader, JsonElement.class);
                        Object deserializedAsset = GsonConfiguration.getInstance().fromJson(jsonElement, type);
                        deserializedResources.put(resourceLocation, deserializedAsset);
                        onSuccessfullyLoaded.accept((class_2960)resourceLocation);
                    }
                    catch (JsonParseException exception) {
                        LOGGER.warn("Skipping loading of JSON asset {} of type {} due to a JSON parsing error:", resourceLocation, (Object)type.getSimpleName());
                        LOGGER.warn("--- {}", (Object)exception.getMessage());
                    }
                }
                catch (IOException exception) {
                    LOGGER.error("Encountered error while reading asset {} of type {}:", resourceLocation, (Object)type.getSimpleName());
                    LOGGER.error("--- {}", (Object)exception.getMessage());
                    throw new RuntimeException(exception);
                }
            });
            return deserializedResources;
        }, backgroundExecutor);
    }

    static {
        JOINT_SKELETONS = Maps.newHashMap();
        ANIMATION_SEQUENCES = Maps.newHashMap();
    }
}

