/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.resource.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.Strictness;
import com.trainguy9512.locomotion.animation.joint.JointChannel;
import com.trainguy9512.locomotion.animation.joint.skeleton.JointSkeleton;
import com.trainguy9512.locomotion.animation.sequence.AnimationSequence;
import com.trainguy9512.locomotion.resource.FormatVersion;
import com.trainguy9512.locomotion.resource.json.AnimationSequenceDeserializer;
import com.trainguy9512.locomotion.resource.json.JointChannelDeserializer;
import com.trainguy9512.locomotion.resource.json.JointSkeletonDeserializer;
import com.trainguy9512.locomotion.resource.json.PartPoseDeserializer;
import net.minecraft.class_5603;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class GsonConfiguration {
    private static Gson GSON = GsonConfiguration.createInternal();

    private static Gson createInternal() {
        return new GsonBuilder().setStrictness(Strictness.STRICT).registerTypeAdapter(Vector3f.class, GsonConfiguration.vector3fDeserializer()).registerTypeAdapter(Quaternionf.class, GsonConfiguration.quaternionDeserializer()).registerTypeAdapter(AnimationSequence.class, (Object)new AnimationSequenceDeserializer()).registerTypeAdapter(JointSkeleton.class, (Object)new JointSkeletonDeserializer()).registerTypeAdapter(FormatVersion.class, FormatVersion.getDeserializer()).registerTypeAdapter(JointChannel.class, (Object)new JointChannelDeserializer()).registerTypeAdapter(class_5603.class, (Object)new PartPoseDeserializer()).create();
    }

    public static Gson getInstance() {
        return GSON;
    }

    public static <D> D deserializeWithFallback(JsonDeserializationContext context, JsonObject json, String key, Class<D> type, D fallback) {
        if (!json.has(key)) {
            return fallback;
        }
        if (json.get(key).isJsonNull()) {
            return null;
        }
        return (D)context.deserialize(json.get(key), type);
    }

    private static JsonDeserializer<Vector3f> vector3fDeserializer() {
        return (jsonElement, type, context) -> {
            JsonArray components = jsonElement.getAsJsonArray();
            return new Vector3f(components.get(0).getAsFloat(), components.get(1).getAsFloat(), components.get(2).getAsFloat());
        };
    }

    private static JsonDeserializer<Quaternionf> quaternionDeserializer() {
        return (jsonElement, type, context) -> {
            JsonArray components = jsonElement.getAsJsonArray();
            return new Quaternionf().rotationZYX(components.get(2).getAsFloat() * ((float)Math.PI / 180), components.get(1).getAsFloat() * ((float)Math.PI / 180), components.get(0).getAsFloat() * ((float)Math.PI / 180));
        };
    }
}

