/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style;

import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.layer.LayerDepth;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipArmorStand;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipDividerLine;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipEffect;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipFrame;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipIcon;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipPanel;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipPreviewBackground;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipRotatingItem;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipText;
import dev.xylonity.tooltipoverhaul.client.style.renderer.DefaultArmorStand;
import dev.xylonity.tooltipoverhaul.client.style.renderer.DefaultIcon;
import dev.xylonity.tooltipoverhaul.client.style.renderer.DefaultRotatingItem;
import dev.xylonity.tooltipoverhaul.client.style.text.DefaultText;
import java.awt.Point;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec2;

public class TooltipStyle {
    private final ITooltipEffect effect;
    private final ITooltipPanel panel;
    private final ITooltipFrame frame;
    private final ITooltipPreviewBackground previewBackground;
    private final ITooltipIcon icon;
    private final ITooltipText text;
    private final ITooltipDividerLine dividerLine;
    private final ITooltipArmorStand armorStand;
    private final ITooltipRotatingItem rotatingItem;

    public TooltipStyle(ITooltipPanel panel, ITooltipFrame innerFrame, ITooltipEffect effect, ITooltipDividerLine dividerLine, ITooltipPreviewBackground iconBackground) {
        this.effect = effect;
        this.panel = panel;
        this.frame = innerFrame;
        this.previewBackground = iconBackground;
        this.icon = new DefaultIcon();
        this.text = new DefaultText();
        this.dividerLine = dividerLine;
        this.armorStand = new DefaultArmorStand();
        this.rotatingItem = new DefaultRotatingItem();
    }

    public void renderBack(LayerDepth depth, TooltipContext ctx, Vec2 pos, Point size) {
        this.panel.render(depth, ctx, pos, size);
    }

    public void renderPreviewBack(LayerDepth depth, TooltipContext ctx, Vec2 pos, Point size) {
        this.previewBackground.render(depth, ctx, pos, size);
    }

    public void renderIcon(LayerDepth depth, TooltipContext ctx, Vec2 pos, Point size) {
        this.icon.render(depth, ctx, pos, size);
    }

    public void renderText(LayerDepth depth, TooltipContext ctx, Vec2 pos, Point size, Component rarity, Font font) {
        this.text.render(depth, ctx, pos, size, rarity, font);
    }

    public void renderDividerLine(LayerDepth depth, TooltipContext ctx, Vec2 pos, Point size) {
        this.dividerLine.render(depth, ctx, pos, size);
    }

    public void renderInnerFrame(LayerDepth depth, TooltipContext ctx, Vec2 pos, Point size) {
        this.frame.render(depth, ctx, pos, size);
    }

    public void renderArmorStand(LayerDepth depth, TooltipContext ctx, Vec2 pos, Point size) {
        this.armorStand.render(depth, ctx, pos, size);
    }

    public void renderRotatingItem(LayerDepth depth, TooltipContext ctx, Vec2 pos, Point size) {
        this.rotatingItem.render(depth, ctx, pos, size);
    }

    public void renderEffect(LayerDepth depth, TooltipContext ctx, Vec2 pos, Point size) {
        if (this.effect != null) {
            this.effect.render(depth, ctx, pos, size);
        }
    }
}

