/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.effect;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.layer.LayerDepth;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipEffect;
import java.awt.Point;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Random;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec2;

public class RipplesEffect
implements ITooltipEffect {
    private static final int RIPPLES = 6;
    private static final int RING_SEGMENTS = 48;
    private static final float THICKNESS = 8.0f;
    private static final float GLOW = 1.75f;
    private static final float TWEAKING = 1.2f;
    private static final float TWEAKING_MULTIPLIER = 10.0f;
    private static final long PER_RIPPLE = 220L;
    private static final int[] DEFAULT_COLORS = new int[]{0x66FFFFFF, -2002724609, 0x66FFD6FF};
    private final Deque<Ripple> ripples = new ArrayDeque<Ripple>();
    private final int[] colors;
    private long lastSpawn = 0L;

    public RipplesEffect() {
        this(DEFAULT_COLORS);
    }

    public RipplesEffect(int[] rippleColors) {
        this.colors = rippleColors == null || rippleColors.length == 0 ? DEFAULT_COLORS : (int[])rippleColors.clone();
    }

    @Override
    public void render(LayerDepth depth, TooltipContext ctx, Vec2 pos, Point size) {
        int guiX = (int)pos.x;
        int guiY = (int)pos.y;
        int guiW = size.x;
        int guiH = size.y;
        int x = (int)pos.x;
        int y = (int)pos.y;
        int w = size.x;
        int h = size.y;
        if (w <= 2 || h <= 2) {
            return;
        }
        ctx.push(() -> {
            ctx.graphics().enableScissor(guiX - 3, guiY - 3, guiX + guiW + 3, guiY + guiH + 3);
            ctx.translate(0.0f, 0.0f, depth.getZ());
            long now = System.currentTimeMillis();
            if (now - this.lastSpawn >= 220L && this.ripples.size() < 6) {
                this.spawnRipple(x, y, w, h, now);
                this.lastSpawn = now;
            }
            GlStateManager._enableBlend();
            GlStateManager._blendFuncSeparate((int)770, (int)1, (int)1, (int)771);
            this.ripples.removeIf(r -> !r.updateAndRender(ctx, now));
            GlStateManager._blendFuncSeparate((int)770, (int)771, (int)770, (int)771);
            GlStateManager._disableBlend();
            ctx.graphics().disableScissor();
        });
    }

    private void spawnRipple(int x, int y, int w, int h, long now) {
        Random random = new Random();
        float margin = 10.0f;
        float cx = (float)x + margin + random.nextFloat() * ((float)w - 2.0f * margin);
        float cy = (float)y + margin + random.nextFloat() * ((float)h - 2.0f * margin);
        float speed = RipplesEffect.lerp(0.75f, 1.35f, random.nextFloat());
        float thickness = 8.0f * RipplesEffect.lerp(0.85f, 1.35f, random.nextFloat());
        float tweakingAmount = random.nextFloat() * ((float)Math.PI * 2);
        if (this.ripples.size() >= 6) {
            this.ripples.pollFirst();
        }
        this.ripples.addLast(new Ripple(cx, cy, 0.5f * (float)Math.hypot(w, h), this.colors[random.nextInt(this.colors.length)], now, speed, thickness, tweakingAmount));
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    private static float easeOutCubic(float t) {
        float u = 1.0f - t;
        return 1.0f - u * u * u;
    }

    private static final class Ripple {
        private final float cx;
        private final float cy;
        private final float maxRadius;
        private final int baseColor;
        private final long birth;
        private final float speed;
        private final float thickness;
        private final float tweaking;

        public Ripple(float cx, float cy, float maxRadius, int baseColor, long birth, float speed, float thickness, float tweaking) {
            this.cx = cx;
            this.cy = cy;
            this.maxRadius = maxRadius;
            this.baseColor = baseColor;
            this.birth = birth;
            this.speed = speed;
            this.thickness = thickness;
            this.tweaking = tweaking;
        }

        boolean updateAndRender(TooltipContext ctx, long nowMs) {
            float lifetime = Math.max(0.0f, (float)(nowMs - this.birth));
            float duration = Math.max(800.0f, 1200.0f * (this.maxRadius / 120.0f));
            float time = Math.min(1.0f, lifetime / duration);
            float eased = RipplesEffect.easeOutCubic(time);
            float rad = eased * this.maxRadius * this.speed;
            float alpha = Ripple.clamp01(1.2f - time * 1.2f) * 0.85f;
            this.draw(ctx, this.cx, this.cy, rad - this.thickness * 0.5f, rad + this.thickness * 0.5f, this.baseColor, alpha, this.tweaking, nowMs);
            this.draw(ctx, this.cx, this.cy, rad + this.thickness * 0.4f, rad + this.thickness * 2.15f, this.baseColor, alpha * 0.55f, this.tweaking + 1.3f, nowMs);
            return rad < this.maxRadius + this.thickness * 2.35f;
        }

        private void draw(TooltipContext ctx, float cx, float cy, float innerR, float outerR, int color, float alphaPeak, float wobblePhase, long now) {
            float w1;
            float w0;
            float th1;
            float th0;
            if (outerR <= 1.0f) {
                return;
            }
            if (innerR < 0.0f) {
                innerR = 0.0f;
            }
            if (outerR - innerR <= 0.5f) {
                outerR = innerR + 0.5f;
            }
            int a = color >>> 24 & 0xFF;
            int r = color >>> 16 & 0xFF;
            int g = color >>> 8 & 0xFF;
            int b = color & 0xFF;
            float alphaNorm = Ripple.clamp01(alphaPeak) * ((float)a / 255.0f);
            float time = (float)now / 1000.0f;
            float tweaking = (float)Math.toRadians(10.0) * (float)Math.sin(7.5398226682211265 * (double)time + (double)wobblePhase);
            Tesselator tesselator = Tesselator.getInstance();
            int segments = Math.max(48, (int)(outerR * 2.0f));
            float midR = innerR + (outerR - innerR) * 0.5f;
            BufferBuilder buf = tesselator.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
            int alphaByte = Math.round(alphaNorm * 255.0f);
            for (int i = 0; i < segments; ++i) {
                th0 = (float)(Math.PI * 2 * (double)i / (double)segments);
                th1 = (float)(Math.PI * 2 * (double)(i + 1) / (double)segments);
                w0 = th0 + tweaking * (float)Math.sin(th0 * 3.0f);
                w1 = th1 + tweaking * (float)Math.sin(th1 * 3.0f);
                float mx0 = cx + (float)Math.cos(w0) * midR;
                float my0 = cy + (float)Math.sin(w0) * midR;
                float ix0 = cx + (float)Math.cos(w0) * innerR;
                float iy0 = cy + (float)Math.sin(w0) * innerR;
                float mx1 = cx + (float)Math.cos(w1) * midR;
                float my1 = cy + (float)Math.sin(w1) * midR;
                float ix1 = cx + (float)Math.cos(w1) * innerR;
                float iy1 = cy + (float)Math.sin(w1) * innerR;
                buf.addVertex(ctx.pose().last().pose(), mx0, my0, 0.0f).setColor(r, g, b, alphaByte);
                buf.addVertex(ctx.pose().last().pose(), ix0, iy0, 0.0f).setColor(r, g, b, 0);
                buf.addVertex(ctx.pose().last().pose(), ix1, iy1, 0.0f).setColor(r, g, b, 0);
                buf.addVertex(ctx.pose().last().pose(), mx0, my0, 0.0f).setColor(r, g, b, alphaByte);
                buf.addVertex(ctx.pose().last().pose(), ix1, iy1, 0.0f).setColor(r, g, b, 0);
                buf.addVertex(ctx.pose().last().pose(), mx1, my1, 0.0f).setColor(r, g, b, alphaByte);
            }
            try (MeshData data = buf.buildOrThrow();){
                RenderType.dragonRays().draw(data);
            }
            buf = tesselator.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
            for (int i = 0; i < segments; ++i) {
                th0 = (float)(Math.PI * 2 * (double)i / (double)segments);
                th1 = (float)(Math.PI * 2 * (double)(i + 1) / (double)segments);
                w0 = th0 + tweaking * (float)Math.sin(th0 * 3.0f);
                w1 = th1 + tweaking * (float)Math.sin(th1 * 3.0f);
                float ox0 = cx + (float)Math.cos(w0) * outerR;
                float oy0 = cy + (float)Math.sin(w0) * outerR;
                float mx0 = cx + (float)Math.cos(w0) * midR;
                float my0 = cy + (float)Math.sin(w0) * midR;
                float ox1 = cx + (float)Math.cos(w1) * outerR;
                float oy1 = cy + (float)Math.sin(w1) * outerR;
                float mx1 = cx + (float)Math.cos(w1) * midR;
                float my1 = cy + (float)Math.sin(w1) * midR;
                buf.addVertex(ctx.pose().last().pose(), ox0, oy0, 0.0f).setColor(r, g, b, 0);
                buf.addVertex(ctx.pose().last().pose(), mx0, my0, 0.0f).setColor(r, g, b, alphaByte);
                buf.addVertex(ctx.pose().last().pose(), mx1, my1, 0.0f).setColor(r, g, b, alphaByte);
                buf.addVertex(ctx.pose().last().pose(), ox0, oy0, 0.0f).setColor(r, g, b, 0);
                buf.addVertex(ctx.pose().last().pose(), mx1, my1, 0.0f).setColor(r, g, b, alphaByte);
                buf.addVertex(ctx.pose().last().pose(), ox1, oy1, 0.0f).setColor(r, g, b, 0);
            }
            data = buf.buildOrThrow();
            try {
                RenderType.dragonRays().draw(data);
            }
            finally {
                if (data != null) {
                    data.close();
                }
            }
        }

        private static float clamp01(float v) {
            return v < 0.0f ? 0.0f : Math.min(v, 1.0f);
        }
    }
}

