/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.effect;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.layer.LayerDepth;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipEffect;
import java.awt.Point;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.class_1921;
import net.minecraft.class_241;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public class SonarEffect
implements ITooltipEffect {
    private static final int RINGS = 1;
    private static final long PER_PULSE = 1200L;
    private static final int LIFETIME = 1400;
    private static final float THICKNESS = 10.0f;
    private static final float GLOW = 2.6f;
    private static final int color = -2002724609;
    private long lastSpawn = 0L;
    private final Deque<Pulse> pulses = new ArrayDeque<Pulse>();

    @Override
    public void render(LayerDepth depth, TooltipContext ctx, class_241 pos, Point size) {
        int x = (int)pos.field_1343;
        int y = (int)pos.field_1342;
        int w = size.x;
        int h = size.y;
        if (w <= 2 || h <= 2) {
            return;
        }
        long now = System.currentTimeMillis();
        float cx = (float)x + (float)w * 0.5f;
        float cy = (float)y + (float)h * 0.5f;
        if (now - this.lastSpawn >= 1200L && this.pulses.size() < 1) {
            this.pulses.addLast(new Pulse(now, 1400, (float)Math.hypot(w, h) * 0.6f, 0.0f, -2002724609));
            this.lastSpawn = now;
        }
        ctx.push(() -> {
            ctx.graphics().method_44379(x - 3, y - 3, x + w + 3, y + h + 3);
            ctx.translate(0.0f, 0.0f, depth.getZ());
            GlStateManager._enableBlend();
            GlStateManager._blendFuncSeparate((int)770, (int)1, (int)1, (int)771);
            this.pulses.removeIf(p -> !p.render(ctx.pose().method_23760().method_23761(), now, cx, cy));
            GlStateManager._blendFuncSeparate((int)770, (int)771, (int)770, (int)771);
            GlStateManager._disableBlend();
            ctx.graphics().method_44380();
        });
    }

    private static void draw(Matrix4f pose, float cx, float cy, float innerR, float outerR, int r, int g, int b, int alphaPeak) {
        if (outerR <= 1.0f) {
            return;
        }
        if (innerR < 0.0f) {
            innerR = 0.0f;
        }
        if (outerR - innerR <= 0.5f) {
            outerR = innerR + 0.5f;
        }
        int segments = Math.max(64, (int)(outerR * 2.0f));
        float midR = innerR + (outerR - innerR) * 0.5f;
        float[] cos = new float[segments + 1];
        float[] sin = new float[segments + 1];
        for (int i = 0; i <= segments; ++i) {
            double ang = (double)i * (Math.PI * 2 / (double)segments);
            cos[i] = (float)Math.cos(ang);
            sin[i] = (float)Math.sin(ang);
        }
        class_289 tesselator = class_289.method_1348();
        class_287 buf = tesselator.method_60827(VertexFormat.class_5596.field_27379, class_290.field_1576);
        for (int i = 0; i < segments; ++i) {
            float mx0 = cx + cos[i] * midR;
            float my0 = cy + sin[i] * midR;
            float ix0 = cx + cos[i] * innerR;
            float iy0 = cy + sin[i] * innerR;
            float mx1 = cx + cos[i + 1] * midR;
            float my1 = cy + sin[i + 1] * midR;
            float ix1 = cx + cos[i + 1] * innerR;
            float iy1 = cy + sin[i + 1] * innerR;
            buf.method_22918(pose, mx0, my0, 0.0f).method_1336(r, g, b, alphaPeak);
            buf.method_22918(pose, ix0, iy0, 0.0f).method_1336(r, g, b, 0);
            buf.method_22918(pose, ix1, iy1, 0.0f).method_1336(r, g, b, 0);
            buf.method_22918(pose, mx0, my0, 0.0f).method_1336(r, g, b, alphaPeak);
            buf.method_22918(pose, ix1, iy1, 0.0f).method_1336(r, g, b, 0);
            buf.method_22918(pose, mx1, my1, 0.0f).method_1336(r, g, b, alphaPeak);
        }
        try (class_9801 data = buf.method_60800();){
            class_1921.method_61046().method_60895(data);
        }
        buf = tesselator.method_60827(VertexFormat.class_5596.field_27379, class_290.field_1576);
        for (int i = 0; i < segments; ++i) {
            float ox0 = cx + cos[i] * outerR;
            float oy0 = cy + sin[i] * outerR;
            float mx0 = cx + cos[i] * midR;
            float my0 = cy + sin[i] * midR;
            float ox1 = cx + cos[i + 1] * outerR;
            float oy1 = cy + sin[i + 1] * outerR;
            float mx1 = cx + cos[i + 1] * midR;
            float my1 = cy + sin[i + 1] * midR;
            buf.method_22918(pose, ox0, oy0, 0.0f).method_1336(r, g, b, 0);
            buf.method_22918(pose, mx0, my0, 0.0f).method_1336(r, g, b, alphaPeak);
            buf.method_22918(pose, mx1, my1, 0.0f).method_1336(r, g, b, alphaPeak);
            buf.method_22918(pose, ox0, oy0, 0.0f).method_1336(r, g, b, 0);
            buf.method_22918(pose, mx1, my1, 0.0f).method_1336(r, g, b, alphaPeak);
            buf.method_22918(pose, ox1, oy1, 0.0f).method_1336(r, g, b, 0);
        }
        data = buf.method_60800();
        try {
            class_1921.method_61046().method_60895(data);
        }
        finally {
            if (data != null) {
                data.close();
            }
        }
    }

    private record Pulse(long start, int lifetime, float radiusS, float radiusE, int color) {
        boolean render(Matrix4f pose, long now, float cx, float cy) {
            float time = (float)(now - this.start) / (float)this.lifetime;
            if (time >= 1.0f) {
                return false;
            }
            float radius = Pulse.lerp(this.radiusS, this.radiusE, Pulse.easeInOutCubic(time));
            float innerCore = Math.max(0.0f, radius - 5.0f);
            float innerGlow = Math.max(0.0f, radius - 13.0f);
            float outerGlow = Math.max(innerGlow + 0.5f, radius + 13.0f);
            if (outerGlow <= 1.0f) {
                return true;
            }
            int red = this.color >>> 16 & 0xFF;
            int green = this.color >>> 8 & 0xFF;
            int blue = this.color & 0xFF;
            float alpha = (float)Math.sin(Math.PI * (double)Pulse.clamp(time));
            SonarEffect.draw(pose, cx, cy, innerGlow, outerGlow, red, green, blue, (int)((float)((int)(alpha * 90.0f)) * 0.65f));
            SonarEffect.draw(pose, cx, cy, innerCore, Math.max(innerCore + 0.5f, radius + 5.0f), red, green, blue, (int)(alpha * 170.0f));
            return true;
        }

        private static float lerp(float a, float b, float t) {
            return a + (b - a) * t;
        }

        private static float clamp(float v) {
            return v < 0.0f ? 0.0f : Math.min(v, 1.0f);
        }

        private static float easeInOutCubic(float t) {
            return t < 0.5f ? 4.0f * t * t * t : 1.0f - (float)Math.pow(-2.0f * t + 2.0f, 3.0) / 2.0f;
        }
    }
}

