/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.effect;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.layer.LayerDepth;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipEffect;
import java.awt.Point;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Random;
import net.minecraft.class_1921;
import net.minecraft.class_241;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public class StarsEffect
implements ITooltipEffect {
    private static final int STARS_CAP = 3;
    private static final long SPAWN_INTERVAL = 620L;
    private static final int MIN_LIFE = 420;
    private static final int MAX_LIFE = 680;
    private static final float MIN_SIZE = 28.0f;
    private static final float MAX_SIZE = 68.0f;
    private static final float CORe_SIZE = 6.5f;
    private static final float GLOW_SIZE = 2.4f;
    private static final float OFFSET = 0.8f;
    private final Deque<Star> stars = new ArrayDeque<Star>();
    private final int[] colors;
    private long lastSpawn = 0L;
    private static final int[] DEFAULT_COLORS = new int[]{-2002724609, -1996501017, -1996488705};

    public StarsEffect() {
        this(DEFAULT_COLORS);
    }

    public StarsEffect(int[] colors) {
        this.colors = colors == null || colors.length == 0 ? DEFAULT_COLORS : (int[])colors.clone();
    }

    @Override
    public void render(LayerDepth depth, TooltipContext ctx, class_241 pos, Point size) {
        int x = (int)pos.field_1343;
        int y = (int)pos.field_1342;
        int w = size.x;
        int h = size.y;
        if (w <= 2 || h <= 2) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastSpawn >= 620L && this.stars.size() < 3) {
            this.spawnStar(x, y, w, h, now);
            this.lastSpawn = now;
        }
        ctx.push(() -> {
            ctx.graphics().method_44379(x - 3, y - 3, x + w + 3, y + h + 3);
            ctx.translate(0.0f, 0.0f, depth.getZ());
            GlStateManager._enableBlend();
            GlStateManager._blendFuncSeparate((int)770, (int)1, (int)1, (int)771);
            Matrix4f pose = ctx.pose().method_23760().method_23761();
            this.stars.removeIf(s -> !s.updateAndRender(pose, now));
            GlStateManager._blendFuncSeparate((int)770, (int)771, (int)770, (int)771);
            GlStateManager._disableBlend();
            ctx.graphics().method_44380();
        });
    }

    private void spawnStar(int x, int y, int w, int h, long now) {
        Random random = new Random();
        float margin = 10.0f;
        float cx = (float)x + margin + random.nextFloat() * Math.max(1.0f, (float)w - 2.0f * margin);
        float cy = (float)y + margin + random.nextFloat() * Math.max(1.0f, (float)h - 2.0f * margin);
        float rot = random.nextFloat() * (float)Math.PI;
        this.stars.addLast(new Star(cx, cy, StarsEffect.lerp(random.nextFloat()), now, StarsEffect.randomBetween(), this.colors[random.nextInt(this.colors.length)], rot));
        if (this.stars.size() > 3) {
            this.stars.pollFirst();
        }
    }

    private static void draw(Matrix4f pose, float x1, float y1, float x2, float y2, float tStart, float tEnd, int r, int g, int b, int a) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        float len = (float)Math.max(0.001, Math.hypot(dx, dy));
        float x = -dy / len;
        float y = dx / len;
        class_289 tess = class_289.method_1348();
        class_287 buf = tess.method_60827(VertexFormat.class_5596.field_27380, class_290.field_1576);
        buf.method_22918(pose, x1 - x * tStart * 0.5f, y1 - y * tStart * 0.5f, 0.0f).method_1336(r, g, b, a);
        buf.method_22918(pose, x1 + x * tStart * 0.5f, y1 + y * tStart * 0.5f, 0.0f).method_1336(r, g, b, a);
        buf.method_22918(pose, x2 - x * tEnd * 0.5f, y2 - y * tEnd * 0.5f, 0.0f).method_1336(r, g, b, a);
        buf.method_22918(pose, x2 + x * tEnd * 0.5f, y2 + y * tEnd * 0.5f, 0.0f).method_1336(r, g, b, a);
        try (class_9801 data = buf.method_60800();){
            class_1921.method_61046().method_60895(data);
        }
    }

    private static int randomBetween() {
        return 420 + (int)Math.floor(Math.random() * 261.0);
    }

    private static float lerp(float t) {
        return 28.0f + 40.0f * t;
    }

    private static float clamp(float v) {
        return Math.max(0.0f, Math.min(1.0f, v));
    }

    private static final class Star {
        private final float cx;
        private final float cy;
        private final float maxLen;
        private final float baseRot;
        private final long birth;
        private final int lifetime;
        private final int argb;

        public Star(float cx, float cy, float maxLen, long birth, int life, int color, float baseRot) {
            this.cx = cx;
            this.cy = cy;
            this.maxLen = maxLen;
            this.birth = birth;
            this.lifetime = life;
            this.argb = color;
            this.baseRot = baseRot;
        }

        boolean updateAndRender(Matrix4f pose, long now) {
            float time = (float)(now - this.birth) / (float)this.lifetime;
            if (time >= 1.0f) {
                return false;
            }
            float s = (float)Math.sin(Math.PI * (double)StarsEffect.clamp(time));
            float rot = this.baseRot + (float)Math.sin((double)(now + this.birth) * 0.0023) * 0.08f;
            float alpha = (float)Math.pow(1.0f - time, 1.15f);
            int red = this.argb >>> 16 & 0xFF;
            int green = this.argb >>> 8 & 0xFF;
            int blue = this.argb & 0xFF;
            float len = 4.0f + s * this.maxLen;
            float tco = 6.5f * (0.9f + 0.2f * new Random().nextFloat());
            float tti = 0.8f + 0.4f * (1.0f - s);
            for (int i = 0; i < 4; ++i) {
                float ax = (float)Math.cos(rot + (float)i * 1.5707964f);
                float ay = (float)Math.sin(rot + (float)i * 1.5707964f);
                float x2 = this.cx + ax * len;
                float y2 = this.cy + ay * len;
                StarsEffect.draw(pose, this.cx, this.cy, x2, y2, tco * 2.4f, tti * 2.4f, red, green, blue, (int)(90.0f * alpha));
                StarsEffect.draw(pose, this.cx, this.cy, x2, y2, tco, tti, red, green, blue, (int)(200.0f * alpha));
                float nx = -ay * 0.8f;
                float ny = ax * 0.8f;
                StarsEffect.draw(pose, this.cx + nx, this.cy + ny, x2 + nx, y2 + ny, tco * 0.9f, tti * 0.9f, 255, 80, 80, (int)(110.0f * alpha));
                StarsEffect.draw(pose, this.cx - nx, this.cy - ny, x2 - nx, y2 - ny, tco * 0.9f, tti * 0.9f, 80, 120, 255, (int)(110.0f * alpha));
            }
            return true;
        }
    }
}

