/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.wrap;

import dev.xylonity.tooltipoverhaul.client.TooltipRenderer;
import dev.xylonity.tooltipoverhaul.mixin.ClientTextTooltipAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5683;
import net.minecraft.class_5684;

public final class TooltipWrapper {
    public static List<class_5684> wrap(class_327 font, List<class_5684> orig, int screenWidth, class_1799 stack) {
        if (orig == null || orig.isEmpty()) {
            return orig;
        }
        boolean hasIcon = !stack.method_7960();
        int basePadding = TooltipRenderer.PADDING_X * 2 + 4;
        int iconPadding = hasIcon ? 26 : 0;
        int maxAllowed = Math.max(60, (int)((float)screenWidth * 0.75f) - basePadding - iconPadding);
        boolean shouldWrap = false;
        for (class_5684 c : orig) {
            if (!(c instanceof class_5683) || c.method_32664(font) <= maxAllowed) continue;
            shouldWrap = true;
            break;
        }
        if (!shouldWrap) {
            return orig;
        }
        ArrayList<class_5684> text = new ArrayList<class_5684>(orig.size() + 8);
        for (class_5684 component : orig) {
            if (!(component instanceof class_5683)) {
                text.add(component);
                continue;
            }
            if (component.method_32664(font) <= maxAllowed) {
                text.add(component);
                continue;
            }
            class_5481 sequence = TooltipWrapper.getSequence(component);
            if (sequence == null) {
                text.add(component);
                continue;
            }
            for (class_5348 part : font.method_27527().method_27495(TooltipWrapper.toFormattedText(sequence), maxAllowed, class_2583.field_24360)) {
                text.add((class_5684)new class_5683(class_2477.method_10517().method_30934(part)));
            }
        }
        return text;
    }

    private static class_5481 getSequence(class_5684 c) {
        if (c instanceof class_5683) {
            class_5683 t = (class_5683)c;
            return ((ClientTextTooltipAccessor)t).getText();
        }
        return null;
    }

    private static class_5348 toFormattedText(class_5481 sequence) {
        final ArrayList<String> chunks = new ArrayList<String>();
        final ArrayList<class_2583> styles = new ArrayList<class_2583>();
        StringBuilder string = new StringBuilder();
        class_2583[] current = new class_2583[]{class_2583.field_24360};
        sequence.accept((pos, style, cp) -> {
            if (!style.equals((Object)current[0])) {
                if (!string.isEmpty()) {
                    chunks.add(string.toString());
                    styles.add(current[0]);
                    string.setLength(0);
                }
                current[0] = style;
            }
            string.appendCodePoint(cp);
            return true;
        });
        if (!string.isEmpty()) {
            chunks.add(string.toString());
            styles.add(current[0]);
        }
        return new class_5348(){

            public <T> Optional<T> method_27657(class_5348.class_5245<T> consumer) {
                for (String part : chunks) {
                    consumer.accept(part);
                }
                return Optional.empty();
            }

            public <T> Optional<T> method_27658(class_5348.class_5246<T> consumer, class_2583 base) {
                for (int i = 0; i < chunks.size(); ++i) {
                    consumer.accept(((class_2583)styles.get(i)).method_27702(base), (String)chunks.get(i));
                }
                return Optional.empty();
            }
        };
    }
}

