/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.layout;

import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.Constants;
import dev.xylonity.tooltipoverhaul.client.util.RenderUtils;
import dev.xylonity.tooltipoverhaul.client.util.TextUtils;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.phys.Vec2;

public class TooltipSizeCalculator {
    private final TooltipContext context;

    public TooltipSizeCalculator(TooltipContext context) {
        this.context = context;
    }

    public Vec2 calculate() {
        boolean hasIcon = this.context.hasIcon();
        boolean hasRating = RenderUtils.hasRating(this.context);
        boolean hasDividerLine = this.context.hasDividerLine();
        List<ClientTooltipComponent> components = this.context.getComponents();
        Font font = this.context.getFont();
        int paddingX = this.context.getPaddingX();
        int paddingY = this.context.getPaddingY();
        int iconOffset = hasIcon ? Constants.getIconSize(this.context) + Constants.getIconTitleSeparation(this.context) : 0;
        int width = components.get(0).getWidth(font) + paddingX * 2 + iconOffset;
        int height = components.get(0).getHeight() + paddingY * 2;
        for (int i = 0; i < components.size(); ++i) {
            if (i <= 0) continue;
            height += components.get(i).getHeight();
            width = Math.max(width, components.get(i).getWidth(font) + paddingX * 2);
        }
        if (hasRating) {
            Component rating = TextUtils.getRatingText(this.context);
            width = Math.max(width, font.width((FormattedText)rating) + paddingX * 2 + iconOffset);
            if (!hasIcon) {
                height += ClientTooltipComponent.create((FormattedCharSequence)rating.getVisualOrderText()).getHeight();
            }
        }
        if (hasIcon) {
            height += Constants.getIconSize(this.context) - 10;
        }
        if (hasDividerLine && components.size() > 1) {
            height = hasIcon ? (height += Constants.getDividerLineFullPadding(this.context)) : (height += Constants.getDividerLineFullPadding(this.context));
        }
        return new Vec2((float)width, (float)height);
    }

    public Vec2 adjustSize() {
        Vec2 otherContextSize;
        Vec2 newSize = this.context.getTooltipSize();
        boolean isMainTooltip = this.context.isMainTooltip();
        TooltipContext otherContext = this.context.getOtherTooltipContext();
        Vec2 otherContextPosition = otherContext != null ? otherContext.getTooltipPosition() : null;
        Vec2 vec2 = otherContextSize = otherContext != null ? otherContext.getTooltipSize() : null;
        if (isMainTooltip && otherContextPosition != null && otherContextSize != null && otherContextPosition.x == (float)this.context.getPaddingX() && this.context.getTooltipPosition().x + this.context.getTooltipSize().x > (float)this.context.getScreenWidth()) {
            newSize = new Vec2((float)(this.context.getScreenWidth() - this.context.getPaddingX()) - this.context.getTooltipPosition().x, newSize.y);
        }
        return newSize;
    }
}

