/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.effect;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.xylonity.tooltipoverhaul.client.layer.impl.EffectLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.AnimationUtils;
import dev.xylonity.tooltipoverhaul.client.util.ColorUtils;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4f;

public class SpeedLinesEffect
implements EffectLayer {
    private static final int RAYS_PER_SIDE = 14;
    private static final int WING_COLOR_INNER = -1056964609;
    private static final int WING_COLOR_OUTER = 1624305919;

    @Override
    public void render(TooltipContext context, Vec2 position) {
        int positionX = (int)position.x;
        int positionY = (int)position.y;
        int tooltipWidth = (int)context.getTooltipSize().x;
        int tooltipHeight = (int)context.getTooltipSize().y;
        long now = System.currentTimeMillis();
        float time = (float)(now - context.getStartTime()) / 5000.0f;
        float centerX = (float)positionX + (float)tooltipWidth * 0.5f;
        float centerY = (float)positionY + (float)tooltipHeight * 0.5f;
        float maxRadius = (float)Math.hypot(tooltipWidth, tooltipHeight);
        context.push(() -> {
            context.getGraphics().enableScissor(positionX - context.getPaddingX() - 1, positionY - context.getPaddingY(), positionX + tooltipWidth + context.getPaddingX(), positionY + tooltipHeight + context.getPaddingY());
            context.translate(0.0f, 0.0f, context.getLayerDepth().getZ());
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableCull();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            Matrix4f pose = context.getPose().last().pose();
            Tesselator tesselator = Tesselator.getInstance();
            this.renderWings(tesselator, pose, centerX, centerY, maxRadius, time);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            context.getGraphics().disableScissor();
        });
    }

    private void renderWings(Tesselator tesselator, Matrix4f pose, float centerX, float centerY, float maxRadius, float t) {
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        int innerRed = ColorUtils.red(-1056964609);
        int innerGreen = ColorUtils.green(-1056964609);
        int innerBlue = ColorUtils.blue(-1056964609);
        int innerAlpha = ColorUtils.alpha(-1056964609);
        int outerRed = ColorUtils.red(1624305919);
        int outerGreen = ColorUtils.green(1624305919);
        int outerBlue = ColorUtils.blue(1624305919);
        int outerAlpha = ColorUtils.alpha(1624305919);
        float rayMin = maxRadius * 0.25f;
        float rayMax = maxRadius * 0.95f;
        float spread = 2.6703537f;
        for (int side = -1; side <= 1; side += 2) {
            float baseAngle = side > 0 ? 0.0f : (float)Math.PI;
            for (int i = 0; i < 14; ++i) {
                float s = (float)i / 13.0f;
                float wingOffset = (s - 0.4f) * spread;
                float wobble = 0.1f * (float)Math.sin((double)(t * 2.5f + (float)i * 0.6f) * Math.PI * 2.0);
                float angle = baseAngle + (float)side * (wingOffset + wobble);
                float dirX = (float)Math.cos(angle);
                float dirY = (float)Math.sin(angle);
                float nx = -dirY;
                float ny = dirX;
                float open = 0.75f + 0.25f * (float)Math.sin((double)(t * 1.8f + s * 0.3f) * Math.PI * 2.0);
                float rayLength = rayMin + (rayMax - rayMin) * open;
                float baseRadius = rayMin * (0.4f + s * 0.4f);
                float thickness = maxRadius * 0.03f * (1.1f - s * 0.7f);
                float tipX = centerX + dirX * rayLength;
                float tipY = centerY + dirY * rayLength;
                float rootX = centerX + dirX * baseRadius;
                float rootY = centerY + dirY * baseRadius;
                float tip1X = tipX + nx * thickness;
                float tip1Y = tipY + ny * thickness;
                float tip2X = tipX - nx * thickness;
                float tip2Y = tipY - ny * thickness;
                float head = (float)Math.pow(1.0f - s, 1.4f);
                float flicker = 0.6f + 0.4f * (float)Math.sin((double)(t * 3.0f + (float)i * 0.8f) * Math.PI * 2.0);
                float alphaFactor = head * flicker;
                int rootAlpha = AnimationUtils.clamp255((int)((float)innerAlpha * alphaFactor * 0.8f));
                int tipAlpha = AnimationUtils.clamp255((int)((float)outerAlpha * alphaFactor));
                bufferBuilder.addVertex(pose, rootX, rootY, 0.0f).setColor(innerRed, innerGreen, innerBlue, rootAlpha);
                bufferBuilder.addVertex(pose, tip1X, tip1Y, 0.0f).setColor(outerRed, outerGreen, outerBlue, tipAlpha);
                bufferBuilder.addVertex(pose, tip2X, tip2Y, 0.0f).setColor(outerRed, outerGreen, outerBlue, tipAlpha / 2 + rootAlpha / 2);
            }
        }
        try (MeshData data = bufferBuilder.buildOrThrow();){
            BufferUploader.drawWithShader((MeshData)data);
        }
    }
}

