/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.preview.renderer;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.math.Axis;
import dev.xylonity.tooltipoverhaul.TooltipOverhaul;
import dev.xylonity.tooltipoverhaul.client.layer.impl.PreviewRendererLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.AnimationUtils;
import dev.xylonity.tooltipoverhaul.client.util.RenderUtils;
import dev.xylonity.tooltipoverhaul.client.util.TextAxis;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;

public class DefaultPreviewPlayerRenderer
implements PreviewRendererLayer {
    private static final GameProfile DEFAULT_PROFILE = new GameProfile(new UUID(0L, 0L), "");
    private static final ResourceLocation DEFAULT_SKIN = TooltipOverhaul.pathOf("textures/preview/dummy.png");

    @Override
    public void render(TooltipContext context, Vec2 startPosition, Vec2 endPosition) {
        Item item;
        int sizeX = RenderUtils.calculateSecondPanelSize(context, TextAxis.X);
        int sizeY = RenderUtils.calculateSecondPanelSize(context, TextAxis.Y);
        int y0 = (int)startPosition.y;
        int x1 = (int)endPosition.x;
        context.translate((float)x1 + (float)sizeX / 2.0f + 2.0f, (float)y0 + (float)sizeY / 1.15f + 2.0f, 0.0f);
        context.multiply(Axis.XP, -30.0f);
        context.multiply(Axis.YP, -45.0f);
        context.multiply(Axis.YP, (float)(System.currentTimeMillis() - context.getStartTime()) / 20.0f % 360.0f * AnimationUtils.getSecondPanelRendererSpeed(context));
        float scale = Math.min((float)sizeX, (float)sizeY / 2.0f) / 1.25f;
        context.scale(-scale, -scale, scale);
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level != null && (item = context.getStack().getItem()) instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            RemotePlayer player = DefaultPreviewPlayerRenderer.getRemotePlayer(minecraft, context);
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                player.setItemSlot(equipmentSlot, ItemStack.EMPTY);
            }
            player.setItemSlot(armorItem.getEquipmentSlot(), context.getStack());
            player.setYRot(0.0f);
            player.setXRot(0.0f);
            player.yBodyRot = 0.0f;
            player.yHeadRot = 0.0f;
            Lighting.setupForEntityInInventory();
            EntityRenderDispatcher renderer = minecraft.getEntityRenderDispatcher();
            renderer.setRenderShadow(false);
            renderer.render((Entity)player, 0.0, 0.0, 0.0, 0.0f, 1.0f, context.getPose(), context.getBuffer(), 0xF000F0);
            renderer.setRenderShadow(true);
        }
    }

    @NotNull
    private static RemotePlayer getRemotePlayer(Minecraft minecraft, TooltipContext context) {
        final LocalPlayer localPlayer = minecraft.player;
        final boolean usePlayerSkin = RenderUtils.usePlayerSkinInPreview(context);
        return new RemotePlayer(minecraft.level, DEFAULT_PROFILE){

            public PlayerSkin getSkin() {
                if (localPlayer != null && usePlayerSkin) {
                    return localPlayer.getSkin();
                }
                return new PlayerSkin(DEFAULT_SKIN, null, null, null, PlayerSkin.Model.WIDE, true);
            }
        };
    }
}

