/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.preview.renderer;

import com.mojang.math.Axis;
import dev.xylonity.tooltipoverhaul.client.layer.impl.PreviewRendererLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.AnimationUtils;
import dev.xylonity.tooltipoverhaul.client.util.RenderUtils;
import dev.xylonity.tooltipoverhaul.client.util.TextAxis;
import dev.xylonity.tooltipoverhaul.compat.modernfix.ModernFixCompat;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;

public class DefaultPreviewStackRenderer
implements PreviewRendererLayer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(TooltipContext context, Vec2 startPosition, Vec2 endPosition) {
        int sizeX = RenderUtils.calculateSecondPanelSize(context, TextAxis.X);
        int sizeY = RenderUtils.calculateSecondPanelSize(context, TextAxis.Y);
        int x0 = (int)startPosition.x;
        int y0 = (int)startPosition.y;
        int x1 = (int)endPosition.x;
        int y1 = (int)endPosition.y;
        context.translate((float)x1 + (float)sizeX / 2.0f + 2.0f, (float)y0 + (float)sizeY / 2.0f + 2.0f, 0.0f);
        context.multiply(Axis.YP, (float)(System.currentTimeMillis() - context.getStartTime()) / 20.0f % 360.0f * AnimationUtils.getSecondPanelRendererSpeed(context));
        context.multiply(Axis.ZP, -45.0f);
        float scale = Math.min((float)sizeX / 5.0f, (float)sizeY / 10.0f) / 2.5f;
        context.scale(scale, scale, scale);
        Minecraft minecraft = Minecraft.getInstance();
        if (ModernFixCompat.SHOULD_RETURN_ORIGINAL_RENDER) {
            ModernFixCompat.push();
            try {
                RenderUtils.renderItem(context, (LivingEntity)minecraft.player, (Level)minecraft.level, context.getStack(), 0);
            }
            finally {
                ModernFixCompat.pop();
            }
        } else {
            RenderUtils.renderItem(context, (LivingEntity)minecraft.player, (Level)minecraft.level, context.getStack(), 0);
        }
    }
}

