/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.util;

import com.google.common.collect.Lists;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameData;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.config.TooltipsConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class TextUtils {
    public static boolean shouldDisableScrolling(TooltipContext context) {
        return Optional.ofNullable(context.getFrameData()).map(CustomFrameData::shouldDisableScrolling).orElse(TooltipsConfig.DISABLE_TOOLTIP_SCROLLING);
    }

    public static List<ClientTooltipComponent> getTooltipComponentsFrom(ItemStack stack, Font font, int screenWidth, float screenSplit) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        ArrayList componentList = Lists.newArrayList();
        assert (player != null);
        List originalComponentLines = stack.getTooltipLines(Item.TooltipContext.of((Level)player.level()), (Player)player, (TooltipFlag)(minecraft.options.advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL));
        for (Component originalComponentLine : originalComponentLines) {
            List wrappedLines = font.split((FormattedText)originalComponentLine, Math.max((int)((float)screenWidth / screenSplit), 200));
            if (wrappedLines.isEmpty()) {
                componentList.add(ClientTooltipComponent.create((FormattedCharSequence)FormattedCharSequence.EMPTY));
                continue;
            }
            if (wrappedLines.size() == 1) {
                componentList.add(ClientTooltipComponent.create((FormattedCharSequence)originalComponentLine.getVisualOrderText()));
                continue;
            }
            for (FormattedCharSequence wrappedLine : wrappedLines) {
                componentList.add(ClientTooltipComponent.create((FormattedCharSequence)wrappedLine));
            }
        }
        stack.getTooltipImage().ifPresent(component -> {
            if (component instanceof BundleTooltip) {
                BundleTooltip bundleTooltip = (BundleTooltip)component;
                int idx = originalComponentLines.size() > 1 ? 1 : componentList.size();
                componentList.add(idx, ClientTooltipComponent.create((TooltipComponent)bundleTooltip));
            }
        });
        return componentList;
    }

    public static Component getRatingText(TooltipContext context) {
        ChatFormatting color = ChatFormatting.GOLD;
        Rarity rarity = context.getStack().getRarity();
        if (rarity == Rarity.COMMON) {
            color = ChatFormatting.GRAY;
        } else if (rarity == Rarity.UNCOMMON) {
            color = ChatFormatting.YELLOW;
        } else if (rarity == Rarity.RARE) {
            color = ChatFormatting.BLUE;
        } else if (rarity == Rarity.EPIC) {
            color = ChatFormatting.DARK_PURPLE;
        }
        CustomFrameData data = context.getFrameData();
        if (data != null && data.hasCustomItemRating()) {
            MutableComponent base;
            String raw = data.getItemRating(context.getStack());
            MutableComponent mutableComponent = base = raw.startsWith("key.tooltipoverhaul") ? Component.translatable((String)raw) : Component.literal((String)raw);
            if (data.hasCustomColorItemRating()) {
                return base.withStyle(Style.EMPTY.withColor(data.getItemRatingColor(context)));
            }
            return base.withStyle(color);
        }
        return TextUtils.getDefaultRarity(context.getStack()).copy().withStyle(color);
    }

    private static Component getDefaultRarity(ItemStack stack) {
        Rarity r = stack.getRarity();
        String string = r.toString();
        if (r == Rarity.COMMON || r == Rarity.UNCOMMON || r == Rarity.RARE || r == Rarity.EPIC) {
            return Component.translatable((String)("tooltipoverhaul." + string.trim().toLowerCase() + "_rarity"));
        }
        if (string.contains("alexscaves")) {
            return Component.translatable((String)("rarity.alexscaves." + string.split(":")[1] + ".name"));
        }
        return Component.translatable((String)r.name().trim().toLowerCase());
    }
}

