/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.mixin;

import com.mojang.blaze3d.platform.InputConstants;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.render.TooltipRenderer;
import dev.xylonity.tooltipoverhaul.client.util.EquippedContextCalculator;
import dev.xylonity.tooltipoverhaul.client.util.TextUtils;
import dev.xylonity.tooltipoverhaul.mixin.KeyMappingAccessor;
import dev.xylonity.tooltipoverhaul.registry.TooltipOverhaulKeyMappings;
import dev.xylonity.tooltipoverhaul.util.ITooltipOverhaulItemAware;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class}, priority=1)
public class GuiGraphicsMixin {
    @Unique
    private static ItemStack tooltipoverhaul$cachedMainStack = ItemStack.EMPTY;
    @Unique
    private static long tooltipoverhaul$hoverStartTime = 0L;

    @Inject(method={"renderTooltipInternal"}, at={@At(value="HEAD")}, cancellable=true)
    private void tooltipoverhaul$coreRenderCall(Font font, List<ClientTooltipComponent> components, int mouseX, int mouseY, ClientTooltipPositioner tooltipPositioner, CallbackInfo ci) {
        int screenWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        int screenHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        ItemStack stack = ((ITooltipOverhaulItemAware)((Object)this)).tooltipsOverhaul$hoveredItem();
        this.tooltipoverhaul$calculateCounterValue(stack);
        tooltipoverhaul$cachedMainStack = stack.copy();
        TooltipContext equippedStackContext = EquippedContextCalculator.from((GuiGraphics)this, font, mouseX, mouseY, tooltipPositioner, stack, screenWidth, screenHeight);
        TooltipRenderer equippedStackRenderer = new TooltipRenderer(equippedStackContext);
        InputConstants.Key compareKey = ((KeyMappingAccessor)TooltipOverhaulKeyMappings.COMPARE_TOOLTIP).tooltipoverhaul$key();
        boolean isKeyDown = false;
        if (!compareKey.equals((Object)InputConstants.UNKNOWN)) {
            isKeyDown = InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)compareKey.getValue());
        }
        List<ClientTooltipComponent> componentList = isKeyDown && equippedStackContext != null ? TextUtils.getTooltipComponentsFrom(stack, font, screenWidth, 2.2f) : components;
        TooltipContext context = new TooltipContext((GuiGraphics)this, font, componentList, mouseX, mouseY, screenWidth, screenHeight, tooltipPositioner, stack, true);
        TooltipRenderer renderer = new TooltipRenderer(context);
        if (equippedStackContext != null) {
            context.setOtherTooltipContext(equippedStackContext);
            equippedStackContext.setOtherTooltipContext(context);
        }
        equippedStackRenderer.init();
        renderer.init();
        if (equippedStackContext != null) {
            equippedStackRenderer.adjustLayout();
            renderer.adjustLayout();
        }
        if (renderer.render()) {
            if (equippedStackContext != null) {
                equippedStackRenderer.render();
            }
            ci.cancel();
        }
    }

    @Unique
    private void tooltipoverhaul$calculateCounterValue(ItemStack of) {
        if (ItemStack.isSameItemSameComponents((ItemStack)tooltipoverhaul$cachedMainStack, (ItemStack)of)) {
            long elapsed = System.currentTimeMillis() - tooltipoverhaul$hoverStartTime;
            TooltipRenderer.COUNTER = (float)elapsed / 1000.0f;
        } else {
            tooltipoverhaul$hoverStartTime = System.currentTimeMillis();
            TooltipRenderer.COUNTER = 0.0f;
        }
    }
}

