/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.frame;

import dev.xylonity.tooltipoverhaul.TooltipOverhaul;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameData;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameLoader;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;

public class CustomFrameManager {
    private static final Map<class_2960, CustomFrameData> customFrames = new ConcurrentHashMap<class_2960, CustomFrameData>();
    private static boolean INIT = false;

    public static void initialize() {
        if (INIT) {
            return;
        }
        try {
            customFrames.clear();
            customFrames.putAll(CustomFrameLoader.loadCustomFrames(class_310.method_1551().method_1478(), TooltipOverhaul.PLATFORM.getConfigPath()));
            INIT = true;
            TooltipOverhaul.LOGGER.info("{} frames have been loaded!", (Object)customFrames.size());
        }
        catch (Exception e) {
            TooltipOverhaul.LOGGER.error("Failed to initialize custom frames loader: {}", (Object)e.getMessage());
        }
    }

    public static void initialize(class_3300 resourceManager) {
        if (INIT) {
            return;
        }
        try {
            customFrames.clear();
            customFrames.putAll(CustomFrameLoader.loadCustomFrames(resourceManager, TooltipOverhaul.PLATFORM.getConfigPath()));
            INIT = true;
            TooltipOverhaul.LOGGER.info("{} frames have been loaded!", (Object)customFrames.size());
        }
        catch (Exception e) {
            TooltipOverhaul.LOGGER.error("Failed to initialize custom frames loader: {}", (Object)e.getMessage());
        }
    }

    public static void reset() {
        customFrames.clear();
        INIT = false;
    }

    public static Optional<CustomFrameData> of(class_1799 stack) {
        if (!INIT) {
            CustomFrameManager.initialize();
        }
        return customFrames.values().stream().filter(cfg -> cfg.matches(stack)).findFirst();
    }
}

