/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.layout;

import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.PositionUtils;
import dev.xylonity.tooltipoverhaul.client.util.TextAxis;
import net.minecraft.class_241;

public class TooltipPositionCalculator {
    private final TooltipContext context;

    public TooltipPositionCalculator(TooltipContext context) {
        this.context = context;
    }

    public class_241 calculate() {
        boolean isMainTooltip = this.context.isMainTooltip();
        int paddingX = this.context.getPaddingX();
        int paddingY = this.context.getPaddingY();
        int mouseX = this.context.getMouseX();
        int mouseY = this.context.getMouseY();
        int tooltipWidth = (int)this.context.getTooltipSize().field_1343;
        int tooltipHeight = (int)this.context.getTooltipSize().field_1342;
        int screenWidth = this.context.getScreenWidth();
        int screenHeight = this.context.getScreenHeight();
        float posX = mouseX + (isMainTooltip ? 12 : -12) + PositionUtils.getMainPanelPosition(this.context, TextAxis.X);
        float posY = mouseY - 12 + PositionUtils.getMainPanelPosition(this.context, TextAxis.Y);
        if (isMainTooltip) {
            boolean hasEquippedContext;
            TooltipContext equippedContext = this.context.getOtherTooltipContext();
            boolean bl = hasEquippedContext = equippedContext != null;
            if (!hasEquippedContext && posX + (float)tooltipWidth > (float)screenWidth) {
                posX = mouseX - tooltipWidth - 12;
            }
            if (posX + (float)tooltipWidth + (float)paddingX > (float)screenWidth) {
                posX = screenWidth - tooltipWidth - paddingX;
            }
            if (posX < (float)paddingX) {
                posX = paddingX;
            }
            if (posY + (float)tooltipHeight + (float)paddingY > (float)screenHeight) {
                posY = screenHeight - tooltipHeight - paddingY;
            }
            if (posY < (float)paddingY) {
                posY = paddingY;
            }
        } else {
            posX -= (float)tooltipWidth;
        }
        return new class_241(posX, posY);
    }

    public class_241 adjustPosition() {
        class_241 otherContextSize;
        class_241 newPosition = this.context.getTooltipPosition();
        boolean isMainTooltip = this.context.isMainTooltip();
        int paddingX = this.context.getPaddingX();
        int paddingY = this.context.getPaddingY();
        int mouseY = this.context.getMouseY();
        int tooltipHeight = (int)this.context.getTooltipSize().field_1342;
        int screenHeight = this.context.getScreenHeight();
        float posY = mouseY - 12;
        TooltipContext otherContext = this.context.getOtherTooltipContext();
        class_241 otherContextPosition = otherContext != null ? otherContext.getTooltipPosition() : null;
        class_241 class_2412 = otherContextSize = otherContext != null ? otherContext.getTooltipSize() : null;
        if (isMainTooltip) {
            if (otherContextPosition != null && otherContextSize != null && otherContextPosition.field_1343 <= (float)(paddingX * 2)) {
                newPosition = new class_241(otherContextPosition.field_1343 + otherContextSize.field_1343 + 24.0f, newPosition.field_1342);
            }
            if (otherContext != null && !otherContext.isMainTooltip()) {
                boolean equippedClampedAtTop;
                int equippedHeight = otherContextSize != null ? (int)otherContextSize.field_1342 : 0;
                float equippedPosY = mouseY - 12;
                boolean equippedClampedAtBottom = equippedPosY + (float)equippedHeight + (float)paddingY > (float)screenHeight;
                boolean bl = equippedClampedAtTop = equippedPosY < (float)paddingY;
                if (equippedClampedAtBottom || equippedClampedAtTop) {
                    newPosition = equippedClampedAtBottom ? new class_241(newPosition.field_1343, (float)(screenHeight - equippedHeight - paddingY)) : new class_241(newPosition.field_1343, (float)paddingY);
                }
            }
            int margin = 100;
            if (otherContextPosition != null && otherContextSize != null && posY != otherContextPosition.field_1342) {
                int difference = (int)(posY - otherContextPosition.field_1342);
                int n = difference = difference < 0 ? -difference : difference;
                if (difference > margin) {
                    newPosition = new class_241(newPosition.field_1343, (float)screenHeight / 2.0f - (float)tooltipHeight / 2.0f);
                }
            }
        } else {
            float finalY;
            if (posY + (float)tooltipHeight + (float)paddingY > (float)screenHeight) {
                posY = screenHeight - tooltipHeight - paddingY;
            }
            if (posY < (float)paddingY) {
                posY = paddingY;
            }
            if (otherContextPosition != null && otherContextSize != null) {
                newPosition = new class_241(0.0f, this.context.getTooltipPosition().field_1342).method_35586(new class_241(otherContextPosition.field_1343 - 24.0f - this.context.getTooltipSize().field_1343, 0.0f));
                newPosition = new class_241(newPosition.field_1343, otherContextPosition.field_1342);
                if (newPosition.field_1343 < (float)this.context.getPaddingX()) {
                    newPosition = new class_241((float)(this.context.getPaddingX() * 2), newPosition.field_1342);
                }
            }
            int margin = 100;
            if (otherContextPosition != null && otherContextSize != null && posY != otherContextPosition.field_1342) {
                int difference = (int)(posY - otherContextPosition.field_1342);
                int n = difference = difference < 0 ? -difference : difference;
                if (difference > margin) {
                    newPosition = new class_241(newPosition.field_1343, (float)screenHeight / 2.0f - (float)tooltipHeight / 2.0f);
                }
            }
            if ((finalY = newPosition.field_1342) + (float)tooltipHeight + (float)paddingY > (float)screenHeight) {
                finalY = screenHeight - tooltipHeight - paddingY;
            }
            if (finalY < (float)paddingY) {
                finalY = paddingY;
            }
            newPosition = new class_241(newPosition.field_1343, finalY);
        }
        return newPosition;
    }
}

