/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.layout;

import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.Constants;
import dev.xylonity.tooltipoverhaul.client.util.RenderUtils;
import dev.xylonity.tooltipoverhaul.client.util.TextUtils;
import java.util.List;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;

public class TooltipSizeCalculator {
    private final TooltipContext context;

    public TooltipSizeCalculator(TooltipContext context) {
        this.context = context;
    }

    public class_241 calculate() {
        boolean hasIcon = this.context.hasIcon();
        boolean hasRating = RenderUtils.hasRating(this.context);
        boolean hasDividerLine = this.context.hasDividerLine();
        List<class_5684> components = this.context.getComponents();
        class_327 font = this.context.getFont();
        int paddingX = this.context.getPaddingX();
        int paddingY = this.context.getPaddingY();
        int iconOffset = hasIcon ? Constants.getIconSize(this.context) + Constants.getIconTitleSeparation(this.context) : 0;
        int width = components.get(0).method_32664(font) + paddingX * 2 + iconOffset;
        int height = components.get(0).method_32661() + paddingY * 2;
        for (int i = 0; i < components.size(); ++i) {
            if (i <= 0) continue;
            height += components.get(i).method_32661();
            width = Math.max(width, components.get(i).method_32664(font) + paddingX * 2);
        }
        if (hasRating) {
            class_2561 rating = TextUtils.getRatingText(this.context);
            width = Math.max(width, font.method_27525((class_5348)rating) + paddingX * 2 + iconOffset);
            if (!hasIcon) {
                height += class_5684.method_32662((class_5481)rating.method_30937()).method_32661();
            }
        }
        if (hasIcon) {
            height += Constants.getIconSize(this.context) - 10;
        }
        if (hasDividerLine && components.size() > 1) {
            height = hasIcon ? (height += Constants.getDividerLineFullPadding(this.context)) : (height += Constants.getDividerLineFullPadding(this.context));
        }
        return new class_241((float)width, (float)height);
    }

    public class_241 adjustSize() {
        class_241 otherContextSize;
        class_241 newSize = this.context.getTooltipSize();
        boolean isMainTooltip = this.context.isMainTooltip();
        TooltipContext otherContext = this.context.getOtherTooltipContext();
        class_241 otherContextPosition = otherContext != null ? otherContext.getTooltipPosition() : null;
        class_241 class_2412 = otherContextSize = otherContext != null ? otherContext.getTooltipSize() : null;
        if (isMainTooltip && otherContextPosition != null && otherContextSize != null && otherContextPosition.field_1343 == (float)this.context.getPaddingX() && this.context.getTooltipPosition().field_1343 + this.context.getTooltipSize().field_1343 > (float)this.context.getScreenWidth()) {
            newSize = new class_241((float)(this.context.getScreenWidth() - this.context.getPaddingX()) - this.context.getTooltipPosition().field_1343, newSize.field_1342);
        }
        return newSize;
    }
}

