/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.render;

import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameData;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameManager;
import dev.xylonity.tooltipoverhaul.client.layer.ITooltipLayer;
import dev.xylonity.tooltipoverhaul.client.layer.LayerDepth;
import dev.xylonity.tooltipoverhaul.client.layout.TooltipPositionCalculator;
import dev.xylonity.tooltipoverhaul.client.layout.TooltipSizeCalculator;
import dev.xylonity.tooltipoverhaul.client.util.RenderUtils;
import dev.xylonity.tooltipoverhaul.client.util.TextAxis;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_241;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5684;
import net.minecraft.class_7833;
import net.minecraft.class_8000;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TooltipContext {
    private final class_332 graphics;
    private final class_327 font;
    private final List<class_5684> components;
    private final int mouseX;
    private final int mouseY;
    private final int screenWidth;
    private final int screenHeight;
    private final class_8000 tooltipPositioner;
    private final class_1799 stack;
    private class_241 tooltipSize;
    private class_241 tooltipPosition;
    private LayerDepth layerDepth;
    private List<ITooltipLayer> layers;
    @Nullable
    private final CustomFrameData frameData;
    private final boolean isMainTooltip;
    private final boolean isEmptyTooltip;
    private final boolean hasIcon;
    private final boolean hasDividerLine;
    private final int paddingX;
    private final int paddingY;
    private final TooltipPositionCalculator positionCalculator;
    private final TooltipSizeCalculator sizeCalculator;
    private static final long START_TIME = System.currentTimeMillis();
    @Nullable
    private TooltipContext otherTooltipContext = null;

    public TooltipContext(class_332 graphics, class_327 font, List<class_5684> components, int mouseX, int mouseY, int screenWidth, int screenHeight, class_8000 tooltipPositioner, @NotNull class_1799 stack, boolean isMainTooltip) {
        this.graphics = graphics;
        this.font = font;
        this.components = components;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.tooltipPositioner = tooltipPositioner;
        this.stack = stack;
        this.isMainTooltip = isMainTooltip;
        this.frameData = CustomFrameManager.of(stack).orElse(null);
        this.isEmptyTooltip = stack.method_7960();
        this.hasIcon = RenderUtils.hasIcon(this);
        this.hasDividerLine = RenderUtils.hasDividerLine(this);
        this.paddingX = RenderUtils.calculatePadding(this, TextAxis.X);
        this.paddingY = RenderUtils.calculatePadding(this, TextAxis.Y);
        this.positionCalculator = new TooltipPositionCalculator(this);
        this.sizeCalculator = new TooltipSizeCalculator(this);
    }

    public class_332 getGraphics() {
        return this.graphics;
    }

    public class_327 getFont() {
        return this.font;
    }

    public List<class_5684> getComponents() {
        return this.components;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public class_8000 getTooltipPositioner() {
        return this.tooltipPositioner;
    }

    public class_4597 getBuffer() {
        return this.graphics.method_51450();
    }

    public class_1799 getStack() {
        return this.stack;
    }

    public boolean isMainTooltip() {
        return this.isMainTooltip;
    }

    public void setTooltipSize(class_241 tooltipSize) {
        this.tooltipSize = tooltipSize;
    }

    public class_241 getTooltipSize() {
        return this.tooltipSize;
    }

    public void setTooltipPosition(class_241 tooltipPosition) {
        this.tooltipPosition = tooltipPosition;
    }

    public void setLayerDepth(LayerDepth layerDepth) {
        this.layerDepth = layerDepth;
    }

    public LayerDepth getLayerDepth() {
        return this.layerDepth;
    }

    public class_241 getTooltipPosition() {
        return this.tooltipPosition;
    }

    public void setTooltipLayers(List<ITooltipLayer> layers) {
        this.layers = layers;
    }

    public List<ITooltipLayer> getTooltipLayers() {
        return this.layers;
    }

    public boolean isEmptyTooltip() {
        return this.isEmptyTooltip;
    }

    public boolean hasIcon() {
        return this.hasIcon;
    }

    public boolean hasDividerLine() {
        return this.hasDividerLine;
    }

    public long getStartTime() {
        return START_TIME;
    }

    public int getPaddingX() {
        return this.paddingX;
    }

    public int getPaddingY() {
        return this.paddingY;
    }

    public TooltipPositionCalculator getPositionCalculator() {
        return this.positionCalculator;
    }

    public TooltipSizeCalculator getSizeCalculator() {
        return this.sizeCalculator;
    }

    @Nullable
    public CustomFrameData getFrameData() {
        return this.frameData;
    }

    public void setOtherTooltipContext(@Nullable TooltipContext otherTooltipContext) {
        this.otherTooltipContext = otherTooltipContext;
    }

    @Nullable
    public TooltipContext getOtherTooltipContext() {
        return this.otherTooltipContext;
    }

    public void flush() {
        this.graphics.method_51452();
    }

    public class_4587 getPose() {
        return this.graphics.method_51448();
    }

    public void push(Runnable r) {
        this.getPose().method_22903();
        try {
            r.run();
        }
        finally {
            this.getPose().method_22909();
        }
    }

    public void translate(float x, float y, float z) {
        this.getPose().method_46416(x, y, z);
    }

    public void scale(float x, float y, float z) {
        this.getPose().method_22905(x, y, z);
    }

    public void multiply(class_7833 axis, float degrees) {
        this.getPose().method_22907(axis.rotationDegrees(degrees));
    }
}

