/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.xylonity.tooltipoverhaul.config.ConfigManager;
import dev.xylonity.tooltipoverhaul.config.TooltipsConfig;
import dev.xylonity.tooltipoverhaul.config.wrapper.ConfigEntry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public class TooltipOverhaulConfigScreen
extends class_437 {
    private final class_437 parent;
    private ConfigPanel panel;
    private class_342 searchBox;
    private float searchHoverProgress = 0.0f;
    private static final int HEADER_HEIGHT = 64;

    public TooltipOverhaulConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Tooltip Overhaul Config"));
        this.parent = parent;
    }

    protected void method_57734(float partialTick) {
    }

    protected void method_25426() {
        int panelTop = 72;
        int panelBottom = this.field_22790 - 40;
        int panelHeight = Math.max(0, panelBottom - panelTop);
        this.panel = new ConfigPanel(20, panelTop, this.field_22789 - 40, panelHeight);
        this.method_37063((class_364)this.panel);
        int searchWidth = 240;
        int searchX = this.panel.method_46426() + 10;
        int searchY = 38;
        this.searchBox = new CenteredEditBox(this.field_22793, searchX, searchY, searchWidth, 20, (class_2561)class_2561.method_43470((String)"Search"));
        this.searchBox.method_47404((class_2561)class_2561.method_43470((String)"Search settings..."));
        this.searchBox.method_1863(this::onSearchChanged);
        this.searchBox.method_1858(false);
        this.searchBox.method_1868(-1513240);
        this.searchBox.method_1860(-8947849);
        this.method_37063((class_364)this.searchBox);
        for (Field field : TooltipsConfig.class.getDeclaredFields()) {
            ConfigEntry meta = field.getAnnotation(ConfigEntry.class);
            if (meta == null) continue;
            field.setAccessible(true);
            this.panel.addConfigEntry(field, meta);
        }
        int buttonWidth = 120;
        int buttonHeight = 20;
        int spacing = 10;
        int totalWidth = buttonWidth * 2 + spacing;
        int startX = (this.field_22789 - totalWidth) / 2;
        int buttonY = this.field_22790 - 28;
        this.method_37063((class_364)new ConfigPanel.ModernButton(startX, buttonY, buttonWidth, buttonHeight, class_5244.field_24334, b -> {
            this.saveConfig();
            this.field_22787.method_1507(this.parent);
        }));
        this.method_37063((class_364)new ConfigPanel.ModernButton(startX + buttonWidth + spacing, buttonY, buttonWidth, buttonHeight, (class_2561)class_2561.method_43470((String)"Cancel"), b -> this.field_22787.method_1507(this.parent)));
        this.panel.applySearch("");
    }

    private void onSearchChanged(String text) {
        if (this.panel != null) {
            this.panel.applySearch(text);
        }
    }

    private void saveConfig() {
        if (this.panel != null) {
            this.panel.applyToFields();
            ConfigManager.save(TooltipsConfig.class);
        }
    }

    public void method_25393() {
        if (this.panel != null) {
            this.panel.tickPanel();
        }
        super.method_25393();
    }

    public void method_25419() {
        this.saveConfig();
        this.field_22787.method_1507(this.parent);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, -15724528);
        this.renderHeader(graphics);
        this.renderSearchBackground(graphics, mouseX, mouseY);
        this.renderFooterSeparator(graphics);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    private void renderFooterSeparator(class_332 graphics) {
        int lineW = (int)((float)this.field_22789 * 0.8f);
        int x0 = (this.field_22789 - lineW) / 2;
        int x1 = x0 + lineW;
        int y = this.field_22790 - 36;
        int h = 1;
        int red = 77;
        int green = 77;
        int blue = 77;
        int centerX = x0 + lineW / 2;
        class_4587 pose = graphics.method_51448();
        Matrix4f matrix = pose.method_23760().method_23761();
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        buffer.method_22918(matrix, (float)x0, (float)(y + h), 0.0f).method_1336(red, green, blue, 0);
        buffer.method_22918(matrix, (float)centerX, (float)(y + h), 0.0f).method_1336(red, green, blue, 255);
        buffer.method_22918(matrix, (float)centerX, (float)y, 0.0f).method_1336(red, green, blue, 255);
        buffer.method_22918(matrix, (float)x0, (float)y, 0.0f).method_1336(red, green, blue, 0);
        buffer.method_22918(matrix, (float)centerX, (float)(y + h), 0.0f).method_1336(red, green, blue, 255);
        buffer.method_22918(matrix, (float)x1, (float)(y + h), 0.0f).method_1336(red, green, blue, 0);
        buffer.method_22918(matrix, (float)x1, (float)y, 0.0f).method_1336(red, green, blue, 0);
        buffer.method_22918(matrix, (float)centerX, (float)y, 0.0f).method_1336(red, green, blue, 255);
        try (class_9801 data = buffer.method_60800();){
            class_286.method_43433((class_9801)data);
        }
        RenderSystem.disableBlend();
    }

    private void renderHeader(class_332 graphics) {
        for (int i = 0; i < 64; ++i) {
            int alpha = Math.max(0, 80 - i * 2);
            if (alpha <= 0) continue;
            int color = alpha << 24;
            graphics.method_25294(0, i, this.field_22789, i + 1, color);
        }
        String brandTitle = "Tooltip Overhaul";
        int brandTitleWidth = this.field_22793.method_1727(brandTitle);
        int brandTitleX = this.field_22789 - 18 - brandTitleWidth;
        int brandTitleY = 10;
        graphics.method_51433(this.field_22793, brandTitle, brandTitleX, brandTitleY, -1, false);
        String brandSubtitle = "Every tooltip, more modern, sharper, cleaner.";
        int brandSubtitleWidth = this.field_22793.method_1727(brandSubtitle);
        int brandSubtitleX = this.field_22789 - 18 - brandSubtitleWidth;
        int brandSubtitleY = brandTitleY + 12;
        graphics.method_51433(this.field_22793, brandSubtitle, brandSubtitleX, brandSubtitleY, -5592406, false);
    }

    private void renderSearchBackground(class_332 graphics, int mouseX, int mouseY) {
        if (this.searchBox == null) {
            return;
        }
        int boxX = this.searchBox.method_46426();
        int boxY = this.searchBox.method_46427();
        int boxW = this.searchBox.method_25368();
        int boxH = this.searchBox.method_25364();
        boolean hovered = mouseX >= boxX && mouseX <= boxX + boxW && mouseY >= boxY && mouseY <= boxY + boxH;
        boolean active = hovered || this.searchBox.method_25370();
        float step = 0.1f;
        this.searchHoverProgress = active ? Math.min(1.0f, this.searchHoverProgress + step) : Math.max(0.0f, this.searchHoverProgress - step);
        graphics.method_25294(boxX, boxY, boxX + boxW, boxY + boxH, 0x35353535);
        int baseBorder = 2;
        int extraBorder = Math.round(this.searchHoverProgress * 2.0f);
        int borderW = baseBorder + extraBorder;
        int idleBorder = 0x40FFFFFF;
        int hoverBorder = -11886849;
        int borderColor = this.searchHoverProgress > 0.0f ? hoverBorder : idleBorder;
        graphics.method_25294(boxX, boxY, boxX + borderW, boxY + boxH, borderColor);
        if (this.searchHoverProgress > 0.0f) {
            int gradientW = Math.min(120, boxW / 3);
            int maxA = (int)(64.0f * this.searchHoverProgress);
            class_4587 pose = graphics.method_51448();
            Matrix4f matrix = pose.method_23760().method_23761();
            class_289 tesselator = class_289.method_1348();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(class_757::method_34540);
            class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
            int x0 = boxX;
            int x1 = boxX + gradientW;
            int y0 = boxY;
            int y1 = boxY + boxH;
            bufferBuilder.method_22918(matrix, (float)x0, (float)y1, 0.0f).method_1336(74, 158, 255, maxA);
            bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_1336(74, 158, 255, 0);
            bufferBuilder.method_22918(matrix, (float)x1, (float)y0, 0.0f).method_1336(74, 158, 255, 0);
            bufferBuilder.method_22918(matrix, (float)x0, (float)y0, 0.0f).method_1336(74, 158, 255, maxA);
            try (class_9801 data = bufferBuilder.method_60800();){
                class_286.method_43433((class_9801)data);
            }
            RenderSystem.disableBlend();
        }
    }

    static class ConfigPanel
    extends class_339 {
        private final List<ValueEntry> allEntries = new ArrayList<ValueEntry>();
        private final List<ValueEntry> visibleEntries = new ArrayList<ValueEntry>();
        private double scrollAmount = 0.0;
        private double targetScroll = 0.0;
        private static final int ROW_GAP = 4;
        private boolean draggingScrollbar = false;
        private int dragThumbOffsetY = 0;
        private ValueEntry focusedEntry = null;

        public ConfigPanel(int x, int y, int width, int height) {
            super(x, y, width, height, (class_2561)class_2561.method_43473());
        }

        public void tickPanel() {
            for (ValueEntry valueEntry : this.visibleEntries) {
            }
        }

        public void addConfigEntry(Field field, ConfigEntry meta) {
            ValueEntry entry = new ValueEntry(field, meta);
            this.allEntries.add(entry);
            this.visibleEntries.add(entry);
            this.recalcLayout();
        }

        public void applySearch(String query) {
            this.visibleEntries.clear();
            ValueEntry prevFocused = this.focusedEntry;
            this.focusedEntry = null;
            if (query == null || query.isBlank()) {
                this.visibleEntries.addAll(this.allEntries);
            } else {
                String queryLowerCase = query.toLowerCase();
                for (ValueEntry valueEntry : this.allEntries) {
                    if (!valueEntry.matches(queryLowerCase)) continue;
                    this.visibleEntries.add(valueEntry);
                }
            }
            if (prevFocused != null && this.visibleEntries.contains(prevFocused)) {
                this.focusedEntry = prevFocused;
                this.focusedEntry.setFocused(true);
            } else if (prevFocused != null) {
                prevFocused.setFocused(false);
            }
            this.recalcLayout();
        }

        public void applyToFields() {
            for (ValueEntry entry : this.allEntries) {
                entry.applyToField();
            }
        }

        private int getContentWidth() {
            return this.field_22758 - 20;
        }

        private int getRowLeft() {
            return this.method_46426() + 10;
        }

        private void recalcLayout() {
            int rowWidth = this.getContentWidth();
            for (ValueEntry e : this.visibleEntries) {
                e.recalculateHeight(rowWidth);
            }
            this.clampScroll();
        }

        private int getTotalContentHeight() {
            int total = 4;
            boolean first = true;
            for (ValueEntry e : this.visibleEntries) {
                if (!first) {
                    total += 4;
                }
                total += e.getHeight();
                first = false;
            }
            return total;
        }

        private void clampScroll() {
            int innerHeight = this.field_22759;
            int contentHeight = this.getTotalContentHeight();
            if (contentHeight <= innerHeight) {
                this.scrollAmount = 0.0;
                this.targetScroll = 0.0;
            } else {
                double maxScroll;
                if (this.targetScroll < 0.0) {
                    this.targetScroll = 0.0;
                }
                if (this.targetScroll > (maxScroll = (double)(contentHeight - innerHeight))) {
                    this.targetScroll = maxScroll;
                }
                if (this.scrollAmount < 0.0) {
                    this.scrollAmount = 0.0;
                }
                if (this.scrollAmount > maxScroll) {
                    this.scrollAmount = maxScroll;
                }
            }
        }

        private boolean isInside(double mouseX, double mouseY) {
            return mouseX >= (double)this.method_46426() && mouseX <= (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY <= (double)(this.method_46427() + this.field_22759);
        }

        private boolean hasScrollableContent() {
            return this.getTotalContentHeight() > this.field_22759;
        }

        private ScrollbarGeom getScrollbarGeom() {
            int contentHeight = this.getTotalContentHeight();
            int left = this.method_46426();
            int top = this.method_46427();
            int right = left + this.field_22758;
            int barWidth = 6;
            int trackX0 = right - barWidth;
            int trackX1 = right;
            double maxScroll = Math.max(0.0, (double)(contentHeight - this.field_22759));
            double scrollRatio = maxScroll <= 0.0 ? 0.0 : this.scrollAmount / maxScroll;
            double visibleRatio = (double)this.field_22759 / (double)contentHeight;
            int thumbH = (int)((double)this.field_22759 * visibleRatio);
            if (thumbH < 24) {
                thumbH = 24;
            }
            if (thumbH > this.field_22759) {
                thumbH = this.field_22759;
            }
            int thumbY = top + (int)((double)(this.field_22759 - thumbH) * scrollRatio);
            return new ScrollbarGeom(trackX0, trackX1, top, top + this.field_22759, thumbY, thumbY + thumbH, thumbH, maxScroll);
        }

        protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (!this.field_22764) {
                return;
            }
            if (!this.draggingScrollbar && this.scrollAmount != this.targetScroll) {
                double diff = this.targetScroll - this.scrollAmount;
                this.scrollAmount = Math.abs(diff) < 0.5 ? this.targetScroll : (this.scrollAmount += diff * 0.2);
                this.clampScroll();
            }
            int left = this.method_46426();
            int top = this.method_46427();
            int right = left + this.field_22758;
            int bottom = top + this.field_22759;
            guiGraphics.method_25294(left, top, right, bottom, -15658735);
            guiGraphics.method_44379(left, top, right, bottom);
            int rowLeft = this.getRowLeft();
            int rowWidth = this.getContentWidth();
            int currentY = top + 4 - (int)this.scrollAmount;
            int index = 0;
            boolean first = true;
            for (ValueEntry valueEntry : this.visibleEntries) {
                int rowTop;
                int rowBottom;
                int rowHeight = valueEntry.getHeight();
                if (!first) {
                    currentY += 4;
                }
                if ((rowBottom = (rowTop = currentY) + rowHeight) >= top && rowTop <= bottom) {
                    boolean mouseInPanel = mouseX >= left && mouseX <= right && mouseY >= top && mouseY <= bottom;
                    boolean hovered = mouseInPanel && mouseX >= rowLeft && mouseX <= rowLeft + rowWidth && mouseY >= rowTop && mouseY <= rowBottom;
                    valueEntry.render(guiGraphics, index, rowTop, rowLeft, rowWidth, rowHeight, mouseX, mouseY, hovered, partialTick);
                }
                currentY += rowHeight;
                ++index;
                first = false;
            }
            guiGraphics.method_44380();
            this.renderScrollbar(guiGraphics);
        }

        private void renderScrollbar(class_332 guiGraphics) {
            if (!this.hasScrollableContent()) {
                return;
            }
            ScrollbarGeom scrollbarGeom = this.getScrollbarGeom();
            guiGraphics.method_25294(scrollbarGeom.trackX0, scrollbarGeom.trackTop, scrollbarGeom.trackX1, scrollbarGeom.trackBottom, Integer.MIN_VALUE);
            guiGraphics.method_25294(scrollbarGeom.trackX0, scrollbarGeom.thumbTop, scrollbarGeom.trackX1, scrollbarGeom.thumbBottom, -11886849);
        }

        public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
            if (!this.field_22764) {
                return false;
            }
            if (!this.isInside(mouseX, mouseY)) {
                return false;
            }
            if (!this.hasScrollableContent()) {
                return false;
            }
            this.draggingScrollbar = false;
            this.targetScroll -= verticalAmount * 20.0;
            this.clampScroll();
            return true;
        }

        private void clearFocus() {
            if (this.focusedEntry != null) {
                this.focusedEntry.setFocused(false);
                this.focusedEntry = null;
            }
        }

        private void setFocus(ValueEntry entry) {
            if (this.focusedEntry == entry) {
                return;
            }
            if (this.focusedEntry != null) {
                this.focusedEntry.setFocused(false);
            }
            this.focusedEntry = entry;
            if (this.focusedEntry != null) {
                this.focusedEntry.setFocused(true);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (!this.field_22764 || !this.field_22763) {
                return false;
            }
            if (!this.isInside(mouseX, mouseY)) {
                return false;
            }
            if (this.hasScrollableContent()) {
                ScrollbarGeom scrollbarGeom = this.getScrollbarGeom();
                if (mouseX >= (double)scrollbarGeom.trackX0 && mouseX <= (double)scrollbarGeom.trackX1) {
                    if (mouseY >= (double)scrollbarGeom.thumbTop && mouseY <= (double)scrollbarGeom.thumbBottom) {
                        this.draggingScrollbar = true;
                        this.dragThumbOffsetY = (int)mouseY - scrollbarGeom.thumbTop;
                        return true;
                    }
                    double time = (mouseY - (double)scrollbarGeom.trackTop) / (double)(scrollbarGeom.trackBottom - scrollbarGeom.trackTop);
                    time = Math.max(0.0, Math.min(1.0, time));
                    double desired = time * scrollbarGeom.maxScroll - (double)this.field_22759 * 0.5;
                    this.scrollAmount = this.targetScroll = Math.max(0.0, Math.min(scrollbarGeom.maxScroll, desired));
                    this.clampScroll();
                    return true;
                }
            }
            int top = this.method_46427();
            int rowLeft = this.getRowLeft();
            int rowWidth = this.getContentWidth();
            int currentY = top + 4 - (int)this.scrollAmount;
            boolean first = true;
            for (ValueEntry entry : this.visibleEntries) {
                int rowHeight = entry.getHeight();
                if (!first) {
                    currentY += 4;
                }
                int rowTop = currentY;
                int rowBottom = rowTop + rowHeight;
                if (mouseY >= (double)rowTop && mouseY <= (double)rowBottom && mouseX >= (double)rowLeft && mouseX <= (double)(rowLeft + rowWidth)) {
                    if (entry.mouseClicked(mouseX, mouseY, button)) {
                        this.setFocus(entry);
                        return true;
                    }
                    this.clearFocus();
                    return true;
                }
                currentY += rowHeight;
                first = false;
            }
            this.clearFocus();
            return false;
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (!this.field_22764 || !this.field_22763) {
                return false;
            }
            if (this.draggingScrollbar && this.hasScrollableContent()) {
                ScrollbarGeom scrollbarGeom = this.getScrollbarGeom();
                int trackSpan = scrollbarGeom.trackBottom - scrollbarGeom.trackTop - scrollbarGeom.thumbHeight;
                if (trackSpan <= 0) {
                    return true;
                }
                int desiredThumbTop = (int)mouseY - this.dragThumbOffsetY;
                int minThumbTop = scrollbarGeom.trackTop;
                int maxThumbTop = scrollbarGeom.trackBottom - scrollbarGeom.thumbHeight;
                desiredThumbTop = Math.max(minThumbTop, Math.min(maxThumbTop, desiredThumbTop));
                double t = (double)(desiredThumbTop - minThumbTop) / (double)(maxThumbTop - minThumbTop);
                this.scrollAmount = this.targetScroll = t * scrollbarGeom.maxScroll;
                this.clampScroll();
                return true;
            }
            return this.focusedEntry != null && this.focusedEntry.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            if (this.draggingScrollbar) {
                this.draggingScrollbar = false;
                return true;
            }
            if (this.focusedEntry != null) {
                return this.focusedEntry.mouseReleased(mouseX, mouseY, button);
            }
            return false;
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (this.focusedEntry != null && this.focusedEntry.keyPressed(keyCode, scanCode, modifiers)) {
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        public boolean method_25400(char codePoint, int modifiers) {
            if (this.focusedEntry != null && this.focusedEntry.charTyped(codePoint, modifiers)) {
                return true;
            }
            return super.method_25400(codePoint, modifiers);
        }

        protected void method_47399(class_6382 narrationElementOutput) {
        }

        private static class ValueEntry {
            private final Field field;
            private final class_2561 label;
            private final String commentText;
            private final class_339 valueWidget;
            private final boolean colorField;
            private final String searchIndex;
            private float hoverProgress = 0.0f;
            private int height = 40;
            private final Random particleRng;
            private final ArrayList<HoverParticle> hoverParticles = new ArrayList();
            private long lastParticleSpawnMs = 0L;
            private long lastParticleUpdateMs = 0L;
            private static final int PARTICLE_CAP = 22;

            public ValueEntry(Field field, ConfigEntry meta) {
                this.field = field;
                this.colorField = ValueEntry.isColorField(field, meta);
                String prettyLabel = ValueEntry.buildLabel(meta, field.getName());
                this.label = class_2561.method_43470((String)prettyLabel);
                this.commentText = meta.comment().trim();
                String raw = field.getName() + " " + field.getName().replace('_', ' ') + " " + prettyLabel + " " + meta.category() + " " + this.commentText;
                this.searchIndex = ValueEntry.normalizeForSearch(raw);
                this.valueWidget = this.createWidget();
                int seed = (field.getName() + "|" + meta.category() + "|" + meta.note()).hashCode();
                this.particleRng = new Random(seed);
                this.lastParticleUpdateMs = System.currentTimeMillis();
            }

            public int getHeight() {
                return this.height;
            }

            public void setFocused(boolean focused) {
                this.valueWidget.method_25365(focused);
                class_339 class_3392 = this.valueWidget;
                if (class_3392 instanceof class_342) {
                    class_342 box = (class_342)class_3392;
                    box.method_25365(focused);
                }
            }

            public void recalculateHeight(int rowWidth) {
                class_310 minecraft = class_310.method_1551();
                int PAD_TOP = 6;
                int LABEL_GAP = 3;
                Objects.requireNonNull(minecraft.field_1772);
                int LINE_H = 9;
                int widgetW = this.valueWidget.method_25368();
                int labelXRelative = 8;
                int available = rowWidth - widgetW - 10 - labelXRelative - 16;
                int commentMaxWidth = Math.min(available, (int)((float)rowWidth * 0.45f));
                int commentLines = 0;
                if (!this.commentText.isEmpty() && commentMaxWidth > 40) {
                    commentLines = minecraft.field_1772.method_1728((class_5348)class_2561.method_43470((String)this.commentText), commentMaxWidth).size();
                }
                int height = PAD_TOP + Math.max(this.valueWidget.method_25364(), LINE_H);
                if (commentLines > 0) {
                    height += LABEL_GAP + commentLines * LINE_H;
                }
                this.height = height;
            }

            private static boolean isColorField(Field field, ConfigEntry meta) {
                String name = field.getName().toLowerCase();
                if (name.contains("color") || name.contains("colour") || name.contains("palette")) {
                    return true;
                }
                if (meta != null) {
                    String note = meta.note().toLowerCase();
                    String comment = meta.comment().toLowerCase();
                    if (note.contains("color") || note.contains("colour") || note.contains("hex") || comment.contains("color") || comment.contains("palette") || comment.contains("argb")) {
                        return true;
                    }
                }
                return false;
            }

            private static String buildLabel(ConfigEntry meta, String fieldName) {
                String prettyName = ValueEntry.prettifyName(fieldName);
                String category = meta.category().trim();
                if (!category.isEmpty()) {
                    String catPretty = ValueEntry.prettifyName(category);
                    return catPretty + " \u203a " + prettyName;
                }
                return prettyName;
            }

            private static String prettifyName(String name) {
                String lower = name.toLowerCase().replace('$', ' ').replace('_', ' ');
                String[] parts = lower.split("\\s+");
                StringBuilder out = new StringBuilder();
                for (String part : parts) {
                    if (part.isEmpty()) continue;
                    if (out.length() > 0) {
                        out.append(' ');
                    }
                    out.append(Character.toUpperCase(part.charAt(0)));
                    if (part.length() <= 1) continue;
                    out.append(part.substring(1));
                }
                return out.toString();
            }

            private class_339 createWidget() {
                class_310 minecraft = class_310.method_1551();
                Class<?> type = this.field.getType();
                try {
                    if (type == Boolean.TYPE) {
                        boolean value = this.field.getBoolean(null);
                        return new ModernCheckbox(0, 0, 20, 20, (class_2561)class_2561.method_43473(), value);
                    }
                    if (type == Integer.TYPE && this.colorField) {
                        int value = this.field.getInt(null);
                        ModernEditBox box = new ModernEditBox(minecraft.field_1772, 0, 0, 100, 20, (class_2561)class_2561.method_43473());
                        box.method_1880(64);
                        box.method_1852(ValueEntry.formatColor(value));
                        return box;
                    }
                    String value = String.valueOf(this.field.get(null));
                    boolean isMultiColor = type == String.class && value.contains(",") && (value.contains("0x") || value.contains("#"));
                    int boxWidth = isMultiColor ? 260 : 180;
                    ModernEditBox box = new ModernEditBox(minecraft.field_1772, 0, 0, boxWidth, 20, (class_2561)class_2561.method_43473());
                    box.method_1880(512);
                    box.method_1852(value);
                    return box;
                }
                catch (Exception expection) {
                    ModernEditBox box = new ModernEditBox(class_310.method_1551().field_1772, 0, 0, 180, 20, (class_2561)class_2561.method_43473());
                    box.method_1880(512);
                    box.method_1852("");
                    return box;
                }
            }

            private static String formatColor(int argb) {
                return String.format("#%08X", argb);
            }

            public boolean matches(String query) {
                String normalizedQuery = ValueEntry.normalizeForSearch(query);
                if (normalizedQuery.isEmpty()) {
                    return true;
                }
                for (String token : normalizedQuery.split(" ")) {
                    if (token.isEmpty() || this.searchIndex.contains(token)) continue;
                    return false;
                }
                return true;
            }

            private static String normalizeForSearch(String string) {
                if (string == null) {
                    return "";
                }
                String out = string.toLowerCase();
                out = out.replace('_', ' ').replace('-', ' ').replace('.', ' ').replace('/', ' ');
                out = out.trim().replaceAll("\\s+", " ");
                return out;
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                return this.valueWidget.method_25402(mouseX, mouseY, button);
            }

            public boolean mouseReleased(double mouseX, double mouseY, int button) {
                return this.valueWidget.method_25406(mouseX, mouseY, button);
            }

            public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
                return this.valueWidget.method_25403(mouseX, mouseY, button, dragX, dragY);
            }

            public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
                return this.valueWidget.method_25404(keyCode, scanCode, modifiers);
            }

            public boolean charTyped(char codePoint, int modifiers) {
                return this.valueWidget.method_25400(codePoint, modifiers);
            }

            public void applyToField() {
                try {
                    Class<?> type = this.field.getType();
                    if (type == Boolean.TYPE) {
                        class_339 class_3392 = this.valueWidget;
                        if (class_3392 instanceof class_4286) {
                            class_4286 cb = (class_4286)class_3392;
                            this.field.setBoolean(null, cb.method_20372());
                        }
                        return;
                    }
                    class_339 class_3393 = this.valueWidget;
                    if (!(class_3393 instanceof class_342)) {
                        return;
                    }
                    class_342 box = (class_342)class_3393;
                    String raw = box.method_1882();
                    String trimmed = raw.trim();
                    if (type == String.class) {
                        this.field.set(null, raw);
                        return;
                    }
                    if (trimmed.isEmpty()) {
                        return;
                    }
                    if (type == Integer.TYPE) {
                        int current = this.field.getInt(null);
                        int value = this.colorField ? ValueEntry.parseColorInt(trimmed, current) : ValueEntry.parseIntFlexible(trimmed, current);
                        this.field.setInt(null, value);
                    } else if (type == Long.TYPE) {
                        long current = this.field.getLong(null);
                        long value = ValueEntry.parseLongFlexible(trimmed, current);
                        this.field.setLong(null, value);
                    } else if (type == Float.TYPE) {
                        try {
                            this.field.setFloat(null, Float.parseFloat(trimmed));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (type == Double.TYPE) {
                        try {
                            this.field.setDouble(null, Double.parseDouble(trimmed));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            private static int parseIntFlexible(String text, int fallback) {
                try {
                    Object string = text.trim();
                    if (((String)string).startsWith("0x") || ((String)string).startsWith("0X") || ((String)string).startsWith("#")) {
                        if (((String)string).startsWith("#")) {
                            string = "0x" + ((String)string).substring(1);
                        }
                        return Integer.decode((String)string);
                    }
                    return Integer.parseInt((String)string);
                }
                catch (Exception ignored) {
                    return fallback;
                }
            }

            private static long parseLongFlexible(String txt, long fallback) {
                try {
                    Object string = txt.trim();
                    if (((String)string).startsWith("0x") || ((String)string).startsWith("0X") || ((String)string).startsWith("#")) {
                        if (((String)string).startsWith("#")) {
                            string = "0x" + ((String)string).substring(1);
                        }
                        return Long.decode((String)string);
                    }
                    return Long.parseLong((String)string);
                }
                catch (Exception ignored) {
                    return fallback;
                }
            }

            private static int parseColorInt(String txt, int fallback) {
                try {
                    String string = txt.trim();
                    if (string.isEmpty()) {
                        return fallback;
                    }
                    if (string.startsWith("#")) {
                        string = string.substring(1);
                    }
                    if (string.startsWith("0x") || string.startsWith("0X")) {
                        string = string.substring(2);
                    }
                    if (string.length() == 6) {
                        long rgb = Long.parseLong(string, 16) & 0xFFFFFFL;
                        long argb = 0xFF000000L | rgb;
                        return (int)argb;
                    }
                    long argb = Long.parseLong(string, 16);
                    return (int)argb;
                }
                catch (Exception ignored) {
                    return fallback;
                }
            }

            public void render(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick) {
                int available;
                int commentMaxWidth;
                class_310 minecraft = class_310.method_1551();
                float step = 0.1f;
                this.hoverProgress = hovered ? Math.min(1.0f, this.hoverProgress + step) : Math.max(0.0f, this.hoverProgress - step);
                int baseAlpha = index % 2 == 0 ? 40 : 32;
                int extraAlpha = (int)(48.0f * this.hoverProgress);
                int totalAlpha = Math.min(255, baseAlpha + extraAlpha);
                int bgColor = totalAlpha << 24 | 0x353535;
                guiGraphics.method_25294(left, top, left + width, top + height, bgColor);
                int gradientWidth = Math.min(120, width / 3);
                if (this.hoverProgress > 0.0f) {
                    int maxAlpha = (int)(64.0f * this.hoverProgress);
                    for (int x = 0; x < gradientWidth; ++x) {
                        float t = (float)x / (float)gradientWidth;
                        int a = (int)((float)maxAlpha * (1.0f - t));
                        if (a <= 0) continue;
                        int color = a << 24 | 0x4A9EFF;
                        int x1 = left + x;
                        guiGraphics.method_25294(x1, top, x1 + 1, top + height, color);
                    }
                }
                int baseBorderWidth = 2;
                int extraBorder = Math.round(this.hoverProgress * 2.0f);
                int borderWidth = baseBorderWidth + extraBorder;
                int idleColor = 0x40FFFFFF;
                int hoverColor = -11886849;
                int borderColor = this.hoverProgress > 0.0f ? hoverColor : idleColor;
                guiGraphics.method_25294(left, top, left + borderWidth, top + height, borderColor);
                guiGraphics.method_25294(left, top + height - 1, left + width, top + height, 0x20000000);
                this.updateHoverParticles(top, height);
                if (this.hoverProgress > 0.15f) {
                    this.spawnHoverParticles(left, top, width, height, borderWidth, gradientWidth, this.hoverProgress);
                }
                this.renderHoverParticles(guiGraphics, this.hoverProgress);
                int labelX = left + 8;
                int labelY = top + 6;
                guiGraphics.method_51439(minecraft.field_1772, this.label, labelX + 1, labelY + 1, Integer.MIN_VALUE, false);
                guiGraphics.method_51439(minecraft.field_1772, this.label, labelX, labelY, -1, false);
                int widgetWidth = this.valueWidget.method_25368();
                int widgetHeight = this.valueWidget.method_25364();
                int widgetX = left + width - widgetWidth - 10;
                int widgetY = top + (height - widgetHeight) / 2;
                this.valueWidget.method_46421(widgetX);
                this.valueWidget.method_46419(widgetY);
                if (this.colorField && this.field.getType() == Integer.TYPE) {
                    try {
                        int color = this.field.getInt(null);
                        int previewSize = 18;
                        int previewRight = widgetX - 8;
                        int previewLeft = previewRight - previewSize;
                        int previewTop = top + (height - previewSize) / 2;
                        this.drawCheckerboard(guiGraphics, previewLeft, previewTop, previewSize, previewSize);
                        guiGraphics.method_25294(previewLeft, previewTop, previewRight, previewTop + previewSize, color);
                        guiGraphics.method_25294(previewLeft - 1, previewTop - 1, previewRight + 1, previewTop, -10461088);
                        guiGraphics.method_25294(previewLeft - 1, previewTop + previewSize, previewRight + 1, previewTop + previewSize + 1, -13619152);
                        guiGraphics.method_25294(previewLeft - 1, previewTop - 1, previewLeft, previewTop + previewSize + 1, -10461088);
                        guiGraphics.method_25294(previewRight, previewTop - 1, previewRight + 1, previewTop + previewSize + 1, -13619152);
                    }
                    catch (IllegalAccessException color) {
                        // empty catch block
                    }
                }
                this.valueWidget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                class_339 previewSize = this.valueWidget;
                if (previewSize instanceof class_342) {
                    class_342 box = (class_342)previewSize;
                    this.renderInlineColorBars(guiGraphics, box);
                }
                if (!this.commentText.isEmpty() && (commentMaxWidth = Math.min(available = widgetX - labelX - 16, (int)((float)width * 0.45f))) > 40) {
                    Objects.requireNonNull(minecraft.field_1772);
                    int lineHeight = 9;
                    Objects.requireNonNull(minecraft.field_1772);
                    int commentY = labelY + 9 + 3;
                    List lines = minecraft.field_1772.method_1728((class_5348)class_2561.method_43470((String)this.commentText), commentMaxWidth);
                    int availableHeight = top + height - commentY;
                    int maxLines = Math.max(1, availableHeight / lineHeight);
                    int drawn = 0;
                    for (class_5481 line : lines) {
                        if (drawn >= maxLines) break;
                        guiGraphics.method_51430(minecraft.field_1772, line, labelX, commentY, -6250336, false);
                        commentY += lineHeight;
                        ++drawn;
                    }
                }
            }

            private static List<Integer> extractColorsFromText(String text) {
                if (text == null) {
                    return Collections.emptyList();
                }
                String string = text.trim();
                if (string.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<Integer> out = new ArrayList<Integer>();
                Pattern prefixed = Pattern.compile("(?:#|0x|0X)([0-9a-fA-F]{8}|[0-9a-fA-F]{6})");
                Matcher matcher = prefixed.matcher(string);
                while (matcher.find()) {
                    String hex = matcher.group(1);
                    Integer color = ValueEntry.parseHexColorToken(hex);
                    if (color == null) continue;
                    out.add(color);
                }
                if (out.isEmpty()) {
                    Pattern bare = Pattern.compile("(?<![0-9a-fA-F])([0-9a-fA-F]{8}|[0-9a-fA-F]{6})(?![0-9a-fA-F])");
                    Matcher matcher2 = bare.matcher(string);
                    while (matcher2.find()) {
                        Integer color;
                        String token = matcher2.group(1);
                        boolean hasLetter = token.chars().anyMatch(ch -> ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102);
                        if (!hasLetter || (color = ValueEntry.parseHexColorToken(token)) == null) continue;
                        out.add(color);
                    }
                }
                return out;
            }

            private static Integer parseHexColorToken(String hex) {
                try {
                    if (hex.length() == 6) {
                        int rgb = (int)(Long.parseLong(hex, 16) & 0xFFFFFFL);
                        return 0xFF000000 | rgb;
                    }
                    if (hex.length() == 8) {
                        return (int)(Long.parseLong(hex, 16) & 0xFFFFFFFFL);
                    }
                    return null;
                }
                catch (Exception ignored) {
                    return null;
                }
            }

            private void renderInlineColorBars(class_332 g, class_342 box) {
                List<Integer> colors = ValueEntry.extractColorsFromText(box.method_1882());
                if (colors.isEmpty()) {
                    return;
                }
                int max = Math.min(colors.size(), 8);
                int bx = box.method_46426();
                int by = box.method_46427();
                int bw = box.method_25368();
                int bh = box.method_25364();
                int padRight = 3;
                int padY = 3;
                int barW = 4;
                int gap = 2;
                int stripW = max * barW + (max - 1) * gap;
                int x1 = bx + bw - padRight;
                int x0 = x1 - stripW;
                int y0 = by + padY;
                int y1 = by + bh - padY;
                for (int i = 0; i < max; ++i) {
                    int c = colors.get(i);
                    int px0 = x0 + i * (barW + gap);
                    int px1 = px0 + barW;
                    this.drawMiniChecker(g, px0, y0, barW, y1 - y0);
                    g.method_25294(px0, y0, px1, y1, c);
                }
            }

            private void drawMiniChecker(class_332 graphics, int x, int y, int w, int h) {
                int cs = 2;
                for (int yy = 0; yy < h; yy += cs) {
                    for (int xx = 0; xx < w; xx += cs) {
                        boolean light = (xx / cs + yy / cs) % 2 == 0;
                        int col = light ? -5197648 : -8750470;
                        int dx = Math.min(cs, w - xx);
                        int dy = Math.min(cs, h - yy);
                        graphics.method_25294(x + xx, y + yy, x + xx + dx, y + yy + dy, col);
                    }
                }
            }

            private void updateHoverParticles(int rowTop, int rowHeight) {
                long now = System.currentTimeMillis();
                long timeMs = Math.min(33L, Math.max(0L, now - this.lastParticleUpdateMs));
                this.lastParticleUpdateMs = now;
                float dateTime = timeMs;
                for (int i = this.hoverParticles.size() - 1; i >= 0; --i) {
                    HoverParticle particle = this.hoverParticles.get(i);
                    particle.ageMs += dateTime;
                    particle.x += particle.vx * dateTime;
                    particle.y = particle.baseY + (float)Math.sin(particle.phase + particle.ageMs * particle.freq) * particle.amp;
                    if (particle.ageMs >= particle.lifeMs) {
                        this.hoverParticles.remove(i);
                        continue;
                    }
                    if (!(particle.y < (float)(rowTop - 6)) && !(particle.y > (float)(rowTop + rowHeight + 6))) continue;
                    this.hoverParticles.remove(i);
                }
            }

            private void spawnHoverParticles(int left, int top, int width, int height, int borderW, int gradientW, float hoverProgress) {
                int minInterval;
                int maxInterval;
                int interval;
                long now = System.currentTimeMillis();
                if (now - this.lastParticleSpawnMs < (long)(interval = (int)((float)(maxInterval = 85) - (float)(maxInterval - (minInterval = 35)) * hoverProgress))) {
                    return;
                }
                this.lastParticleSpawnMs = now;
                if (this.hoverParticles.size() >= 22) {
                    return;
                }
                int count = hoverProgress > 0.6f && this.particleRng.nextFloat() < 0.55f ? 2 : 1;
                for (int n = 0; n < count && this.hoverParticles.size() < 22; ++n) {
                    int blue;
                    int green;
                    int red;
                    boolean white;
                    float spawnX = (float)(left + borderW - 1) + this.particleRng.nextFloat() * 2.0f;
                    float spawnY = (float)(top + 6) + this.particleRng.nextFloat() * (float)(height - 12);
                    float vx = 0.02f + this.particleRng.nextFloat() * 0.045f;
                    float amp = 0.6f + this.particleRng.nextFloat() * 1.2f;
                    float frequency = 0.01f + this.particleRng.nextFloat() * 0.01f;
                    float phase = this.particleRng.nextFloat() * 6.28318f;
                    float size = 1.0f + this.particleRng.nextFloat() * 1.2f;
                    float life = 420.0f + this.particleRng.nextFloat() * 360.0f;
                    boolean bl = white = this.particleRng.nextFloat() < 0.28f;
                    if (white) {
                        red = 235;
                        green = 245;
                        blue = 255;
                        vx *= 1.08f;
                    } else {
                        red = 74;
                        green = 158;
                        blue = 255;
                    }
                    this.hoverParticles.add(new HoverParticle(spawnX, spawnY, vx, spawnY, amp, frequency, phase, size, red, green, blue, life));
                }
            }

            private void renderHoverParticles(class_332 graphics, float hoverProgress) {
                if (this.hoverParticles.isEmpty()) {
                    return;
                }
                float intensity = Math.min(1.0f, 0.65f + hoverProgress * 0.55f);
                for (HoverParticle particle : this.hoverParticles) {
                    int alpha;
                    float time = particle.ageMs / particle.lifeMs;
                    float fade = 1.0f - time;
                    if ((alpha = (int)((fade *= fade) * 190.0f * intensity)) <= 2) continue;
                    int color = alpha << 24 | particle.red << 16 | particle.green << 8 | particle.blue;
                    int x0 = (int)particle.x;
                    int y0 = (int)particle.y;
                    int size = Math.max(1, (int)particle.size);
                    graphics.method_25294(x0, y0, x0 + size, y0 + size, color);
                    int trailA = alpha / 3;
                    if (trailA <= 0) continue;
                    int trail = trailA << 24 | particle.red << 16 | particle.green << 8 | particle.blue;
                    graphics.method_25294(x0 - 1, y0, x0, y0 + size, trail);
                }
            }

            private void drawCheckerboard(class_332 graphics, int x, int y, int width, int height) {
                int checkerSize = 4;
                for (int cy = 0; cy < height; cy += checkerSize) {
                    for (int cx = 0; cx < width; cx += checkerSize) {
                        boolean isLight = (cx / checkerSize + cy / checkerSize) % 2 == 0;
                        int color = isLight ? -3355444 : -6710887;
                        int drawWidth = Math.min(checkerSize, width - cx);
                        int drawHeight = Math.min(checkerSize, height - cy);
                        graphics.method_25294(x + cx, y + cy, x + cx + drawWidth, y + cy + drawHeight, color);
                    }
                }
            }

            private static class HoverParticle {
                float x;
                float y;
                float vx;
                float baseY;
                float amp;
                float freq;
                float phase;
                float size;
                int red;
                int green;
                int blue;
                float lifeMs;
                float ageMs;

                HoverParticle(float x, float y, float vx, float baseY, float amp, float freq, float phase, float size, int red, int green, int blue, float lifeMs) {
                    this.x = x;
                    this.y = y;
                    this.vx = vx;
                    this.baseY = baseY;
                    this.amp = amp;
                    this.freq = freq;
                    this.phase = phase;
                    this.size = size;
                    this.red = red;
                    this.green = green;
                    this.blue = blue;
                    this.lifeMs = lifeMs;
                    this.ageMs = 0.0f;
                }
            }
        }

        private record ScrollbarGeom(int trackX0, int trackX1, int trackTop, int trackBottom, int thumbTop, int thumbBottom, int thumbHeight, double maxScroll) {
        }

        static class ModernButton
        extends class_4185 {
            private float animationProgress = 0.0f;

            public ModernButton(int x, int y, int w, int h, class_2561 msg, class_4185.class_4241 onPress) {
                super(x, y, w, h, msg, onPress, class_4185.field_40754);
            }

            public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
                int x0 = this.method_46426();
                int y0 = this.method_46427();
                int x1 = x0 + this.method_25368();
                int y1 = y0 + this.method_25364();
                boolean hovered = mouseX >= x0 && mouseX < x1 && mouseY >= y0 && mouseY < y1;
                boolean active = hovered || this.method_25370();
                float step = 0.16f;
                this.animationProgress = active ? Math.min(1.0f, this.animationProgress + step) : Math.max(0.0f, this.animationProgress - step);
                int backgroundOuter = -15461356;
                int backgroundInner = hovered ? -14803426 : -15132391;
                graphics.method_25294(x0, y0, x1, y1, backgroundOuter);
                graphics.method_25294(x0 + 1, y0 + 1, x1 - 1, y1 - 1, backgroundInner);
                int baseBorder = 2;
                int extraBorder = Math.round(this.animationProgress * 2.0f);
                int borderW = baseBorder + extraBorder;
                int idleBorder = 0x40FFFFFF;
                int hoverBorder = -11886849;
                int borderColor = this.animationProgress > 0.0f ? hoverBorder : idleBorder;
                graphics.method_25294(x0, y0, x0 + borderW, y1, borderColor);
                if (this.animationProgress > 0.0f) {
                    int gradientW = Math.min(90, this.method_25368() / 3);
                    int maxA = (int)(64.0f * this.animationProgress);
                    for (int x = 0; x < gradientW; ++x) {
                        float time = (float)x / (float)gradientW;
                        int alpha = (int)((float)maxA * (1.0f - time));
                        if (alpha <= 0) continue;
                        int color = alpha << 24 | 0x4A9EFF;
                        graphics.method_25294(x0 + x, y0, x0 + x + 1, y1, color);
                    }
                }
                int outline = hovered ? -13750738 : -14408668;
                graphics.method_25294(x0, y0, x1, y0 + 1, outline);
                graphics.method_25294(x0, y1 - 1, x1, y1, outline);
                graphics.method_25294(x0, y0, x0 + 1, y1, outline);
                graphics.method_25294(x1 - 1, y0, x1, y1, outline);
                int txt = this.field_22763 ? -1513240 : -8947849;
                int ty = y0 + (this.field_22759 - 8) / 2;
                graphics.method_27534(class_310.method_1551().field_1772, this.method_25369(), x0 + this.field_22758 / 2, ty, txt);
            }
        }

        private static class ModernEditBox
        extends class_342 {
            private float animationProgress = 0.0f;

            public ModernEditBox(class_327 font, int x, int y, int w, int h, class_2561 msg) {
                super(font, x, y, w, h, msg);
                this.method_1858(false);
                this.method_1868(-1513240);
                this.method_1860(-8947849);
                this.method_1880(512);
            }

            public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
                int x0 = this.method_46426();
                int y0 = this.method_46427();
                int x1 = x0 + this.method_25368();
                int y1 = y0 + this.method_25364();
                boolean hovered = mouseX >= x0 && mouseX < x1 && mouseY >= y0 && mouseY < y1;
                boolean active = hovered || this.method_25370();
                float step = 0.16f;
                this.animationProgress = active ? Math.min(1.0f, this.animationProgress + step) : Math.max(0.0f, this.animationProgress - step);
                graphics.method_25294(x0, y0, x1, y1, -15329770);
                graphics.method_25294(x0 + 1, y0 + 1, x1 - 1, y1 - 1, -14803426);
                int borderIdle = -12961222;
                int borderFocus = -11886849;
                int border = this.animationProgress > 0.0f ? borderFocus : borderIdle;
                graphics.method_25294(x0, y0, x1, y0 + 1, border);
                graphics.method_25294(x0, y1 - 1, x1, y1, border);
                graphics.method_25294(x0, y0, x0 + 1, y1, border);
                graphics.method_25294(x1 - 1, y0, x1, y1, border);
                Objects.requireNonNull(class_310.method_1551().field_1772);
                int lh = 9;
                int offY = Math.max(0, (this.field_22759 - lh) / 2);
                int padX = 6;
                graphics.method_51448().method_22903();
                graphics.method_51448().method_46416((float)padX, (float)(offY + 1), 0.0f);
                super.method_48579(graphics, mouseX - padX, mouseY - offY, partialTick);
                graphics.method_51448().method_22909();
            }
        }

        private static class ModernCheckbox
        extends class_4286 {
            public ModernCheckbox(int x, int y, int w, int h, class_2561 msg, boolean selected) {
                super(x, y, w, msg, class_310.method_1551().field_1772, selected, (cb, val) -> {});
            }

            public void method_48579(class_332 g, int mouseX, int mouseY, float partialTick) {
                boolean hovered = this.method_25367();
                int size = Math.min(this.method_25368(), this.method_25364());
                int x0 = this.method_46426();
                int y0 = this.method_46427();
                int x1 = x0 + this.method_25368();
                int y1 = y0 + this.method_25364();
                int backgroundColor = -15198184;
                g.method_25294(x0, y0, x1, y1, backgroundColor);
                int border = hovered ? -11886849 : -12961222;
                g.method_25294(x0, y0, x1, y0 + 1, border);
                g.method_25294(x0, y1 - 1, x1, y1, border);
                g.method_25294(x0, y0, x0 + 1, y1, border);
                g.method_25294(x1 - 1, y0, x1, y1, border);
                if (this.method_20372()) {
                    int inset = Math.max(3, size / 5);
                    int inner = -11886849;
                    g.method_25294(x0 + inset, y0 + inset, x1 - inset, y1 - inset, inner);
                }
            }
        }
    }

    private static class CenteredEditBox
    extends class_342 {
        public CenteredEditBox(class_327 font, int x, int y, int width, int height, class_2561 text) {
            super(font, x, y, width, height, text);
        }

        public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
            Objects.requireNonNull(class_310.method_1551().field_1772);
            int leftHeight = 9;
            int offset = Math.max(0, (this.field_22759 - leftHeight) / 2);
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416(8.0f, (float)(offset + 1), 0.0f);
            super.method_48579(graphics, mouseX, mouseY - offset, partialTick);
            graphics.method_51448().method_22909();
        }
    }
}

