/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.effect;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.xylonity.tooltipoverhaul.client.layer.impl.EffectLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.AnimationUtils;
import dev.xylonity.tooltipoverhaul.client.util.ColorUtils;
import net.minecraft.class_241;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public class EchoEffect
implements EffectLayer {
    private static final int PULSE_COLOR_INNER = -2001476097;
    private static final int PULSE_COLOR_OUTER = 577025535;
    private static final int CORE_GLOW_COLOR = 809541887;
    private static final int CORE_CENTER_COLOR = 0x60FFFFFF;
    private static final int SEGMENTS = 96;
    private static final int PULSE_COUNT = 3;

    @Override
    public void render(TooltipContext context, class_241 position) {
        int positionX = (int)position.field_1343;
        int positionY = (int)position.field_1342;
        int tooltipWidth = (int)context.getTooltipSize().field_1343;
        int tooltipHeight = (int)context.getTooltipSize().field_1342;
        long now = System.currentTimeMillis();
        float time = (float)(now - context.getStartTime()) / 5000.0f;
        float centerX = (float)positionX + (float)tooltipWidth * 0.5f;
        float centerY = (float)positionY + (float)tooltipHeight * 0.5f;
        float maxRadius = (float)Math.hypot(tooltipWidth, tooltipHeight) * 0.95f;
        context.push(() -> {
            context.getGraphics().method_44379(positionX - context.getPaddingX() - 1, positionY - context.getPaddingY(), positionX + tooltipWidth + context.getPaddingX(), positionY + tooltipHeight + context.getPaddingY());
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableCull();
            RenderSystem.setShader(class_757::method_34540);
            Matrix4f pose = context.getPose().method_23760().method_23761();
            class_289 tess = class_289.method_1348();
            this.renderCore(tess, pose, centerX, centerY, maxRadius, time);
            this.renderPulses(tess, pose, centerX, centerY, maxRadius, time);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            context.getGraphics().method_44380();
        });
    }

    private void renderCore(class_289 tesselator, Matrix4f pose, float centerX, float centerY, float maxRadius, float time) {
        float radius = maxRadius * (0.28f + 0.05f * (float)Math.sin((double)time * Math.PI * 2.0));
        int segments = 64;
        class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27381, class_290.field_1576);
        int centerA = AnimationUtils.clamp255((int)((float)ColorUtils.alpha(0x60FFFFFF) * 0.95f));
        bufferBuilder.method_22918(pose, centerX, centerY, 0.0f).method_1336(ColorUtils.red(0x60FFFFFF), ColorUtils.green(0x60FFFFFF), ColorUtils.blue(0x60FFFFFF), centerA);
        for (int i = 0; i <= segments; ++i) {
            float ang = (float)i / (float)segments * (float)Math.PI * 2.0f;
            float wobble = 0.12f * (float)Math.sin((double)(ang * 3.0f) + (double)time * Math.PI * 3.0);
            float r = radius * (1.0f + wobble);
            float x = centerX + (float)Math.cos(ang) * r;
            float y = centerY + (float)Math.sin(ang) * r;
            int edgeA = AnimationUtils.clamp255((int)((float)ColorUtils.alpha(809541887) * 0.0f));
            bufferBuilder.method_22918(pose, x, y, 0.0f).method_1336(ColorUtils.red(809541887), ColorUtils.green(809541887), ColorUtils.blue(809541887), edgeA);
        }
        try (class_9801 data = bufferBuilder.method_60800();){
            class_286.method_43433((class_9801)data);
        }
    }

    private void renderPulses(class_289 tesselator, Matrix4f pose, float centerX, float centerY, float maxRadius, float time) {
        for (int i = 0; i < 3; ++i) {
            float offset = (float)i / 3.0f;
            float localT = (time + offset) % 1.0f;
            float envelope = (float)Math.sin((double)localT * Math.PI);
            if (envelope <= 0.001f) continue;
            float radiusInner = maxRadius * (0.18f + 0.62f * localT);
            float radiusOuter = radiusInner + maxRadius * 0.18f * (0.7f + 0.3f * localT);
            float alphaFactor = (float)Math.pow(envelope, 1.2f);
            int innerA = AnimationUtils.clamp255((int)((float)ColorUtils.alpha(-2001476097) * alphaFactor * 0.95f));
            int outerA = AnimationUtils.clamp255((int)((float)ColorUtils.alpha(577025535) * alphaFactor * 0.55f));
            class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27380, class_290.field_1576);
            for (int seg = 0; seg <= 96; ++seg) {
                float s = (float)seg / 96.0f;
                float angle = s * ((float)Math.PI * 2);
                float cos = (float)Math.cos(angle);
                float sin = (float)Math.sin(angle);
                float wave1 = 0.06f * (float)Math.sin((double)(angle * 3.0f) + (double)time * Math.PI * 4.0 + (double)i);
                float wave2 = 0.04f * (float)Math.sin((double)(angle * 7.0f) - (double)time * Math.PI * 3.0 + (double)((float)i * 1.7f));
                float wave = (wave1 + wave2) * envelope;
                float rIn = radiusInner * (1.0f + wave * 0.5f);
                float rOut = radiusOuter * (1.0f + wave);
                float ix = centerX + cos * rIn;
                float iy = centerY + sin * rIn;
                float ox = centerX + cos * rOut;
                float oy = centerY + sin * rOut;
                float cardinal = (float)(Math.pow(Math.abs(cos), 3.0) + Math.pow(Math.abs(sin), 3.0)) * 0.5f;
                float glow = 0.55f + 0.45f * cardinal * (0.7f + 0.3f * envelope);
                int ringInnerA = AnimationUtils.clamp255((int)((float)innerA * glow));
                int ringOuterA = AnimationUtils.clamp255((int)((float)outerA * glow));
                bufferBuilder.method_22918(pose, ox, oy, 0.0f).method_1336(ColorUtils.red(577025535), ColorUtils.green(577025535), ColorUtils.blue(577025535), ringOuterA);
                bufferBuilder.method_22918(pose, ix, iy, 0.0f).method_1336(ColorUtils.red(-2001476097), ColorUtils.green(-2001476097), ColorUtils.blue(-2001476097), ringInnerA);
            }
            try (class_9801 data = bufferBuilder.method_60800();){
                class_286.method_43433((class_9801)data);
                continue;
            }
        }
    }
}

