/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.effect;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.xylonity.tooltipoverhaul.client.layer.impl.EffectLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.AnimationUtils;
import dev.xylonity.tooltipoverhaul.client.util.ColorUtils;
import java.util.Random;
import net.minecraft.class_241;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public class GalaxyEffect
implements EffectLayer {
    private static final int CORE_COLOR = -15070674;
    private static final int NEBULA_INNER = -582344576;
    private static final int NEBULA_OUTER = -2011557824;
    private static final int SPIRAL_COLOR = -1150664544;
    private static final int STAR_COLOR = -35;
    private static final int DUST_COLOR = -1433771840;
    private static final int SEGMENTS = 64;
    private static final int STAR_COUNT = 80;
    private static final int DUST_COUNT = 120;
    private static final float[][] STARS;
    private static final float[][] DUST_PARTICLES;

    @Override
    public void render(TooltipContext context, class_241 position) {
        int positionX = (int)position.field_1343;
        int positionY = (int)position.field_1342;
        int tooltipWidth = (int)context.getTooltipSize().field_1343;
        int tooltipHeight = (int)context.getTooltipSize().field_1342;
        long now = System.currentTimeMillis();
        float time = (float)(now - context.getStartTime()) / 12000.0f;
        float centerX = (float)positionX + (float)tooltipWidth * 0.5f;
        float centerY = (float)positionY + (float)tooltipHeight * 0.5f;
        float maxRadius = (float)Math.hypot(tooltipWidth, tooltipHeight) * 0.6f;
        context.push(() -> {
            context.getGraphics().method_44379(positionX - context.getPaddingX() - 1, positionY - context.getPaddingY(), positionX + tooltipWidth + context.getPaddingX(), positionY + tooltipHeight + context.getPaddingY());
            context.translate(0.0f, 0.0f, context.getLayerDepth().getZ());
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableCull();
            RenderSystem.setShader(class_757::method_34540);
            Matrix4f pose = context.getPose().method_23760().method_23761();
            class_289 tesselator = class_289.method_1348();
            this.renderNebula(tesselator, pose, centerX, centerY, maxRadius, time);
            this.renderParticles(tesselator, pose, centerX, centerY, maxRadius, time);
            this.renderSpirals(tesselator, pose, centerX, centerY, maxRadius, time);
            this.renderStars(tesselator, pose, centerX, centerY, maxRadius, time);
            this.renderCore2(tesselator, pose, centerX, centerY, maxRadius, time);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            context.getGraphics().method_44380();
        });
    }

    private void renderNebula(class_289 tesselator, Matrix4f pose, float centerX, float centerY, float maxRadius, float time) {
        float pulse = 0.95f + 0.05f * (float)Math.sin((double)time * Math.PI * 2.0);
        float[] radii = new float[]{maxRadius * 0.85f * pulse, maxRadius * 0.55f * pulse, maxRadius * 0.25f * pulse};
        int[] colors = new int[]{-2011557824, -582344576, -15070674};
        for (int layer = 0; layer < 3; ++layer) {
            class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27381, class_290.field_1576);
            float radius = radii[layer];
            int color = colors[layer];
            int alpha = layer == 0 ? 120 : (layer == 1 ? 180 : 220);
            bufferBuilder.method_22918(pose, centerX, centerY, 0.0f).method_1336(ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), alpha);
            for (int i = 0; i <= 64; ++i) {
                float s = (float)i / 64.0f;
                float angle = s * (float)Math.PI * 2.0f;
                float noise = 0.15f * (float)Math.sin((double)(angle * 3.0f) + (double)time * Math.PI * 1.5) * (float)Math.cos((double)(angle * 5.0f) - (double)time * Math.PI * 2.0);
                float localRadius = radius * (1.0f + noise);
                float x = centerX + (float)Math.cos(angle) * localRadius;
                float y = centerY + (float)Math.sin(angle) * localRadius;
                bufferBuilder.method_22918(pose, x, y, 0.0f).method_1336(ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), layer == 0 ? 20 : (layer == 1 ? 40 : 80));
            }
            try (class_9801 data = bufferBuilder.method_60800();){
                class_286.method_43433((class_9801)data);
                continue;
            }
        }
    }

    private void renderParticles(class_289 tesselator, Matrix4f pose, float centerX, float centerY, float maxRadius, float time) {
        class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        for (float[] dust : DUST_PARTICLES) {
            float baseAngle = dust[0];
            float distance = dust[1];
            float size = dust[2];
            float speed = dust[3];
            float angle = baseAngle + time * speed * (float)Math.PI * 2.0f;
            float radius = maxRadius * distance * (0.8f + 0.2f * (float)Math.sin((double)time * Math.PI * 4.0 + (double)baseAngle));
            float px = centerX + (float)Math.cos(angle) * radius;
            float py = centerY + (float)Math.sin(angle) * radius;
            float twinkle = 0.4f + 0.6f * (float)Math.pow(Math.sin((double)(time * 3.0f + baseAngle) * Math.PI) * 0.5 + 0.5, 2.0);
            float particleSize = size * twinkle;
            int alpha = AnimationUtils.clamp255((int)((float)ColorUtils.alpha(-1433771840) * twinkle * (1.0f - distance * 0.3f)));
            bufferBuilder.method_22918(pose, px - particleSize, py - particleSize, 0.0f).method_1336(ColorUtils.red(-1433771840), ColorUtils.green(-1433771840), ColorUtils.blue(-1433771840), alpha);
            bufferBuilder.method_22918(pose, px - particleSize, py + particleSize, 0.0f).method_1336(ColorUtils.red(-1433771840), ColorUtils.green(-1433771840), ColorUtils.blue(-1433771840), alpha);
            bufferBuilder.method_22918(pose, px + particleSize, py + particleSize, 0.0f).method_1336(ColorUtils.red(-1433771840), ColorUtils.green(-1433771840), ColorUtils.blue(-1433771840), alpha);
            bufferBuilder.method_22918(pose, px + particleSize, py - particleSize, 0.0f).method_1336(ColorUtils.red(-1433771840), ColorUtils.green(-1433771840), ColorUtils.blue(-1433771840), alpha);
        }
        try (class_9801 data = bufferBuilder.method_60800();){
            class_286.method_43433((class_9801)data);
        }
    }

    private void renderSpirals(class_289 tesselator, Matrix4f pose, float centerX, float centerY, float maxRadius, float time) {
        int armCount = 3;
        for (int arm = 0; arm < armCount; ++arm) {
            float armOffset = (float)((double)arm * 2.0 * Math.PI / (double)armCount);
            class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27380, class_290.field_1576);
            int segments = 40;
            for (int i = 0; i <= segments; ++i) {
                float s = (float)i / (float)segments;
                float radius = maxRadius * (0.2f + s * 0.7f);
                float angle = armOffset + s * (float)Math.PI * 3.0f - time * (float)Math.PI * 0.5f;
                float wave = 0.08f * (float)Math.sin((double)s * Math.PI * 5.0 + (double)time * Math.PI * 3.0);
                float x = centerX + (float)Math.cos(angle += wave) * radius;
                float y = centerY + (float)Math.sin(angle) * radius;
                float thickness = maxRadius * 0.05f * (1.0f - s * 0.6f) * (0.7f + 0.3f * (float)Math.sin((double)s * Math.PI * 3.0 + (double)time * Math.PI * 4.0));
                float perpendicular = angle + 1.5707964f;
                float x1 = x + (float)Math.cos(perpendicular) * thickness;
                float y1 = y + (float)Math.sin(perpendicular) * thickness;
                float x2 = x - (float)Math.cos(perpendicular) * thickness;
                float y2 = y - (float)Math.sin(perpendicular) * thickness;
                float fadeOut = (float)Math.pow(1.0f - s, 1.2f);
                float brightness = 0.5f + 0.5f * (float)Math.sin((double)s * Math.PI * 4.0 + (double)time * Math.PI * 5.0);
                int alpha = AnimationUtils.clamp255((int)((float)ColorUtils.alpha(-1150664544) * fadeOut * brightness));
                bufferBuilder.method_22918(pose, x1, y1, 0.0f).method_1336(ColorUtils.red(-1150664544), ColorUtils.green(-1150664544), ColorUtils.blue(-1150664544), alpha);
                bufferBuilder.method_22918(pose, x2, y2, 0.0f).method_1336(ColorUtils.red(-1150664544), ColorUtils.green(-1150664544), ColorUtils.blue(-1150664544), alpha);
            }
            try (class_9801 data = bufferBuilder.method_60800();){
                class_286.method_43433((class_9801)data);
                continue;
            }
        }
    }

    private void renderStars(class_289 tesselator, Matrix4f pose, float centerX, float centerY, float maxRadius, float time) {
        class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        for (float[] star : STARS) {
            float baseAngle = star[0];
            float distance = star[1];
            float size = star[2];
            float speed = star[3];
            float angle = baseAngle + time * speed * (float)Math.PI * 2.0f;
            float radius = maxRadius * distance;
            float px = centerX + (float)Math.cos(angle) * radius;
            float py = centerY + (float)Math.sin(angle) * radius;
            float twinkle = 0.6f + 0.4f * (float)Math.sin((double)(time * 8.0f + baseAngle * 10.0f) * Math.PI);
            float starSize = size * twinkle;
            int alpha = AnimationUtils.clamp255((int)(255.0f * twinkle * (1.0f - distance * 0.2f)));
            bufferBuilder.method_22918(pose, px - starSize, py - starSize * 0.3f, 0.0f).method_1336(ColorUtils.red(-35), ColorUtils.green(-35), ColorUtils.blue(-35), alpha);
            bufferBuilder.method_22918(pose, px - starSize, py + starSize * 0.3f, 0.0f).method_1336(ColorUtils.red(-35), ColorUtils.green(-35), ColorUtils.blue(-35), alpha);
            bufferBuilder.method_22918(pose, px + starSize, py + starSize * 0.3f, 0.0f).method_1336(ColorUtils.red(-35), ColorUtils.green(-35), ColorUtils.blue(-35), alpha);
            bufferBuilder.method_22918(pose, px + starSize, py - starSize * 0.3f, 0.0f).method_1336(ColorUtils.red(-35), ColorUtils.green(-35), ColorUtils.blue(-35), alpha);
            bufferBuilder.method_22918(pose, px - starSize * 0.3f, py - starSize, 0.0f).method_1336(ColorUtils.red(-35), ColorUtils.green(-35), ColorUtils.blue(-35), alpha);
            bufferBuilder.method_22918(pose, px - starSize * 0.3f, py + starSize, 0.0f).method_1336(ColorUtils.red(-35), ColorUtils.green(-35), ColorUtils.blue(-35), alpha);
            bufferBuilder.method_22918(pose, px + starSize * 0.3f, py + starSize, 0.0f).method_1336(ColorUtils.red(-35), ColorUtils.green(-35), ColorUtils.blue(-35), alpha);
            bufferBuilder.method_22918(pose, px + starSize * 0.3f, py - starSize, 0.0f).method_1336(ColorUtils.red(-35), ColorUtils.green(-35), ColorUtils.blue(-35), alpha);
        }
        try (class_9801 data = bufferBuilder.method_60800();){
            class_286.method_43433((class_9801)data);
        }
    }

    private void renderCore2(class_289 tesselator, Matrix4f pose, float centerX, float centerY, float maxRadius, float time) {
        float pulse = 0.92f + 0.08f * (float)Math.sin((double)time * Math.PI * 3.0);
        float coreRadius = maxRadius * 0.12f * pulse;
        class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27381, class_290.field_1576);
        bufferBuilder.method_22918(pose, centerX, centerY, 0.0f).method_1336(ColorUtils.red(-15070674), ColorUtils.green(-15070674), ColorUtils.blue(-15070674), 255);
        for (int i = 0; i <= 64; ++i) {
            float angle = (float)i / 64.0f * (float)Math.PI * 2.0f;
            float distortion = 0.1f * (float)Math.sin((double)(angle * 4.0f) + (double)time * Math.PI * 6.0);
            float localRadius = coreRadius * (1.0f + distortion);
            float x = centerX + (float)Math.cos(angle) * localRadius;
            float y = centerY + (float)Math.sin(angle) * localRadius;
            bufferBuilder.method_22918(pose, x, y, 0.0f).method_1336(ColorUtils.red(-15070674), ColorUtils.green(-15070674), ColorUtils.blue(-15070674), 200);
        }
        try (class_9801 data = bufferBuilder.method_60800();){
            class_286.method_43433((class_9801)data);
        }
    }

    static {
        float distance;
        float angle;
        int i;
        STARS = new float[80][4];
        DUST_PARTICLES = new float[120][4];
        Random random = new Random(31415L);
        for (i = 0; i < 80; ++i) {
            angle = random.nextFloat() * (float)Math.PI * 2.0f;
            distance = (float)Math.pow(random.nextFloat(), 0.6f);
            GalaxyEffect.STARS[i][0] = angle;
            GalaxyEffect.STARS[i][1] = distance;
            GalaxyEffect.STARS[i][2] = 0.5f + random.nextFloat() * 1.5f;
            GalaxyEffect.STARS[i][3] = 0.3f + random.nextFloat() * 0.7f;
        }
        for (i = 0; i < 120; ++i) {
            angle = random.nextFloat() * (float)Math.PI * 2.0f;
            distance = random.nextFloat();
            GalaxyEffect.DUST_PARTICLES[i][0] = angle;
            GalaxyEffect.DUST_PARTICLES[i][1] = distance;
            GalaxyEffect.DUST_PARTICLES[i][2] = 0.5f + random.nextFloat();
            GalaxyEffect.DUST_PARTICLES[i][3] = 0.4f + random.nextFloat() * 0.8f;
        }
    }
}

