/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.effect;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.xylonity.tooltipoverhaul.client.layer.impl.EffectLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.AnimationUtils;
import dev.xylonity.tooltipoverhaul.client.util.ColorUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_241;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public class MagicOrbsEffect
implements EffectLayer {
    private static final int ORB_COUNT = 5;
    private static final int SEGMENTS = 48;
    private static final int ORB_CORE_COLOR = -3342337;
    private static final int ORB_GLOW_COLOR = -1433870849;
    private static final int TRAIL_COLOR = 0x6666CCFF;
    private static final int BEAM_COLOR = -2003177729;
    private static final Random RAND = new Random();
    private static final List<OrbData> ORBS = new ArrayList<OrbData>();

    @Override
    public void render(TooltipContext context, class_241 position) {
        int positionX = (int)position.field_1343;
        int positionY = (int)position.field_1342;
        int tooltipWidth = (int)context.getTooltipSize().field_1343;
        int tooltipHeigth = (int)context.getTooltipSize().field_1342;
        long now = System.currentTimeMillis();
        float time = (float)(now - context.getStartTime()) / 10000.0f;
        float centerX = (float)positionX + (float)tooltipWidth * 0.5f;
        float centerY = (float)positionY + (float)tooltipHeigth * 0.5f;
        float maxRadius = (float)Math.hypot(tooltipWidth, tooltipHeigth) * 0.5f;
        context.push(() -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableCull();
            RenderSystem.setShader(class_757::method_34540);
            Matrix4f pose = context.getPose().method_23760().method_23761();
            class_289 tess = class_289.method_1348();
            this.renderBeams(tess, pose, centerX, centerY, maxRadius, time);
            this.renderTrails(tess, pose, centerX, centerY, maxRadius, time);
            this.renderOrbs(tess, pose, centerX, centerY, maxRadius, time);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
        });
    }

    private void renderBeams(class_289 tesselator, Matrix4f pose, float centerX, float centerY, float maxRadius, float time) {
        for (int i = 0; i < 5; ++i) {
            OrbData orb1 = ORBS.get(i);
            float[] pos1 = orb1.getPosition(centerX, centerY, maxRadius, time);
            for (int j = i + 1; j < 5; ++j) {
                float maxBeamDist;
                OrbData orb2 = ORBS.get(j);
                float[] pos2 = orb2.getPosition(centerX, centerY, maxRadius, time);
                float dist = (float)Math.hypot(pos2[0] - pos1[0], pos2[1] - pos1[1]);
                if (!(dist < (maxBeamDist = maxRadius * 0.8f))) continue;
                float strength = 1.0f - dist / maxBeamDist;
                float pulse = 0.5f + 0.5f * (float)Math.sin((double)time * Math.PI * 4.0 + (double)i + (double)j);
                this.renderBeam(tesselator, pose, pos1[0], pos1[1], pos2[0], pos2[1], strength * pulse);
            }
        }
    }

    private void renderBeam(class_289 tesselator, Matrix4f pose, float x1, float y1, float x2, float y2, float strength) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        float len = (float)Math.hypot(dx, dy);
        if (len < 0.001f) {
            return;
        }
        float nx = -dy / len;
        float ny = dx / len;
        float thickness = 1.5f * strength;
        class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27380, class_290.field_1576);
        int segments = 12;
        for (int i = 0; i <= segments; ++i) {
            float s = (float)i / (float)segments;
            float wave = 0.15f * (float)Math.sin((double)s * Math.PI * 3.0);
            float localThickness = thickness * (0.5f + 0.5f * (float)Math.sin((double)s * Math.PI));
            float mx = AnimationUtils.lerp(x1, x2, s) + nx * wave;
            float my = AnimationUtils.lerp(y1, y2, s) + ny * wave;
            float alpha = strength * (float)Math.sin((double)s * Math.PI);
            int beamAlpha = AnimationUtils.clamp255((int)((float)ColorUtils.alpha(-2003177729) * alpha));
            bufferBuilder.method_22918(pose, mx + nx * localThickness, my + ny * localThickness, 0.0f).method_1336(ColorUtils.red(-2003177729), ColorUtils.green(-2003177729), ColorUtils.blue(-2003177729), beamAlpha);
            bufferBuilder.method_22918(pose, mx - nx * localThickness, my - ny * localThickness, 0.0f).method_1336(ColorUtils.red(-2003177729), ColorUtils.green(-2003177729), ColorUtils.blue(-2003177729), beamAlpha);
        }
        try (class_9801 data = bufferBuilder.method_60800();){
            class_286.method_43433((class_9801)data);
        }
    }

    private void renderTrails(class_289 tesselator, Matrix4f pose, float centerX, float centerY, float maxRadius, float time) {
        for (OrbData orb : ORBS) {
            class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27380, class_290.field_1576);
            int trailLength = 20;
            for (int i = 0; i <= trailLength; ++i) {
                float s = (float)i / (float)trailLength;
                float pastT = time - s * 0.15f;
                float[] pos = orb.getPosition(centerX, centerY, maxRadius, pastT);
                float fade = (float)Math.pow(1.0f - s, 2.0);
                float thickness = 0.1f * fade;
                int trailAlpha = AnimationUtils.clamp255((int)((float)ColorUtils.alpha(0x6666CCFF) * fade));
                float angle = orb.getAngle(pastT);
                float perpAngle = angle + 1.5707964f;
                float x1 = pos[0] + (float)Math.cos(perpAngle) * thickness;
                float y1 = pos[1] + (float)Math.sin(perpAngle) * thickness;
                float x2 = pos[0] - (float)Math.cos(perpAngle) * thickness;
                float y2 = pos[1] - (float)Math.sin(perpAngle) * thickness;
                bufferBuilder.method_22918(pose, x1, y1, 0.0f).method_1336(ColorUtils.red(0x6666CCFF), ColorUtils.green(0x6666CCFF), ColorUtils.blue(0x6666CCFF), trailAlpha);
                bufferBuilder.method_22918(pose, x2, y2, 0.0f).method_1336(ColorUtils.red(0x6666CCFF), ColorUtils.green(0x6666CCFF), ColorUtils.blue(0x6666CCFF), trailAlpha);
            }
            class_9801 data = bufferBuilder.method_60800();
            try {
                class_286.method_43433((class_9801)data);
            }
            finally {
                if (data == null) continue;
                data.close();
            }
        }
    }

    private void renderOrbs(class_289 tesselator, Matrix4f pose, float centerX, float centerY, float maxRadius, float time) {
        for (OrbData orb : ORBS) {
            float[] pos = orb.getPosition(centerX, centerY, maxRadius, time);
            float orbPulse = 0.85f + 0.15f * (float)Math.sin((double)time * Math.PI * 6.0 + (double)(orb.phase * 10.0f));
            this.drawCircle2(tesselator, pose, pos[0], pos[1], 12.0f * orbPulse, -1433870849, 0.4f);
            this.drawCircle(tesselator, pose, pos[0], pos[1], 6.0f * orbPulse, -3342337, 0.9f);
        }
    }

    private void drawCircle(class_289 tesselator, Matrix4f pose, float centerX, float centerY, float radius, int color, float alphaMult) {
        class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27381, class_290.field_1576);
        int alpha = AnimationUtils.clamp255((int)((float)ColorUtils.alpha(color) * alphaMult));
        bufferBuilder.method_22918(pose, centerX, centerY, 0.0f).method_1336(ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), alpha);
        for (int i = 0; i <= 48; ++i) {
            float angle = (float)i / 48.0f * (float)Math.PI * 2.0f;
            float x = centerX + (float)Math.cos(angle) * radius;
            float y = centerY + (float)Math.sin(angle) * radius;
            int edgeAlpha = AnimationUtils.clamp255((int)((float)alpha * 0.3f));
            bufferBuilder.method_22918(pose, x, y, 0.0f).method_1336(ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), edgeAlpha);
        }
        try (class_9801 data = bufferBuilder.method_60800();){
            class_286.method_43433((class_9801)data);
        }
    }

    private void drawCircle2(class_289 tesselator, Matrix4f pose, float centerX, float centerY, float radius, int color, float alphaMult) {
        class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27381, class_290.field_1576);
        int alpha = AnimationUtils.clamp255((int)((float)ColorUtils.alpha(color) * alphaMult));
        bufferBuilder.method_22918(pose, centerX, centerY, 0.0f).method_1336(ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), alpha);
        for (int i = 0; i <= 48; ++i) {
            float angle = (float)i / 48.0f * (float)Math.PI * 2.0f;
            float x = centerX + (float)Math.cos(angle) * radius;
            float y = centerY + (float)Math.sin(angle) * radius;
            bufferBuilder.method_22918(pose, x, y, 0.0f).method_1336(ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), 0);
        }
        try (class_9801 data = bufferBuilder.method_60800();){
            class_286.method_43433((class_9801)data);
        }
    }

    static {
        for (int i = 0; i < 5; ++i) {
            float phase = (float)i / 5.0f;
            float distance = 0.6f + RAND.nextFloat() * 0.3f;
            float speed = 0.8f + RAND.nextFloat() * 0.4f;
            ORBS.add(new OrbData(phase, distance, speed));
        }
    }

    private record OrbData(float phase, float distance, float speed) {
        float[] getPosition(float centerX, float centerY, float maxRadius, float t) {
            float angle = this.getAngle(t);
            float radius = maxRadius * this.distance;
            return new float[]{centerX + (float)Math.cos(angle) * radius, centerY + (float)Math.sin(angle) * radius};
        }

        float getAngle(float t) {
            return (t * this.speed + this.phase) * (float)Math.PI * 2.0f;
        }
    }
}

