/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.effect;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.xylonity.tooltipoverhaul.client.layer.impl.EffectLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.AnimationUtils;
import dev.xylonity.tooltipoverhaul.client.util.ColorUtils;
import net.minecraft.class_241;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public class TimeSpiralEffect
implements EffectLayer {
    private static final int HALO_COLOR_CORE = 900234495;
    private static final int HALO_COLOR_EDGE = -5735169;
    private static final int RING_COLOR = -1868006145;
    private static final int RING_GLOW_COLOR = 1084783871;
    private static final int SPIRAL_COLOR_NEAR = -1597444097;
    private static final int SPIRAL_COLOR_FAR = 815849727;
    private static final int ARM_COUNT = 4;
    private static final int SEGMENTS = 96;

    @Override
    public void render(TooltipContext context, class_241 position) {
        int positionX = (int)position.field_1343;
        int positionY = (int)position.field_1342;
        int tooltipWidth = (int)context.getTooltipSize().field_1343;
        int tooltipHeight = (int)context.getTooltipSize().field_1342;
        long now = System.currentTimeMillis();
        float time = (float)(now % context.getStartTime()) / 5000.0f;
        float globalAngle = time * ((float)Math.PI * 2);
        float centerX = (float)positionX + (float)tooltipWidth * 0.5f;
        float centerY = (float)positionY + (float)tooltipHeight * 0.5f;
        float maxRadius = (float)(Math.hypot(tooltipWidth, tooltipHeight) * 0.75);
        float baseThickness = Math.max(3.5f, maxRadius * 0.08f);
        context.push(() -> {
            context.getGraphics().method_44379(positionX - context.getPaddingX() - 1, positionY - context.getPaddingY(), positionX + tooltipWidth + context.getPaddingX(), positionY + tooltipHeight + context.getPaddingY());
            context.translate(0.0f, 0.0f, context.getLayerDepth().getZ());
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableCull();
            RenderSystem.setShader(class_757::method_34540);
            Matrix4f pose = context.getPose().method_23760().method_23761();
            class_289 tess = class_289.method_1348();
            this.renderRadialHalo(tess, pose, centerX, centerY, maxRadius, tooltipWidth, tooltipHeight, time);
            this.renderOrbitRings(tess, pose, centerX, centerY, maxRadius, time, globalAngle);
            this.renderSpiralArms(tess, pose, centerX, centerY, maxRadius, baseThickness, time, globalAngle);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            context.getGraphics().method_44380();
        });
    }

    private void renderRadialHalo(class_289 tesselator, Matrix4f pose, float centerX, float centerY, float maxRadius, int width, int height, float time) {
        float aspect = (float)height / (float)width;
        float pulse = 1.13f + 0.06f * (float)Math.sin((double)time * Math.PI * 2.0 * (double)1.6f);
        float outerRadius = maxRadius * 0.95f * pulse;
        float innerRadius = outerRadius * 0.65f;
        float centerRadius = innerRadius * 0.3f;
        int coreRed = ColorUtils.red(900234495);
        int coreGreen = ColorUtils.green(900234495);
        int coreBlue = ColorUtils.blue(900234495);
        int coreAlpha = ColorUtils.alpha(900234495);
        int edgeRed = ColorUtils.red(-5735169);
        int edgeGreen = ColorUtils.green(-5735169);
        int edgeBlue = ColorUtils.blue(-5735169);
        class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27380, class_290.field_1576);
        for (int i = 0; i <= 96; ++i) {
            float s = (float)i / 96.0f;
            float angle = s * ((float)Math.PI * 2);
            float cos = (float)Math.cos(angle);
            float sin = (float)Math.sin(angle);
            float sx = cos;
            float sy = sin * aspect;
            float ix = centerX + sx * innerRadius;
            float iy = centerY + sy * innerRadius;
            float ox = centerX + sx * outerRadius;
            float oy = centerY + sy * outerRadius;
            float ringT = 1.0f - (float)Math.abs(Math.sin(angle * 0.5f));
            float alphaFactorInner = 0.75f + 0.25f * ringT;
            int innerA = AnimationUtils.clamp255((int)((float)coreAlpha * alphaFactorInner));
            bufferBuilder.method_22918(pose, ox, oy, 0.0f).method_1336(edgeRed, edgeGreen, edgeBlue, 180);
            bufferBuilder.method_22918(pose, ix, iy, 0.0f).method_1336(coreRed, coreGreen, coreBlue, innerA);
        }
        try (class_9801 data = bufferBuilder.method_60800();){
            class_286.method_43433((class_9801)data);
        }
        class_287 bufferBuilder2 = tesselator.method_60827(class_293.class_5596.field_27380, class_290.field_1576);
        for (int i = 0; i <= 96; ++i) {
            float s = (float)i / 96.0f;
            float angle = s * ((float)Math.PI * 2);
            float cos = (float)Math.cos(angle);
            float sin = (float)Math.sin(angle);
            float sx = cos;
            float sy = sin * aspect;
            float cx_pos = centerX + sx * centerRadius;
            float cy_pos = centerY + sy * centerRadius;
            float ix = centerX + sx * innerRadius;
            float iy = centerY + sy * innerRadius;
            float ringT = 1.0f - (float)Math.abs(Math.sin(angle * 0.5f));
            float alphaFactorInner = 0.75f + 0.25f * ringT;
            int innerA = AnimationUtils.clamp255((int)((float)coreAlpha * alphaFactorInner));
            bufferBuilder2.method_22918(pose, ix, iy, 0.0f).method_1336(coreRed, coreGreen, coreBlue, innerA);
            bufferBuilder2.method_22918(pose, cx_pos, cy_pos, 0.0f).method_1336(coreRed, coreGreen, coreBlue, 0);
        }
        try (class_9801 data = bufferBuilder2.method_60800();){
            class_286.method_43433((class_9801)data);
        }
    }

    private void renderOrbitRings(class_289 tesselator, Matrix4f pose, float centerX, float centerY, float maxRadius, float time, float globalAngle) {
        float baseRadius = maxRadius * 0.55f;
        int ringRed = ColorUtils.red(-1868006145);
        int ringGreen = ColorUtils.green(-1868006145);
        int ringBlue = ColorUtils.blue(-1868006145);
        int ringAlpha = ColorUtils.alpha(-1868006145);
        int glowRed = ColorUtils.red(1084783871);
        int glowGreen = ColorUtils.green(1084783871);
        int glowBlue = ColorUtils.blue(1084783871);
        int glowAlpha = ColorUtils.alpha(1084783871);
        for (int ringIndex = 0; ringIndex < 2; ++ringIndex) {
            float offset = ringIndex == 0 ? -1.0f : 1.0f;
            float radius = baseRadius * (1.0f + 0.12f * offset);
            float ringPhase = globalAngle * (ringIndex == 0 ? 1.1f : -0.9f);
            float thickness = maxRadius * 0.06f;
            class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27380, class_290.field_1576);
            for (int i = 0; i <= 96; ++i) {
                float s = (float)i / 96.0f;
                float angle = s * ((float)Math.PI * 2) + ringPhase;
                float cos = (float)Math.cos(angle);
                float sin = (float)Math.sin(angle);
                float pulse = 0.6f + 0.4f * (float)Math.sin((double)((s * 3.0f + time * 4.0f + (float)ringIndex * 1.7f) * (float)Math.PI) * 2.0);
                float localThickness = thickness * pulse;
                float innerRadius = radius - localThickness * 0.5f;
                float outerRadius = radius + localThickness * 0.5f;
                float ix = centerX + cos * innerRadius;
                float iy = centerY + sin * innerRadius;
                float ox = centerX + cos * outerRadius;
                float oy = centerY + sin * outerRadius;
                float glowMask = 0.5f + 0.5f * (float)Math.cos((double)((s + time) * (float)Math.PI) * 4.0);
                float alphaCore = 0.65f * glowMask;
                float alphaGlow = 0.3f * glowMask;
                int coreAlpha = AnimationUtils.clamp255((int)((float)ringAlpha * alphaCore));
                int haloAlpha = AnimationUtils.clamp255((int)((float)glowAlpha * alphaGlow));
                bufferBuilder.method_22918(pose, ox, oy, 0.0f).method_1336(glowRed, glowGreen, glowBlue, haloAlpha);
                bufferBuilder.method_22918(pose, ix, iy, 0.0f).method_1336(ringRed, ringGreen, ringBlue, coreAlpha);
            }
            try (class_9801 data = bufferBuilder.method_60800();){
                class_286.method_43433((class_9801)data);
                continue;
            }
        }
    }

    private void renderSpiralArms(class_289 tesselator, Matrix4f pose, float centerX, float centerY, float maxRadius, float baseThickness, float time, float globalAngle) {
        for (int arm = 0; arm < 4; ++arm) {
            float armOffset = 1.5707964f * (float)arm;
            float startAngle = globalAngle + armOffset;
            float endAngle = startAngle + 5.969026f;
            class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_27380, class_290.field_1576);
            for (int i = 0; i <= 96; ++i) {
                float eased;
                float s = (float)i / 96.0f;
                float spiralT = eased = AnimationUtils.smoothstep(0.0f, 1.0f, s);
                float radius = (float)Math.pow(spiralT, 0.9f) * maxRadius;
                float thicknessPulse = 0.65f + 0.35f * (float)Math.sin((double)(time + (float)arm * 0.33f + s * 1.4f) * Math.PI * 2.0);
                float thickness = baseThickness * thicknessPulse * (1.05f - spiralT * 0.75f);
                float wobble = 0.12f * (float)Math.sin((double)(s * 10.0f + (float)arm * 2.5f) + (double)time * Math.PI * 4.0);
                float angle = AnimationUtils.lerp(startAngle, endAngle, s) + wobble;
                float cos = (float)Math.cos(angle);
                float sin = (float)Math.sin(angle);
                float innerRadius = radius - thickness * 0.5f;
                float outerRadius = radius + thickness * 0.5f;
                float innerX = centerX + cos * innerRadius;
                float innerY = centerY + sin * innerRadius;
                float outerX = centerX + cos * outerRadius;
                float outerY = centerY + sin * outerRadius;
                int segmentColor = ColorUtils.lerpColor(-1597444097, 815849727, spiralT);
                int segR = ColorUtils.red(segmentColor);
                int segG = ColorUtils.green(segmentColor);
                int segB = ColorUtils.blue(segmentColor);
                int segA = ColorUtils.alpha(segmentColor);
                float headGlow = (float)Math.pow(1.0f - spiralT, 1.6f);
                float sparkle = 0.6f + 0.4f * (float)Math.sin((double)((time * 1.7f + s * 1.3f + (float)arm * 0.5f) * (float)Math.PI) * 2.0);
                float alphaFactor = AnimationUtils.clamp01(headGlow * (0.55f + 0.45f * sparkle));
                float edgeFade = AnimationUtils.clamp01((spiralT - 0.05f) / 0.9f);
                int innerAlpha = AnimationUtils.clamp255((int)((float)segA * (alphaFactor *= edgeFade)));
                int outerAlpha = AnimationUtils.clamp255((int)((float)segA * alphaFactor * 0.7f));
                bufferBuilder.method_22918(pose, outerX, outerY, 0.0f).method_1336(segR, segG, segB, outerAlpha);
                bufferBuilder.method_22918(pose, innerX, innerY, 0.0f).method_1336(segR, segG, segB, innerAlpha);
            }
            try (class_9801 data = bufferBuilder.method_60800();){
                class_286.method_43433((class_9801)data);
                continue;
            }
        }
    }
}

