/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.overlay;

import dev.xylonity.tooltipoverhaul.TooltipOverhaul;
import dev.xylonity.tooltipoverhaul.client.layer.impl.OverlayLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.Constants;
import dev.xylonity.tooltipoverhaul.client.util.RenderUtils;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1011;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;

public class DefaultOverlay
implements OverlayLayer {
    private static final int BLOCK_DIMENSION = 44;
    private static final Map<class_2960, TextureMetadata> TEXTURES = new ConcurrentHashMap<class_2960, TextureMetadata>();

    @Override
    public void render(TooltipContext context, class_241 position) {
        String rawTexturePath = RenderUtils.getOverlayLocation(context);
        if (rawTexturePath == null || rawTexturePath.isBlank() || rawTexturePath.isEmpty()) {
            return;
        }
        class_2960 textureLocation = TooltipOverhaul.rawPathOf(rawTexturePath);
        TextureMetadata textureMetadata = DefaultOverlay.getTextureMetadata(textureLocation);
        int textureWidth = textureMetadata.width();
        int textureHeight = textureMetadata.height();
        int frameAmount = textureMetadata.frames();
        int idx = frameAmount > 1 ? (int)(System.currentTimeMillis() / (long)Constants.getOverlayFrameTime() % (long)frameAmount) : 0;
        int frameOffset = idx * Constants.getOverlayFrameDimension();
        int x = (int)position.field_1343;
        int y = (int)position.field_1342;
        int width = (int)context.getTooltipSize().field_1343;
        int height = (int)context.getTooltipSize().field_1342;
        int baseOffset = -25;
        int leftX = x + baseOffset;
        int rightX = x + width - 20;
        int topY = y + baseOffset + 1;
        int bottomY = y + height - 20;
        int centerX = leftX + width / 2 + 2;
        int centerY = topY + height / 2 + 3;
        context.getGraphics().method_25290(textureLocation, leftX, topY, 0.0f, (float)frameOffset, 44, 44, textureWidth, textureHeight);
        context.getGraphics().method_25290(textureLocation, rightX, topY, 88.0f, (float)frameOffset, 44, 44, textureWidth, textureHeight);
        context.getGraphics().method_25290(textureLocation, leftX, bottomY, 0.0f, (float)(88 + frameOffset), 44, 44, textureWidth, textureHeight);
        context.getGraphics().method_25290(textureLocation, rightX, bottomY, 88.0f, (float)(88 + frameOffset), 44, 44, textureWidth, textureHeight);
        context.getGraphics().method_25290(textureLocation, leftX, centerY, 0.0f, (float)(44 + frameOffset), 44, 44, textureWidth, textureHeight);
        context.getGraphics().method_25290(textureLocation, rightX, centerY, 88.0f, (float)(44 + frameOffset), 44, 44, textureWidth, textureHeight);
        context.getGraphics().method_25290(textureLocation, centerX, topY, 44.0f, (float)frameOffset, 44, 44, textureWidth, textureHeight);
        context.getGraphics().method_25290(textureLocation, centerX, bottomY, 44.0f, (float)(88 + frameOffset), 44, 44, textureWidth, textureHeight);
    }

    private static TextureMetadata getTextureMetadata(class_2960 texture) {
        int frameDimension = Constants.getOverlayFrameDimension();
        return TEXTURES.computeIfAbsent(texture, tex -> {
            try {
                Optional resource = class_310.method_1551().method_1478().method_14486(tex);
                if (resource.isEmpty()) {
                    return new TextureMetadata(frameDimension, frameDimension, 1);
                }
                try (InputStream inputStream = ((class_3298)resource.get()).method_14482();){
                    TextureMetadata textureMetadata;
                    block17: {
                        class_1011 img = class_1011.method_4309((InputStream)inputStream);
                        try {
                            int width = img.method_4307();
                            int heigth = img.method_4323();
                            if (width < frameDimension) {
                                TooltipOverhaul.LOGGER.warn("Texture width {} is smaller than expected {} for {}", new Object[]{width, frameDimension, tex});
                            }
                            if (heigth % frameDimension != 0) {
                                TooltipOverhaul.LOGGER.warn("Texture height {} is not a multiple of {} for {} (animation may look off)", new Object[]{heigth, frameDimension, tex});
                            }
                            textureMetadata = new TextureMetadata(width, heigth, Math.max(1, heigth / frameDimension));
                            if (img == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (img != null) {
                                try {
                                    img.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        img.close();
                    }
                    return textureMetadata;
                }
            }
            catch (Exception exception) {
                TooltipOverhaul.LOGGER.error("Failed to read texture {}: {}", tex, (Object)exception.toString());
                return new TextureMetadata(frameDimension, frameDimension, 1);
            }
        });
    }

    private record TextureMetadata(int width, int height, int frames) {
    }
}

