/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.util;

import dev.xylonity.tooltipoverhaul.client.util.AnimationUtils;
import dev.xylonity.tooltipoverhaul.client.util.ColorUtils;
import dev.xylonity.tooltipoverhaul.client.util.Constants;
import java.awt.Color;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;

public final class ColorExtractor {
    private static final int SAMPLEX = 2;
    private static final int HUE_BINS = 36;
    private static final int MIN_ALPHA = 48;
    private static final int INNER_MARGIN = 14;
    private static final Map<class_2960, int[][]> GRADIENT_CACHE = new ConcurrentHashMap<class_2960, int[][]>();

    public static void reset() {
        GRADIENT_CACHE.clear();
    }

    public static int[] getOverlayGradient(class_2960 texture) {
        int[][] allColors = GRADIENT_CACHE.computeIfAbsent(texture, ColorExtractor::computeAllFrames);
        if (allColors.length == 0) {
            return new int[]{-1, -1, -1};
        }
        int idx = ColorExtractor.frameIndex(texture, allColors.length);
        return allColors[Math.max(0, Math.min(idx, allColors.length - 1))];
    }

    private static int frameIndex(class_2960 texture, int frames) {
        if (frames <= 1) {
            return 0;
        }
        long now = System.currentTimeMillis();
        return (int)(now / (long)Constants.getOverlayFrameTime() % (long)frames);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static int[][] computeAllFrames(class_2960 texture) {
        try {
            Optional resource = class_310.method_1551().method_1478().method_14486(texture);
            if (resource.isEmpty()) {
                return new int[0][];
            }
            try (InputStream inputStream = ((class_3298)resource.get()).method_14482();){
                int[][] nArray;
                block17: {
                    class_1011 img = class_1011.method_4309((InputStream)inputStream);
                    try {
                        int width = img.method_4307();
                        int height = img.method_4323();
                        int frames = Math.max(1, height / Constants.getOverlayFrameDimension());
                        if (frames <= 0) {
                            frames = 1;
                        }
                        int[][] out = new int[frames][3];
                        for (int i = 0; i < frames; ++i) {
                            int frameOffset = i * Constants.getOverlayFrameDimension();
                            out[i] = ColorExtractor.extractDominantGradient(img, width, height, frameOffset);
                        }
                        nArray = out;
                        if (img == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (img != null) {
                            try {
                                img.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    img.close();
                }
                return nArray;
            }
        }
        catch (Exception ignored) {
            return new int[0][];
        }
    }

    private static int[] extractDominantGradient(class_1011 image, int imageWidth, int imageHeight, int frameOffsetY) {
        int y1;
        int x0 = 14;
        int y0 = frameOffsetY + 14;
        int x1 = Math.min(Constants.getOverlayFrameDimension() - 14, imageWidth);
        Integer base = ColorExtractor.extractDominantColorByHue(image, x0, y0, x1, y1 = Math.min(frameOffsetY + Constants.getOverlayFrameDimension() - 14, imageHeight));
        if (base == null) {
            int neutral = -4144960;
            return new int[]{neutral, neutral, neutral};
        }
        int dark = ColorUtils.tweakHSV(base, 1.06f, 0.82f);
        int mid = ColorUtils.tweakHSV(base, 1.0f, 1.0f);
        int light = ColorUtils.tweakHSV(base, 0.92f, 1.18f);
        return new int[]{light, mid, dark};
    }

    private static Integer extractDominantColorByHue(class_1011 image, int x0, int y0, int x1, int y1) {
        double[] histogram = new double[36];
        for (int y = y0; y < y1; y += 2) {
            for (int x = x0; x < x1; x += 2) {
                int abgr = image.method_4315(x, y);
                int alpha = abgr >>> 24 & 0xFF;
                if (alpha < 48) continue;
                int blue = abgr >>> 16 & 0xFF;
                int green = abgr >>> 8 & 0xFF;
                int red = abgr & 0xFF;
                float[] hsv = Color.RGBtoHSB(red, green, blue, null);
                float saturation = hsv[1];
                float brightness = hsv[2];
                if (saturation < 0.08f || brightness < 0.1f || brightness > 0.98f) continue;
                int bin = (int)(hsv[0] * 36.0f);
                if (bin < 0) {
                    bin = 0;
                }
                if (bin >= 36) {
                    bin = 35;
                }
                double weight = (double)alpha / 255.0 * (0.25 + 0.75 * (double)saturation);
                int n = bin;
                histogram[n] = histogram[n] + weight;
            }
        }
        int bestBin = -1;
        double bestWeight = 0.0;
        for (int i = 0; i < 36; ++i) {
            if (!(histogram[i] > bestWeight)) continue;
            bestWeight = histogram[i];
            bestBin = i;
        }
        if (bestBin < 0 || bestWeight < 1.0E-6) {
            return null;
        }
        int leftBin = (bestBin - 1 + 36) % 36;
        int rightBin = (bestBin + 1) % 36;
        double totalRed = 0.0;
        double totalGreen = 0.0;
        double totalBlue = 0.0;
        double totalWeight = 0.0;
        for (int y = y0; y < y1; y += 2) {
            for (int x = x0; x < x1; x += 2) {
                int abgr = image.method_4315(x, y);
                int alpha = abgr >>> 24 & 0xFF;
                if (alpha < 48) continue;
                int blue = abgr >>> 16 & 0xFF;
                int green = abgr >>> 8 & 0xFF;
                int red = abgr & 0xFF;
                float[] hsv = Color.RGBtoHSB(red, green, blue, null);
                float saturation = hsv[1];
                float brightness = hsv[2];
                if (saturation < 0.08f || brightness < 0.1f || brightness > 0.98f) continue;
                int bin = (int)(hsv[0] * 36.0f);
                if (bin < 0) {
                    bin = 0;
                }
                if (bin >= 36) {
                    bin = 35;
                }
                if (bin != bestBin && bin != leftBin && bin != rightBin) continue;
                double weight = (double)alpha / 255.0 * (0.25 + 0.75 * (double)saturation);
                totalRed += weight * ColorUtils.srgbToLinear((double)red / 255.0);
                totalGreen += weight * ColorUtils.srgbToLinear((double)green / 255.0);
                totalBlue += weight * ColorUtils.srgbToLinear((double)blue / 255.0);
                totalWeight += weight;
            }
        }
        if (totalWeight < 1.0E-6) {
            return null;
        }
        int red = AnimationUtils.clamp255((int)Math.round(ColorUtils.linearToSrgb(totalRed / totalWeight) * 255.0));
        int green = AnimationUtils.clamp255((int)Math.round(ColorUtils.linearToSrgb(totalGreen / totalWeight) * 255.0));
        int blue = AnimationUtils.clamp255((int)Math.round(ColorUtils.linearToSrgb(totalBlue / totalWeight) * 255.0));
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }
}

