/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.util;

import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameData;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.TextAxis;
import dev.xylonity.tooltipoverhaul.config.TooltipsConfig;
import dev.xylonity.tooltipoverhaul.mixin.KeyMappingAccessor;
import dev.xylonity.tooltipoverhaul.registry.TooltipOverhaulKeyMappings;
import java.util.Optional;
import net.minecraft.class_1087;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1309;
import net.minecraft.class_148;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1937;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_4059;
import net.minecraft.class_4608;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;

public class RenderUtils {
    public static boolean hasIcon(TooltipContext context) {
        return !context.getStack().method_7960() && Optional.ofNullable(context.getFrameData()).map(CustomFrameData::shouldDisableIcon).orElse(TooltipsConfig.DISABLE_ICON) == false;
    }

    public static boolean hasRating(TooltipContext context) {
        return !context.getStack().method_7960() && Optional.ofNullable(context.getFrameData()).map(CustomFrameData::shouldShowRating).orElse(TooltipsConfig.SHOW_RATING) != false;
    }

    public static boolean hasDividerLine(TooltipContext context) {
        return !context.getStack().method_7960() && Optional.ofNullable(context.getFrameData()).map(CustomFrameData::shouldDisableDividerLine).orElse(TooltipsConfig.DISABLE_DIVIDER_LINE) == false;
    }

    public static boolean hasShadow(TooltipContext context) {
        return Optional.ofNullable(context.getFrameData()).map(CustomFrameData::shouldShowShadow).orElse(TooltipsConfig.SHOW_TOOLTIP_SHADOW);
    }

    public static boolean hasVignette(TooltipContext context) {
        return Optional.ofNullable(context.getFrameData()).map(CustomFrameData::hasVignette).orElse(TooltipsConfig.VIGNETTES.isBlank()) == false;
    }

    public static boolean shouldRender(TooltipContext context) {
        return Optional.ofNullable(context.getFrameData()).map(CustomFrameData::shouldDisableTooltip).orElse(false) == false;
    }

    public static boolean hasPreviewOfTieredItem(TooltipContext context) {
        if (RenderUtils.isComparisonActive(context)) {
            return false;
        }
        if (context.getStack().method_7909() instanceof class_1831) {
            return Optional.ofNullable(context.getFrameData()).map(data -> data.shouldShowSecondPanel(context)).orElse(TooltipsConfig.TIERED_ITEMS_RENDERER);
        }
        return false;
    }

    public static boolean hasPreviewOfArmorItem(TooltipContext context) {
        if (RenderUtils.isComparisonActive(context)) {
            return false;
        }
        if (context.getStack().method_7909() instanceof class_1738 && !(context.getStack().method_7909() instanceof class_4059)) {
            return Optional.ofNullable(context.getFrameData()).map(data -> data.shouldShowSecondPanel(context)).orElse(TooltipsConfig.ARMOR_ITEMS_RENDERER);
        }
        return false;
    }

    private static boolean isComparisonActive(TooltipContext context) {
        class_3675.class_306 compareKey = ((KeyMappingAccessor)TooltipOverhaulKeyMappings.COMPARE_TOOLTIP).tooltipoverhaul$key();
        boolean isKeyDown = false;
        if (!compareKey.equals((Object)class_3675.field_16237)) {
            isKeyDown = class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)compareKey.method_1444());
        }
        return isKeyDown && context.getOtherTooltipContext() != null;
    }

    public static int calculateSecondPanelSize(TooltipContext context, TextAxis axis) {
        if (axis == TextAxis.X) {
            return Optional.ofNullable(context.getFrameData()).map(CustomFrameData::getSecondPanelSizeX).orElse(TooltipsConfig.SECOND_PANEL_SIZE_X);
        }
        return Optional.ofNullable(context.getFrameData()).map(CustomFrameData::getSecondPanelSizeY).orElse(TooltipsConfig.SECOND_PANEL_SIZE_Y);
    }

    public static String getIconAppearAnimation(TooltipContext context) {
        return Optional.ofNullable(context.getFrameData()).map(CustomFrameData::getIconAppearAnimation).orElse(TooltipsConfig.ICON_APPEAR_ANIMATION);
    }

    public static float getIconRotatingSpeed(TooltipContext context) {
        return Optional.ofNullable(context.getFrameData()).map(CustomFrameData::getIconRotatingSpeed).orElse(Float.valueOf(TooltipsConfig.ICON_ROTATING_SPEED)).floatValue();
    }

    public static String getIconBackgroundType(TooltipContext context) {
        return Optional.ofNullable(context.getFrameData()).map(CustomFrameData::getIconBackground).orElse(TooltipsConfig.ICON_BACKGROUND_TYPE);
    }

    public static String getDividerLineType(TooltipContext context) {
        return Optional.ofNullable(context.getFrameData()).map(CustomFrameData::getDividerLineType).orElse(TooltipsConfig.DIVIDER_LINE_TYPE);
    }

    public static String getEffect(TooltipContext context) {
        return Optional.ofNullable(context.getFrameData()).map(CustomFrameData::getEffect).orElse(TooltipsConfig.EFFECTS);
    }

    public static boolean usePlayerSkinInPreview(TooltipContext context) {
        return Optional.ofNullable(context.getFrameData()).map(CustomFrameData::getUsePlayerSkinInPreview).orElse(TooltipsConfig.USE_PLAYER_SKIN_IN_PREVIEW);
    }

    public static String getPreviewPanelModel(TooltipContext context) {
        return Optional.ofNullable(context.getFrameData()).map(CustomFrameData::getPreviewPanelModel).orElse(TooltipsConfig.PREVIEW_PANEL_MODEL);
    }

    public static int calculatePadding(TooltipContext context, TextAxis axis) {
        if (context.getStack().method_7960()) {
            if (axis == TextAxis.X) {
                return TooltipsConfig.NO_STACK_TOOLTIP_PADDING_X;
            }
            return TooltipsConfig.NO_STACK_TOOLTIP_PADDING_Y;
        }
        if (axis == TextAxis.X) {
            return Optional.ofNullable(context.getFrameData()).map(CustomFrameData::getMainPanelPaddingX).orElse(TooltipsConfig.MAIN_PANEL_PADDING_X);
        }
        return Optional.ofNullable(context.getFrameData()).map(CustomFrameData::getMainPanelPaddingY).orElse(TooltipsConfig.MAIN_PANEL_PADDING_Y);
    }

    public static String getInnerOverlayType(TooltipContext context) {
        return Optional.ofNullable(context.getFrameData()).map(CustomFrameData::getBorderType).orElse(TooltipsConfig.DEFAULT_INNER_OVERLAY_TYPE);
    }

    public static String getOverlayLocation(TooltipContext context) {
        return Optional.ofNullable(context.getFrameData()).map(CustomFrameData::getTextureLocation).orElse(TooltipsConfig.GLOBAL_FRAME_OVERLAY_LOCATION);
    }

    public static void renderItem(TooltipContext context, @Nullable class_1309 entity, @Nullable class_1937 level, class_1799 stack, int seed) {
        if (!stack.method_7960()) {
            class_1087 bakedmodel = class_310.method_1551().method_1480().method_4019(stack, level, entity, seed);
            context.getPose().method_22903();
            try {
                boolean flag;
                context.getPose().method_22905(16.0f, -16.0f, 16.0f);
                boolean bl = flag = !bakedmodel.method_24304();
                if (flag) {
                    class_308.method_24210();
                }
                class_310.method_1551().method_1480().method_23179(stack, class_811.field_4317, false, context.getPose(), context.getBuffer(), 0xF000F0, class_4608.field_21444, bakedmodel);
                context.flush();
                if (flag) {
                    class_308.method_24211();
                }
            }
            catch (Throwable throwable) {
                class_128 crashreport = class_128.method_560((Throwable)throwable, (String)"Rendering item");
                class_129 crashreportcategory = crashreport.method_562("Item being rendered");
                crashreportcategory.method_577("Item Type", () -> String.valueOf(stack.method_7909()));
                crashreportcategory.method_577("Item Components", () -> String.valueOf(stack.method_57353()));
                crashreportcategory.method_577("Item Foil", () -> String.valueOf(stack.method_7958()));
                throw new class_148(crashreport);
            }
            context.getPose().method_22909();
        }
    }

    public static void renderFrameGradient(class_332 graphics, int x, int y, int width, int height, int c1, int c2, int c3) {
        int mid = height / 2;
        graphics.method_25296(x, y, x + 1, y + mid, c1, c2);
        graphics.method_25296(x, y + mid, x + 1, y + height - 1, c2, c3);
        graphics.method_25296(x + width - 1, y, x + width, y + mid, c1, c2);
        graphics.method_25296(x + width - 1, y + mid, x + width, y + height - 1, c2, c3);
    }
}

