/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.util;

import com.google.common.collect.Lists;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameData;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.config.TooltipsConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5631;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_746;

public class TextUtils {
    public static boolean shouldDisableScrolling(TooltipContext context) {
        return Optional.ofNullable(context.getFrameData()).map(CustomFrameData::shouldDisableScrolling).orElse(TooltipsConfig.DISABLE_TOOLTIP_SCROLLING);
    }

    public static List<class_5684> getTooltipComponentsFrom(class_1799 stack, class_327 font, int screenWidth, float screenSplit) {
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        ArrayList componentList = Lists.newArrayList();
        assert (player != null);
        List originalComponentLines = stack.method_7950(class_1792.class_9635.method_59528((class_1937)player.method_37908()), (class_1657)player, (class_1836)(minecraft.field_1690.field_1827 ? class_1836.field_41071 : class_1836.field_41070));
        for (class_2561 originalComponentLine : originalComponentLines) {
            List wrappedLines = font.method_1728((class_5348)originalComponentLine, Math.max((int)((float)screenWidth / screenSplit), 200));
            if (wrappedLines.isEmpty()) {
                componentList.add(class_5684.method_32662((class_5481)class_5481.field_26385));
                continue;
            }
            if (wrappedLines.size() == 1) {
                componentList.add(class_5684.method_32662((class_5481)originalComponentLine.method_30937()));
                continue;
            }
            for (class_5481 wrappedLine : wrappedLines) {
                componentList.add(class_5684.method_32662((class_5481)wrappedLine));
            }
        }
        stack.method_32347().ifPresent(component -> {
            if (component instanceof class_5631) {
                class_5631 bundleTooltip = (class_5631)component;
                int idx = originalComponentLines.size() > 1 ? 1 : componentList.size();
                componentList.add(idx, class_5684.method_32663((class_5632)bundleTooltip));
            }
        });
        return componentList;
    }

    public static class_2561 getRatingText(TooltipContext context) {
        class_124 color = class_124.field_1065;
        class_1814 rarity = context.getStack().method_7932();
        if (rarity == class_1814.field_8906) {
            color = class_124.field_1080;
        } else if (rarity == class_1814.field_8907) {
            color = class_124.field_1054;
        } else if (rarity == class_1814.field_8903) {
            color = class_124.field_1078;
        } else if (rarity == class_1814.field_8904) {
            color = class_124.field_1064;
        }
        CustomFrameData data = context.getFrameData();
        if (data != null && data.hasCustomItemRating()) {
            class_5250 base;
            String raw = data.getItemRating(context.getStack());
            class_5250 class_52502 = base = raw.startsWith("key.tooltipoverhaul") ? class_2561.method_43471((String)raw) : class_2561.method_43470((String)raw);
            if (data.hasCustomColorItemRating()) {
                return base.method_27696(class_2583.field_24360.method_36139(data.getItemRatingColor(context)));
            }
            return base.method_27692(color);
        }
        return TextUtils.getDefaultRarity(context.getStack()).method_27661().method_27692(color);
    }

    private static class_2561 getDefaultRarity(class_1799 stack) {
        class_1814 r = stack.method_7932();
        String string = r.toString();
        if (r == class_1814.field_8906 || r == class_1814.field_8907 || r == class_1814.field_8903 || r == class_1814.field_8904) {
            return class_2561.method_43471((String)("tooltipoverhaul." + string.trim().toLowerCase() + "_rarity"));
        }
        if (string.contains("alexscaves")) {
            return class_2561.method_43471((String)("rarity.alexscaves." + string.split(":")[1] + ".name"));
        }
        return class_2561.method_43471((String)r.name().trim().toLowerCase());
    }
}

