/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.render;

import dev.xylonity.tooltipoverhaul.client.layer.ITooltipLayer;
import dev.xylonity.tooltipoverhaul.client.layout.TooltipPositionCalculator;
import dev.xylonity.tooltipoverhaul.client.layout.TooltipSizeCalculator;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.style.StyleFactory;
import dev.xylonity.tooltipoverhaul.client.util.RenderUtils;
import dev.xylonity.tooltipoverhaul.client.util.TextUtils;
import dev.xylonity.tooltipoverhaul.client.util.TooltipScrollState;
import dev.xylonity.tooltipoverhaul.config.TooltipsConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_241;

public class TooltipRenderer {
    @Nullable
    private final TooltipContext context;
    public static float COUNTER = 0.0f;

    public TooltipRenderer(@Nullable TooltipContext context) {
        this.context = context;
    }

    public void init() {
        if (this.context == null) {
            return;
        }
        if (this.context.getComponents().isEmpty()) {
            return;
        }
        this.context.setTooltipLayers(new StyleFactory().create(this.context, this.context.getFrameData()));
        TooltipSizeCalculator sizeCalculator = this.context.getSizeCalculator();
        TooltipPositionCalculator positionCalculator = this.context.getPositionCalculator();
        int margin = 5;
        class_241 uncappedSize = sizeCalculator.calculate();
        int screenHeight = this.context.getScreenHeight();
        int maxTooltipHeight = screenHeight - margin;
        int cappedHeight = Math.min((int)uncappedSize.field_1342, maxTooltipHeight);
        this.context.setTooltipSize(new class_241(uncappedSize.field_1343, (float)cappedHeight));
        this.context.setTooltipPosition(positionCalculator.calculate());
        if (!TextUtils.shouldDisableScrolling(this.context)) {
            TooltipScrollState.begin((int)uncappedSize.field_1342, cappedHeight);
            TooltipScrollState.tick();
        } else {
            TooltipScrollState.reset();
        }
    }

    public void adjustLayout() {
        if (this.context == null) {
            return;
        }
        if (this.context.getComponents().isEmpty()) {
            return;
        }
        this.context.setTooltipPosition(this.context.getPositionCalculator().adjustPosition());
        this.context.setTooltipSize(this.context.getSizeCalculator().adjustSize());
    }

    public boolean render() {
        if (this.context == null) {
            return false;
        }
        if (this.context.getComponents().isEmpty()) {
            return false;
        }
        if (!RenderUtils.shouldRender(this.context)) {
            return false;
        }
        if (this.context.getStack().method_7960() && !TooltipsConfig.SHOW_TOOLTIP_WITHOUT_STACK) {
            return false;
        }
        List<ITooltipLayer> layers = this.context.getTooltipLayers();
        for (ITooltipLayer layer : layers) {
            layer.renderInternal(this.context);
        }
        return true;
    }
}

