/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.effect;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.xylonity.tooltipoverhaul.client.layer.impl.EffectLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.AnimationUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Random;
import net.minecraft.class_241;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_757;

public class RipplesEffect
implements EffectLayer {
    private static final int RIPPLE_AMOUNT = 4;
    private static final int RING_SEGMENTS = 48;
    private static final float THICKNESS = 8.0f;
    private static final float GLOW = 1.75f;
    private static final float TWEAKING = 1.2f;
    private static final float TWEAKING_MULTIPLIER = 10.0f;
    private static final long PER_RIPPLE = 220L;
    private static final int[] DEFAULT_COLORS = new int[]{0x66FFFFFF, -2002724609, 0x66FFD6FF};
    private static final Deque<Ripple> RIPPLES = new ArrayDeque<Ripple>();
    private static long lastSpawn = 0L;

    @Override
    public void render(TooltipContext context, class_241 position) {
        int positionX = (int)position.field_1343;
        int positionY = (int)position.field_1342;
        int tooltipWidth = (int)context.getTooltipSize().field_1343;
        int tooltipHeight = (int)context.getTooltipSize().field_1342;
        context.push(() -> {
            context.getGraphics().method_44379(positionX - context.getPaddingX() - 1, positionY - context.getPaddingY(), positionX + tooltipWidth + context.getPaddingX(), positionY + tooltipHeight + context.getPaddingY());
            long now = System.currentTimeMillis();
            if (now - lastSpawn >= 220L && RIPPLES.size() < 4) {
                this.spawnRipple(positionX, positionY, tooltipWidth, tooltipHeight, now);
                lastSpawn = now;
            }
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RIPPLES.removeIf(r -> !r.updateAndRender(context, now));
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableBlend();
            context.getGraphics().method_44380();
        });
    }

    private void spawnRipple(int x, int y, int width, int height, long now) {
        Random random = new Random();
        float margin = 10.0f;
        float centerX = (float)x + margin + random.nextFloat() * ((float)width - 2.0f * margin);
        float centerY = (float)y + margin + random.nextFloat() * ((float)height - 2.0f * margin);
        float speed = AnimationUtils.lerp(0.75f, 1.35f, random.nextFloat());
        float thickness = 8.0f * AnimationUtils.lerp(0.85f, 1.35f, random.nextFloat());
        float tweakingAmount = random.nextFloat() * ((float)Math.PI * 2);
        if (RIPPLES.size() >= 4) {
            RIPPLES.pollFirst();
        }
        RIPPLES.addLast(new Ripple(centerX, centerY, 0.5f * (float)Math.hypot(width, height), DEFAULT_COLORS[random.nextInt(DEFAULT_COLORS.length)], now, speed, thickness, tweakingAmount));
    }

    private record Ripple(float centerX, float centerY, float maxRadius, int baseColor, long birth, float speed, float thickness, float tweaking) {
        boolean updateAndRender(TooltipContext context, long nowMs) {
            float lifetime = Math.max(0.0f, (float)(nowMs - this.birth));
            float duration = Math.max(800.0f, 1200.0f * (this.maxRadius / 120.0f));
            float t = lifetime / duration;
            float clamped = Math.min(1.0f, t);
            float eased = AnimationUtils.easeOutCubic(clamped);
            float rad = eased * this.maxRadius * this.speed;
            float alpha = AnimationUtils.clamp01(1.2f - clamped * 1.2f) * 0.85f;
            this.draw(context, this.centerX, this.centerY, rad - this.thickness * 0.5f, rad + this.thickness * 0.5f, this.baseColor, alpha, this.tweaking, nowMs);
            this.draw(context, this.centerX, this.centerY, rad + this.thickness * 0.4f, rad + this.thickness * 2.15f, this.baseColor, alpha * 0.55f, this.tweaking + 1.3f, nowMs);
            return t < 1.05f;
        }

        private void draw(TooltipContext context, float centerX, float centerY, float innerR, float outerR, int color, float alphaPeak, float wobblePhase, long now) {
            float func2;
            float func1;
            float w;
            float theta;
            int i;
            if (outerR <= 1.0f) {
                return;
            }
            if (innerR < 0.0f) {
                innerR = 0.0f;
            }
            if (outerR - innerR <= 0.5f) {
                outerR = innerR + 0.5f;
            }
            int alpha = color >>> 24 & 0xFF;
            int red = color >>> 16 & 0xFF;
            int green = color >>> 8 & 0xFF;
            int blue = color & 0xFF;
            float alphaNorm = AnimationUtils.clamp01(alphaPeak) * ((float)alpha / 255.0f);
            float time = (float)now / 1000.0f;
            float tweaking = (float)Math.toRadians(10.0) * (float)Math.sin(7.5398226682211265 * (double)time + (double)wobblePhase);
            class_287 buf = class_289.method_1348().method_1349();
            RenderSystem.setShader(class_757::method_34540);
            int segments = Math.max(16, 48);
            float midR = innerR + (outerR - innerR) * 0.5f;
            buf.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
            for (i = 0; i <= segments; ++i) {
                theta = (float)(Math.PI * 2 * (double)((float)i / (float)segments));
                w = theta + tweaking * (float)Math.sin(theta * 3.0f);
                func1 = (float)Math.sin(w);
                func2 = (float)Math.cos(w);
                buf.method_22918(context.getPose().method_23760().method_23761(), centerX + func2 * midR, centerY + func1 * midR, 0.0f).method_1336(red, green, blue, (int)(alphaNorm * 255.0f)).method_1344();
                buf.method_22918(context.getPose().method_23760().method_23761(), centerX + func2 * innerR, centerY + func1 * innerR, 0.0f).method_1336(red, green, blue, 0).method_1344();
            }
            class_286.method_43433((class_287.class_7433)buf.method_1326());
            buf.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
            for (i = 0; i <= segments; ++i) {
                theta = (float)(Math.PI * 2 * (double)((float)i / (float)segments));
                w = theta + tweaking * (float)Math.sin(theta * 3.0f);
                func1 = (float)Math.sin(w);
                func2 = (float)Math.cos(w);
                buf.method_22918(context.getPose().method_23760().method_23761(), centerX + func2 * outerR, centerY + func1 * outerR, 0.0f).method_1336(red, green, blue, 0).method_1344();
                buf.method_22918(context.getPose().method_23760().method_23761(), centerX + func2 * midR, centerY + func1 * midR, 0.0f).method_1336(red, green, blue, (int)(alphaNorm * 255.0f)).method_1344();
            }
            class_286.method_43433((class_287.class_7433)buf.method_1326());
        }
    }
}

