/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.effect;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.xylonity.tooltipoverhaul.client.layer.impl.EffectLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.AnimationUtils;
import dev.xylonity.tooltipoverhaul.client.util.ColorUtils;
import net.minecraft.class_241;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class SpeedLinesEffect
implements EffectLayer {
    private static final int RAYS_PER_SIDE = 14;
    private static final int WING_COLOR_INNER = -1056964609;
    private static final int WING_COLOR_OUTER = 1624305919;

    @Override
    public void render(TooltipContext context, class_241 position) {
        int positionX = (int)position.field_1343;
        int positionY = (int)position.field_1342;
        int tooltipWidth = (int)context.getTooltipSize().field_1343;
        int tooltipHeight = (int)context.getTooltipSize().field_1342;
        long now = System.currentTimeMillis();
        float time = (float)(now - context.getStartTime()) / 5000.0f;
        float centerX = (float)positionX + (float)tooltipWidth * 0.5f;
        float centerY = (float)positionY + (float)tooltipHeight * 0.5f;
        float maxRadius = (float)Math.hypot(tooltipWidth, tooltipHeight);
        context.push(() -> {
            context.getGraphics().method_44379(positionX - context.getPaddingX() - 1, positionY - context.getPaddingY(), positionX + tooltipWidth + context.getPaddingX(), positionY + tooltipHeight + context.getPaddingY());
            context.translate(0.0f, 0.0f, context.getLayerDepth().getZ());
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableCull();
            RenderSystem.setShader(class_757::method_34540);
            Matrix4f pose = context.getPose().method_23760().method_23761();
            class_289 tesselator = class_289.method_1348();
            class_287 bufferBuilder = tesselator.method_1349();
            this.renderWings(bufferBuilder, tesselator, pose, centerX, centerY, maxRadius, time);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            context.getGraphics().method_44380();
        });
    }

    private void renderWings(class_287 bufferBuilder, class_289 tesselator, Matrix4f pose, float centerX, float centerY, float maxRadius, float t) {
        bufferBuilder.method_1328(class_293.class_5596.field_27379, class_290.field_1576);
        int innerRed = ColorUtils.red(-1056964609);
        int innerGreen = ColorUtils.green(-1056964609);
        int innerBlue = ColorUtils.blue(-1056964609);
        int innerAlpha = ColorUtils.alpha(-1056964609);
        int outerRed = ColorUtils.red(1624305919);
        int outerGreen = ColorUtils.green(1624305919);
        int outerBlue = ColorUtils.blue(1624305919);
        int outerAlpha = ColorUtils.alpha(1624305919);
        float rayMin = maxRadius * 0.25f;
        float rayMax = maxRadius * 0.95f;
        float spread = 2.6703537f;
        for (int side = -1; side <= 1; side += 2) {
            float baseAngle = side > 0 ? 0.0f : (float)Math.PI;
            for (int i = 0; i < 14; ++i) {
                float s = (float)i / 13.0f;
                float wingOffset = (s - 0.4f) * spread;
                float wobble = 0.1f * (float)Math.sin((double)(t * 2.5f + (float)i * 0.6f) * Math.PI * 2.0);
                float angle = baseAngle + (float)side * (wingOffset + wobble);
                float dirX = (float)Math.cos(angle);
                float dirY = (float)Math.sin(angle);
                float nx = -dirY;
                float ny = dirX;
                float open = 0.75f + 0.25f * (float)Math.sin((double)(t * 1.8f + s * 0.3f) * Math.PI * 2.0);
                float rayLength = rayMin + (rayMax - rayMin) * open;
                float baseRadius = rayMin * (0.4f + s * 0.4f);
                float thickness = maxRadius * 0.03f * (1.1f - s * 0.7f);
                float tipX = centerX + dirX * rayLength;
                float tipY = centerY + dirY * rayLength;
                float rootX = centerX + dirX * baseRadius;
                float rootY = centerY + dirY * baseRadius;
                float tip1X = tipX + nx * thickness;
                float tip1Y = tipY + ny * thickness;
                float tip2X = tipX - nx * thickness;
                float tip2Y = tipY - ny * thickness;
                float head = (float)Math.pow(1.0f - s, 1.4f);
                float flicker = 0.6f + 0.4f * (float)Math.sin((double)(t * 3.0f + (float)i * 0.8f) * Math.PI * 2.0);
                float alphaFactor = head * flicker;
                int rootAlpha = AnimationUtils.clamp255((int)((float)innerAlpha * alphaFactor * 0.8f));
                int tipAlpha = AnimationUtils.clamp255((int)((float)outerAlpha * alphaFactor));
                bufferBuilder.method_22918(pose, rootX, rootY, 0.0f).method_1336(innerRed, innerGreen, innerBlue, rootAlpha).method_1344();
                bufferBuilder.method_22918(pose, tip1X, tip1Y, 0.0f).method_1336(outerRed, outerGreen, outerBlue, tipAlpha).method_1344();
                bufferBuilder.method_22918(pose, tip2X, tip2Y, 0.0f).method_1336(outerRed, outerGreen, outerBlue, tipAlpha / 2 + rootAlpha / 2).method_1344();
            }
        }
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }
}

