/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.effect;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.xylonity.tooltipoverhaul.client.layer.impl.EffectLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.AnimationUtils;
import dev.xylonity.tooltipoverhaul.client.util.ColorUtils;
import java.util.Random;
import net.minecraft.class_241;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class WhiteDustEffect
implements EffectLayer {
    private static final int RUNE_COLOR = -570425345;
    private static final int GLYPH_COLOR = -790580388;
    private static final int PARTICLE_COLOR = -570425345;
    private static final int RUNE_COUNT = 8;
    private static final int PARTICLE_COUNT = 32;
    private static final float[][] RUNES;
    private static final float[][] PARTICLES;

    @Override
    public void render(TooltipContext context, class_241 position) {
        int positionX = (int)position.field_1343;
        int positionY = (int)position.field_1342;
        int tooltipWidth = (int)context.getTooltipSize().field_1343;
        int tooltipHeight = (int)context.getTooltipSize().field_1342;
        long now = System.currentTimeMillis();
        float time = (float)(now - context.getStartTime()) / 12000.0f;
        float timeLoop = time % 1.0f;
        float centerX = (float)positionX + (float)tooltipWidth * 0.5f;
        float centerY = (float)positionY + (float)tooltipHeight * 0.5f;
        float radius = (float)Math.hypot(tooltipWidth, tooltipHeight) * 0.55f;
        context.push(() -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableCull();
            RenderSystem.setShader(class_757::method_34540);
            Matrix4f pose = context.getPose().method_23760().method_23761();
            class_289 tesselator = class_289.method_1348();
            class_287 bufferBuilder = tesselator.method_1349();
            this.renderDust(bufferBuilder, tesselator, pose, centerX, centerY, radius, time);
            this.renderStars(bufferBuilder, tesselator, pose, centerX, centerY, radius, time);
            this.renderGlyphs(bufferBuilder, tesselator, pose, centerX, centerY, radius, timeLoop);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
        });
    }

    private void renderDust(class_287 buf, class_289 tess, Matrix4f pose, float centerX, float centerY, float radius, float tGlobal) {
        buf.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        for (float[] particle : PARTICLES) {
            float angleSeed = particle[0];
            float radialSeed = particle[1];
            float sizeSeed = particle[2];
            float speed = particle[3];
            float phase = particle[4];
            float angle = angleSeed * (float)Math.PI * 2.0f + tGlobal * speed * (float)Math.PI * 2.0f;
            float fadeRadius = 0.6f + 0.4f * (float)Math.sin((double)tGlobal * Math.PI * (double)2.4f + (double)phase);
            float starRadius = radius * radialSeed * fadeRadius;
            float starX = centerX + (float)Math.cos(angle) * starRadius;
            float starY = centerY + (float)Math.sin(angle) * starRadius;
            float twinkleBase = (float)Math.sin((double)(tGlobal * 6.0f + phase) * Math.PI);
            float twinkle = 0.35f + 0.65f * Math.abs(twinkleBase);
            float size = sizeSeed * (0.6f + 0.4f * twinkle);
            int alphaCenter = AnimationUtils.clamp255((int)(255.0f * twinkle));
            int alphaEdge = AnimationUtils.clamp255((int)(200.0f * twinkle));
            float half = size * 0.5f;
            buf.method_22918(pose, starX, starY - half, 0.0f).method_1336(ColorUtils.red(-570425345), ColorUtils.green(-570425345), ColorUtils.blue(-570425345), alphaEdge).method_1344();
            buf.method_22918(pose, starX + half, starY, 0.0f).method_1336(ColorUtils.red(-570425345), ColorUtils.green(-570425345), ColorUtils.blue(-570425345), alphaCenter).method_1344();
            buf.method_22918(pose, starX, starY + half, 0.0f).method_1336(ColorUtils.red(-570425345), ColorUtils.green(-570425345), ColorUtils.blue(-570425345), alphaEdge).method_1344();
            buf.method_22918(pose, starX - half, starY, 0.0f).method_1336(ColorUtils.red(-570425345), ColorUtils.green(-570425345), ColorUtils.blue(-570425345), alphaCenter).method_1344();
        }
        class_286.method_43433((class_287.class_7433)buf.method_1326());
    }

    private void renderStars(class_287 bufferBuilder, class_289 tesselator, Matrix4f pose, float centerX, float centerY, float radius, float time) {
        for (int i = 0; i < 8; ++i) {
            float[] rune = RUNES[i];
            float angleSeed = rune[0];
            float radial = rune[1];
            float orbitSpeed = rune[2];
            float phase = rune[3];
            float angle = angleSeed * (float)Math.PI * 2.0f + time * orbitSpeed * (float)Math.PI * 2.0f;
            float orbitRadius = radius * radial * (0.9f + 0.1f * (float)Math.sin((double)time * Math.PI * 3.5 + (double)phase));
            float dustX = centerX + (float)Math.cos(angle) * orbitRadius;
            float dustY = centerY + (float)Math.sin(angle) * orbitRadius;
            float runeRotation = phase + time * (float)Math.PI * 1.7f;
            float glow = 0.65f + 0.35f * (float)Math.sin((double)(time * 4.0f + phase) * Math.PI * 2.0);
            float size = 5.0f * (0.8f + 0.4f * glow);
            int type = i % 4 == 3 ? 3 : i % 3;
            this.star(bufferBuilder, tesselator, pose, dustX, dustY, size, runeRotation, glow, type);
        }
    }

    private void star(class_287 bufferBuilder, class_289 tesselator, Matrix4f pose, float centerX, float centerY, float size, float rotation, float glow, int type) {
        if (type == 3) {
            float glowSize = size * 1.6f;
            float coreSize = size * 0.9f;
            this.drawStar(bufferBuilder, tesselator, pose, centerX, centerY, glowSize, -570425345, 0.5f * glow);
            this.drawStar(bufferBuilder, tesselator, pose, centerX, centerY, coreSize, -570425345, glow);
        }
    }

    private void drawStar(class_287 bufferBuilder, class_289 tesselator, Matrix4f pose, float centerX, float centerY, float size, int color, float alphaMult) {
        bufferBuilder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
        int alpha = AnimationUtils.clamp255((int)((float)ColorUtils.alpha(color) * alphaMult));
        bufferBuilder.method_22918(pose, centerX, centerY, 0.0f).method_1336(ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), alpha).method_1344();
        for (int i = 0; i <= 8; ++i) {
            float angle = (float)i / 8.0f * (float)Math.PI * 2.0f;
            float radius = size * (i % 2 == 0 ? 1.0f : 0.4f);
            float starX = centerX + (float)Math.cos(angle) * radius;
            float starY = centerY + (float)Math.sin(angle) * radius;
            int edgeAlpha = AnimationUtils.clamp255((int)((float)alpha * 0.2f));
            bufferBuilder.method_22918(pose, starX, starY, 0.0f).method_1336(ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), edgeAlpha).method_1344();
        }
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    private void renderGlyphs(class_287 bufferBuilder, class_289 tesselator, Matrix4f pose, float centerX, float centerY, float radius, float time) {
        float envelope = (float)Math.sin((double)time * Math.PI);
        if (envelope < 0.05f) {
            return;
        }
        float rawV = (float)Math.pow(envelope, 1.2f);
        float size = radius * 0.24f * (0.9f + 0.2f * rawV);
        int alphaMain = AnimationUtils.clamp255((int)((float)ColorUtils.alpha(-790580388) * rawV));
        int alphaSoft = AnimationUtils.clamp255((int)((float)ColorUtils.alpha(-790580388) * 0.4f * rawV));
        bufferBuilder.method_1328(class_293.class_5596.field_27377, class_290.field_1576);
        bufferBuilder.method_22918(pose, centerX - size, centerY, 0.0f).method_1336(ColorUtils.red(-790580388), ColorUtils.green(-790580388), ColorUtils.blue(-790580388), alphaMain).method_1344();
        bufferBuilder.method_22918(pose, centerX + size, centerY, 0.0f).method_1336(ColorUtils.red(-790580388), ColorUtils.green(-790580388), ColorUtils.blue(-790580388), alphaMain).method_1344();
        bufferBuilder.method_22918(pose, centerX, centerY - size, 0.0f).method_1336(ColorUtils.red(-790580388), ColorUtils.green(-790580388), ColorUtils.blue(-790580388), alphaMain).method_1344();
        bufferBuilder.method_22918(pose, centerX, centerY + size, 0.0f).method_1336(ColorUtils.red(-790580388), ColorUtils.green(-790580388), ColorUtils.blue(-790580388), alphaMain).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        bufferBuilder.method_1328(class_293.class_5596.field_27378, class_290.field_1576);
        int innerSeg = 24;
        float innerRad = size * 0.7f;
        for (int i = 0; i <= innerSeg; ++i) {
            float alpha = (float)i / (float)innerSeg * (float)Math.PI * 2.0f;
            float x = centerX + (float)Math.cos(alpha) * innerRad;
            float y = centerY + (float)Math.sin(alpha) * innerRad;
            bufferBuilder.method_22918(pose, x, y, 0.0f).method_1336(ColorUtils.red(-790580388), ColorUtils.green(-790580388), ColorUtils.blue(-790580388), alphaSoft).method_1344();
        }
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    static {
        int i;
        RUNES = new float[8][4];
        PARTICLES = new float[32][5];
        Random random = new Random(33333L);
        for (i = 0; i < 8; ++i) {
            WhiteDustEffect.RUNES[i][0] = (float)i / 8.0f;
            WhiteDustEffect.RUNES[i][1] = 0.55f + random.nextFloat() * 0.35f;
            WhiteDustEffect.RUNES[i][2] = 0.5f + random.nextFloat() * 0.7f;
            WhiteDustEffect.RUNES[i][3] = random.nextFloat() * (float)Math.PI * 2.0f;
        }
        for (i = 0; i < 32; ++i) {
            WhiteDustEffect.PARTICLES[i][0] = random.nextFloat();
            WhiteDustEffect.PARTICLES[i][1] = 0.45f + random.nextFloat() * 0.65f;
            WhiteDustEffect.PARTICLES[i][2] = 0.5f + random.nextFloat() * 1.5f;
            WhiteDustEffect.PARTICLES[i][3] = 0.4f + random.nextFloat() * 0.9f;
            WhiteDustEffect.PARTICLES[i][4] = random.nextFloat() * (float)Math.PI * 2.0f;
        }
    }
}

