/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.icon;

import dev.xylonity.tooltipoverhaul.client.layer.impl.IconLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.render.TooltipRenderer;
import dev.xylonity.tooltipoverhaul.client.style.icon.animation.IconAnimation;
import dev.xylonity.tooltipoverhaul.client.style.icon.animation.IconAnimationFactory;
import dev.xylonity.tooltipoverhaul.client.util.Constants;
import dev.xylonity.tooltipoverhaul.client.util.RenderUtils;
import dev.xylonity.tooltipoverhaul.compat.modernfix.ModernFixCompat;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_241;
import net.minecraft.class_310;
import net.minecraft.class_7833;

public class DefaultIcon
implements IconLayer {
    private static final float ANIMATION_DURATION = 0.6f;
    private static final float ICON_SCALE = 1.35f;

    @Override
    public void render(TooltipContext context, class_241 position) {
        float positionX = context.getTooltipPosition().field_1343 + (float)context.getPaddingX() - 1.0f;
        float positionY = context.getTooltipPosition().field_1342 + (float)context.getPaddingY();
        context.push(() -> {
            context.translate(positionX + (float)Constants.getIconSize(context) / 2.0f, positionY + (float)Constants.getIconSize(context) / 2.0f, context.getLayerDepth().getZ());
            IconAnimation animationType = IconAnimation.fromString(RenderUtils.getIconAppearAnimation(context));
            float elapsed = TooltipRenderer.COUNTER;
            float progress = Math.min(elapsed / 0.6f, 1.0f);
            if (elapsed < 0.6f) {
                this.applyEntryAnimation(context, animationType, progress);
            } else {
                this.applyContinuousRotation(context, animationType, elapsed);
            }
            if (ModernFixCompat.SHOULD_RETURN_ORIGINAL_RENDER) {
                ModernFixCompat.push();
                try {
                    RenderUtils.renderItem(context, (class_1309)class_310.method_1551().field_1724, (class_1937)class_310.method_1551().field_1687, context.getStack(), 0);
                }
                finally {
                    ModernFixCompat.pop();
                }
            } else {
                RenderUtils.renderItem(context, (class_1309)class_310.method_1551().field_1724, (class_1937)class_310.method_1551().field_1687, context.getStack(), 0);
            }
        });
    }

    private void applyEntryAnimation(TooltipContext context, IconAnimation type, float progress) {
        if (type == IconAnimation.ROTATE || type == IconAnimation.ROTATE_ZOOM) {
            context.multiply(class_7833.field_40716, 180.0f);
        }
        IconAnimationFactory.get(type).apply(context, progress, 1.35f);
    }

    private void applyContinuousRotation(TooltipContext context, IconAnimation type, float elapsed) {
        context.scale(1.35f, 1.35f, 1.35f);
        float rotationSpeed = RenderUtils.getIconRotatingSpeed(context);
        if (rotationSpeed > 0.0f) {
            float finalRotation = this.computeFinalDegrees(type);
            float additionalRotation = (elapsed - 0.6f) * (360.0f / (6.0f / rotationSpeed));
            context.multiply(class_7833.field_40716, (finalRotation + additionalRotation) % 360.0f);
        }
    }

    private float computeFinalDegrees(IconAnimation type) {
        int factor = switch (type) {
            case IconAnimation.ROTATE_FAST -> 10;
            case IconAnimation.ROTATE, IconAnimation.ROTATE_ZOOM -> 5;
            default -> 0;
        };
        return 0.6f * (float)factor * 60.0f % 360.0f;
    }
}

