/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.text;

import com.mojang.blaze3d.platform.GlStateManager;
import dev.xylonity.tooltipoverhaul.client.layer.impl.TextLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.util.Constants;
import dev.xylonity.tooltipoverhaul.client.util.PositionUtils;
import dev.xylonity.tooltipoverhaul.client.util.RenderUtils;
import dev.xylonity.tooltipoverhaul.client.util.TextUtils;
import dev.xylonity.tooltipoverhaul.client.util.TooltipScrollState;
import java.util.List;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;

public class DefaultText
implements TextLayer {
    @Override
    public void render(TooltipContext context, class_241 position) {
        List<class_5684> components = context.getComponents();
        class_327 font = context.getFont();
        class_4587 poseStack = context.getPose();
        class_332 graphics = context.getGraphics();
        boolean hasIcon = context.hasIcon();
        boolean hasDividerLine = context.hasDividerLine();
        boolean hasRating = RenderUtils.hasRating(context);
        int paddingX = context.getPaddingX();
        int paddingY = context.getPaddingY();
        int x = (int)(position.field_1343 + (float)paddingX);
        int y = (int)(position.field_1342 + (float)paddingY + 1.0f);
        class_5684 titleComponent = components.get(0);
        if (titleComponent != null) {
            int extraX = 0;
            int extraY = 0;
            int titleAlignY = 0;
            int ratingAlignY = 0;
            if (hasIcon) {
                extraX = Constants.getIconSize(context) + Constants.getIconTitleSeparation(context);
                extraY = Constants.getIconSize(context) / 2;
                titleAlignY = hasRating ? titleComponent.method_32661() : Constants.getIconSize(context) / 4;
            } else {
                ratingAlignY = titleComponent.method_32661();
            }
            int titleAlignment = this.computeTitleAlignment(context, titleComponent, x + extraX);
            titleComponent.method_32665(font, x + extraX + titleAlignment, y + extraY - titleAlignY, poseStack.method_23760().method_23761(), graphics.method_51450());
            if (hasRating) {
                class_2561 rating = TextUtils.getRatingText(context);
                int ratingAlignment = this.computeRatingAlignment(context, rating, x + extraX);
                context.getGraphics().method_51439(font, TextUtils.getRatingText(context), x + extraX + ratingAlignment, y + extraY + ratingAlignY, 15588982, false);
                y += class_5684.method_32662((class_5481)rating.method_30937()).method_32661();
            } else if (hasIcon) {
                y += titleComponent.method_32661();
            }
            y += titleComponent.method_32661();
        }
        if (hasIcon) {
            y += Constants.getIconTitleSeparation(context);
        }
        if (hasDividerLine && components.size() > 1) {
            y = hasIcon ? (y += Constants.getDividerLineFullPadding(context)) : (y += Constants.getDividerLineFullPadding(context));
        }
        int contentStartY = y;
        if (TooltipScrollState.isIsActive()) {
            graphics.method_51452();
            class_310 minecraft = class_310.method_1551();
            int guiScale = (int)minecraft.method_22683().method_4495();
            int scissorLeft = (int)position.field_1343 + paddingX;
            int scissorRight = (int)position.field_1343 + (int)context.getTooltipSize().field_1343 - paddingX;
            int scissorBottom = (int)position.field_1342 + (int)context.getTooltipSize().field_1342 - paddingY;
            int windowHeight = minecraft.method_22683().method_4506();
            int scaledLeft = scissorLeft * guiScale;
            int scaledTop = windowHeight - scissorBottom * guiScale;
            int scaledWidth = (scissorRight - scissorLeft) * guiScale;
            int scaledHeight = (scissorBottom - contentStartY) * guiScale;
            GlStateManager._enableScissorTest();
            GlStateManager._scissorBox((int)scaledLeft, (int)scaledTop, (int)scaledWidth, (int)scaledHeight);
            y -= TooltipScrollState.getScroll();
        }
        for (int i = 1; i < components.size(); ++i) {
            class_5684 component = components.get(i);
            if (!TooltipScrollState.isIsActive() || y + component.method_32661() >= contentStartY && y <= (int)(position.field_1342 + context.getTooltipSize().field_1342 - (float)paddingY)) {
                component.method_32665(font, x, y, poseStack.method_23760().method_23761(), graphics.method_51450());
                component.method_32666(font, x, y, graphics);
            }
            y += component.method_32661();
        }
        if (TooltipScrollState.isIsActive()) {
            graphics.method_51452();
            GlStateManager._disableScissorTest();
        }
    }

    private int computeTitleAlignment(TooltipContext context, class_5684 component, int startX) {
        return switch (PositionUtils.getTitleTextAlignment(context)) {
            case "middle" -> {
                int tooltipSizeX = (int)context.getTooltipSize().field_1343;
                int tooltipPositionX = (int)context.getTooltipPosition().field_1343;
                int total = tooltipSizeX + tooltipPositionX;
                yield (total - startX - context.getPaddingX()) / 2 - component.method_32664(context.getFont()) / 2;
            }
            case "right" -> {
                int tooltipSizeX = (int)context.getTooltipSize().field_1343;
                int tooltipPositionX = (int)context.getTooltipPosition().field_1343;
                int total = tooltipSizeX + tooltipPositionX;
                yield total - startX - context.getPaddingX() - component.method_32664(context.getFont());
            }
            default -> 0;
        };
    }

    private int computeRatingAlignment(TooltipContext context, class_2561 component, int startX) {
        return switch (PositionUtils.getRatingTextAlignment(context)) {
            case "middle" -> {
                int tooltipSizeX = (int)context.getTooltipSize().field_1343;
                int tooltipPositionX = (int)context.getTooltipPosition().field_1343;
                int total = tooltipSizeX + tooltipPositionX;
                yield (total - startX - context.getPaddingX()) / 2 - context.getFont().method_27525((class_5348)component) / 2;
            }
            case "right" -> {
                int tooltipSizeX = (int)context.getTooltipSize().field_1343;
                int tooltipPositionX = (int)context.getTooltipPosition().field_1343;
                int total = tooltipSizeX + tooltipPositionX;
                yield total - startX - context.getPaddingX() - context.getFont().method_27525((class_5348)component);
            }
            default -> 0;
        };
    }
}

