/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.vignette;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.xylonity.tooltipoverhaul.client.layer.impl.VignetteLayer;
import dev.xylonity.tooltipoverhaul.client.render.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.style.vignette.parser.VignetteEntry;
import dev.xylonity.tooltipoverhaul.client.util.ColorUtils;
import dev.xylonity.tooltipoverhaul.client.util.PositionUtils;
import dev.xylonity.tooltipoverhaul.client.util.TextAxis;
import net.minecraft.class_241;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class CircularVignette
implements VignetteLayer {
    private static final int SEGMENTS = 64;
    private final VignetteEntry vignetteEntry;

    public CircularVignette(VignetteEntry vignetteEntry) {
        this.vignetteEntry = vignetteEntry;
    }

    @Override
    public void render(TooltipContext context, class_241 position) {
        int positionX = (int)position.field_1343;
        int positionY = (int)position.field_1342;
        int tooltipWidth = (int)context.getTooltipSize().field_1343;
        int tooltipHeight = (int)context.getTooltipSize().field_1342;
        int paddingX = context.getPaddingX();
        int paddingY = context.getPaddingY();
        float anchorPositionX = (float)(positionX + PositionUtils.getVignettePosition(context, this.vignetteEntry, TextAxis.X)) + (float)tooltipHeight * ((float)this.vignetteEntry.extraPositionX() / 100.0f);
        float anchorPositionY = (float)(positionY + PositionUtils.getVignettePosition(context, this.vignetteEntry, TextAxis.Y)) + (float)tooltipWidth * ((float)this.vignetteEntry.extraPositionY() / 100.0f);
        float radius = (float)tooltipWidth * this.vignetteEntry.radius();
        int color = this.vignetteEntry.color();
        context.translate(anchorPositionX, anchorPositionY, 0.0f);
        context.getGraphics().method_44379(positionX - paddingX - 1, positionY - paddingY, positionX + tooltipWidth + paddingX, positionY + tooltipHeight + paddingY);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableCull();
        RenderSystem.setShader(class_757::method_34540);
        Matrix4f pose = context.getPose().method_23760().method_23761();
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
        buffer.method_22918(pose, 0.0f, 0.0f, 0.0f).method_1336(ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), ColorUtils.alpha(color)).method_1344();
        for (int i = 0; i <= 64; ++i) {
            float angle = (float)i / 64.0f * (float)Math.PI * 2.0f;
            float vertexPositionX = (float)Math.cos(angle) * radius;
            float vertexPositionY = (float)Math.sin(angle) * radius;
            buffer.method_22918(pose, vertexPositionX, vertexPositionY, 0.0f).method_1336(ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), 0).method_1344();
        }
        class_286.method_43433((class_287.class_7433)buffer.method_1326());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        context.getGraphics().method_44380();
    }
}

