/*
 * Decompiled with CFR 0.152.
 */
package hohocreepers.init;

import hohocreepers.entity.CandyCaneCreeperEntity;
import hohocreepers.entity.CreeperClausEntity;
import hohocreepers.entity.CreeperClausEntityProjectile;
import hohocreepers.entity.GingerbreadCreeperEntity;
import hohocreepers.entity.JingleBombsEntity;
import hohocreepers.entity.SnowBoomEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.SpawnPlacementRegisterEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class HoHoCreepersModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"ho_ho_creepers");
    public static final DeferredHolder<EntityType<?>, EntityType<SnowBoomEntity>> SNOW_BOOM = HoHoCreepersModEntities.register("snow_boom", EntityType.Builder.of(SnowBoomEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<CreeperClausEntity>> CREEPER_CLAUS = HoHoCreepersModEntities.register("creeper_claus", EntityType.Builder.of(CreeperClausEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<CreeperClausEntityProjectile>> CREEPER_CLAUS_PROJECTILE = HoHoCreepersModEntities.register("projectile_creeper_claus", EntityType.Builder.of(CreeperClausEntityProjectile::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<JingleBombsEntity>> JINGLE_BOMBS = HoHoCreepersModEntities.register("jingle_bombs", EntityType.Builder.of(JingleBombsEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<GingerbreadCreeperEntity>> GINGERBREAD_CREEPER = HoHoCreepersModEntities.register("gingerbread_creeper", EntityType.Builder.of(GingerbreadCreeperEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<CandyCaneCreeperEntity>> CANDY_CANE_CREEPER = HoHoCreepersModEntities.register("candy_cane_creeper", EntityType.Builder.of(CandyCaneCreeperEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.7f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(SpawnPlacementRegisterEvent event) {
        SnowBoomEntity.init(event);
        CreeperClausEntity.init(event);
        JingleBombsEntity.init(event);
        GingerbreadCreeperEntity.init(event);
        CandyCaneCreeperEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SNOW_BOOM.get(), SnowBoomEntity.createAttributes().build());
        event.put((EntityType)CREEPER_CLAUS.get(), CreeperClausEntity.createAttributes().build());
        event.put((EntityType)JINGLE_BOMBS.get(), JingleBombsEntity.createAttributes().build());
        event.put((EntityType)GINGERBREAD_CREEPER.get(), GingerbreadCreeperEntity.createAttributes().build());
        event.put((EntityType)CANDY_CANE_CREEPER.get(), CandyCaneCreeperEntity.createAttributes().build());
    }
}

