/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pixelshot.client.handler;

import com.google.common.base.Strings;
import fuzs.pixelshot.client.handler.OrthoViewHandler;
import fuzs.puzzleslib.api.util.v1.ComponentHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9779;

public class OrthoOverlayHandler {
    public static final OrthoOverlayHandler INSTANCE = new OrthoOverlayHandler();
    public static final String KEY_ZOOM = "pixelshot.zoom";
    public static final String KEY_X_ROTATION = "pixelshot.x_rot";
    public static final String KEY_Y_ROTATION = "pixelshot.y_rot";
    private static final class_124 TEXT_COLOR = class_124.field_1068;
    private static final class_124 POSITIVE_COLOR = class_124.field_1060;
    private static final class_124 NEGATIVE_COLOR = class_124.field_1061;
    private static final int OVERLAY_TIME = 25;
    private static final int OVERLAY_FADE_START = 5;
    private int overlayTicks;
    private class_124 zoomColor = TEXT_COLOR;
    private class_124 xRotColor = TEXT_COLOR;
    private class_124 yRotColor = TEXT_COLOR;

    public void onStartClientTick(class_310 minecraft) {
        if (this.overlayTicks > 0) {
            --this.overlayTicks;
        }
    }

    public void setZoomOverlay(float newValue, float oldValue) {
        this.setOverlayTicks();
        this.zoomColor = this.getOverlayColor(newValue, oldValue);
    }

    public void setXRotOverlay(float newValue, float oldValue) {
        this.setOverlayTicks();
        this.xRotColor = this.getOverlayColor(newValue, oldValue);
    }

    public void setYRotOverlay(float newValue, float oldValue) {
        this.setOverlayTicks();
        this.yRotColor = this.getOverlayColor(newValue, oldValue);
    }

    private void setOverlayTicks() {
        this.overlayTicks = 25;
        this.xRotColor = this.yRotColor = TEXT_COLOR;
        this.zoomColor = this.yRotColor;
    }

    private class_124 getOverlayColor(float newValue, float oldValue) {
        return newValue - oldValue > 0.0f ? POSITIVE_COLOR : NEGATIVE_COLOR;
    }

    public void onAfterRenderGui(class_332 guiGraphics, class_9779 deltaTracker) {
        if (OrthoViewHandler.INSTANCE.isActive() && this.overlayTicks > 0) {
            class_310 minecraft = class_310.method_1551();
            class_1297 entity = minecraft.field_1773.method_19418().method_19331();
            List<String> overlayInformation = this.getOverlayInformation(entity);
            float alpha = class_3532.method_15363((float)(((float)this.overlayTicks - deltaTracker.method_60637(false)) / 5.0f), (float)0.0f, (float)1.0f);
            this.renderLines(minecraft.field_1772, guiGraphics, overlayInformation, alpha, true);
        }
    }

    private List<String> getOverlayInformation(class_1297 entity) {
        OrthoViewHandler orthoViewHandler = OrthoViewHandler.INSTANCE;
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(this.getDisplayEntry(KEY_ZOOM, orthoViewHandler.getZoom(), this.zoomColor));
        float xRot = orthoViewHandler.followPlayerView() ? entity.method_5695(1.0f) : orthoViewHandler.getXRot();
        lines.add(this.getDisplayEntry(KEY_X_ROTATION, class_3532.method_15393((float)xRot), this.xRotColor));
        float yRot = orthoViewHandler.followPlayerView() ? entity.method_5705(1.0f) : orthoViewHandler.getYRot();
        lines.add(this.getDisplayEntry(KEY_Y_ROTATION, class_3532.method_15393((float)yRot), this.yRotColor));
        return lines;
    }

    private String getDisplayEntry(String translationKey, float value, class_124 color) {
        class_5250 component = class_2561.method_43469((String)translationKey, (Object[])new Object[]{class_2561.method_43470((String)"%.1f".formatted(Float.valueOf(value))).method_27692(color)});
        return ComponentHelper.getAsString((class_5348)component);
    }

    private void renderLines(class_327 font, class_332 guiGraphics, List<String> lines, float alpha, boolean leftSide) {
        for (int j = 0; j < lines.size(); ++j) {
            String s = lines.get(j);
            if (Strings.isNullOrEmpty((String)s)) continue;
            int k = font.method_1727(s);
            int l = leftSide ? 2 : guiGraphics.method_51421() - 2 - k;
            Objects.requireNonNull(font);
            int i1 = 2 + 9 * j;
            Objects.requireNonNull(font);
            guiGraphics.method_25294(l - 1, i1 - 1, l + k + 1, i1 + 9 - 1, 0x505050 | (int)(144.0f * alpha) << 24);
        }
        for (int j1 = 0; j1 < lines.size(); ++j1) {
            String s1 = lines.get(j1);
            if (Strings.isNullOrEmpty((String)s1)) continue;
            int k1 = font.method_1727(s1);
            int l1 = leftSide ? 2 : guiGraphics.method_51421() - 2 - k1;
            Objects.requireNonNull(font);
            int i2 = 2 + 9 * j1;
            guiGraphics.method_51433(font, s1, l1, i2, 0xE0E0E0 | Math.max(5, (int)(255.0f * alpha)) << 24, false);
        }
    }
}

