/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pixelshot.client.handler;

import fuzs.pixelshot.Pixelshot;
import fuzs.pixelshot.client.handler.OrthoViewHandler;
import fuzs.pixelshot.client.helper.LegacyScreenshot;
import fuzs.pixelshot.config.ClientConfig;
import fuzs.puzzleslib.api.client.core.v1.context.KeyMappingsContext;
import fuzs.puzzleslib.api.client.key.v1.KeyActivationContext;
import fuzs.puzzleslib.api.client.key.v1.KeyMappingHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_11908;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_5250;
import net.minecraft.class_9779;

public class ScreenshotHandler {
    public static final ScreenshotHandler INSTANCE = new ScreenshotHandler();
    public static final class_5250 COMPONENT_SCREENSHOT_TAKE = class_2561.method_43471((String)"screenshot.take");
    public static final class_304 KEY_HIGH_RESOLUTION_SCREENSHOT = KeyMappingHelper.registerKeyMapping((class_2960)Pixelshot.id("high_resolution_screenshot"), (int)298);
    public static final class_304 KEY_PANORAMIC_SCREENSHOT = KeyMappingHelper.registerUnboundKeyMapping((class_2960)Pixelshot.id("panoramic_screenshot"));
    private boolean hugeScreenshotMode;

    public static void onRegisterKeyMappings(KeyMappingsContext context) {
        context.registerKeyMapping(KEY_HIGH_RESOLUTION_SCREENSHOT, KeyActivationContext.GAME);
        context.registerKeyMapping(KEY_PANORAMIC_SCREENSHOT, KeyActivationContext.GAME);
    }

    public boolean isHugeScreenshotMode() {
        return this.hugeScreenshotMode;
    }

    private void setHugeScreenshotMode(boolean hugeScreenshotMode) {
        this.hugeScreenshotMode = hugeScreenshotMode;
        class_310.method_1551().field_1773.method_35769(!hugeScreenshotMode);
    }

    public EventResult onKeyPress(class_11908 keyEvent, int action) {
        class_310 minecraft = class_310.method_1551();
        if (action == 1 && minecraft.field_1755 == null) {
            if (KeyMappingHelper.isKeyActiveAndMatches((class_304)KEY_HIGH_RESOLUTION_SCREENSHOT, (class_11908)keyEvent)) {
                int windowWidth = minecraft.method_22683().method_4489();
                int windowHeight = minecraft.method_22683().method_4506();
                int imageWidth = ((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).highResolutionScreenshots.imageWidth;
                int imageHeight = ((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).highResolutionScreenshots.imageHeight;
                Consumer<class_2561> consumer = component -> minecraft.execute(() -> minecraft.field_1705.method_1743().method_1812(component));
                this.setHugeScreenshotMode(true);
                if (((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).highResolutionScreenshots.tiledRendering) {
                    consumer.accept(this.grabHugeScreenshot(minecraft, windowWidth, windowHeight, imageWidth, imageHeight));
                } else {
                    this.grabHugeScreenshot(minecraft, windowWidth, windowHeight, imageWidth, imageHeight, consumer);
                }
                this.setHugeScreenshotMode(false);
            }
            if (KeyMappingHelper.isKeyActiveAndMatches((class_304)KEY_PANORAMIC_SCREENSHOT, (class_11908)keyEvent) && !OrthoViewHandler.INSTANCE.isActive()) {
                class_2561 component2 = minecraft.method_35698(minecraft.field_1697);
                minecraft.execute(() -> minecraft.field_1705.method_1743().method_1812(component2));
            }
        }
        return EventResult.PASS;
    }

    private class_2561 grabHugeScreenshot(class_310 minecraft, int columnWidth, int rowHeight, int width, int height) {
        try {
            LegacyScreenshot screenshot = new LegacyScreenshot(minecraft.field_1697, width, height, rowHeight);
            float f = (float)width / (float)columnWidth;
            float g = (float)height / (float)rowHeight;
            float h = f > g ? f : g;
            for (int i = (height - 1) / rowHeight * rowHeight; i >= 0; i -= rowHeight) {
                ByteBuffer byteBuffer = LegacyScreenshot.allocateMemory(columnWidth * rowHeight * 3);
                for (int j = 0; j < width; j += columnWidth) {
                    float k = (float)(width - columnWidth) / 2.0f * 2.0f - (float)(j * 2);
                    float l = (float)(height - rowHeight) / 2.0f * 2.0f - (float)(i * 2);
                    k /= (float)columnWidth;
                    l /= (float)rowHeight;
                    LegacyScreenshot.pixelStore(3333, 1);
                    LegacyScreenshot.pixelStore(3317, 1);
                    byteBuffer.clear();
                    LegacyScreenshot.readPixels(0, 0, columnWidth, rowHeight, 32992, 5121, byteBuffer);
                    screenshot.addRegion(byteBuffer, j, i, columnWidth, rowHeight);
                }
                screenshot.saveRow();
                LegacyScreenshot.freeMemory(byteBuffer);
            }
            File file = screenshot.close();
            class_5250 component = class_2561.method_43470((String)file.getName()).method_27692(class_124.field_1073).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10607(file.getAbsoluteFile())));
            return class_2561.method_43469((String)"screenshot.success", (Object[])new Object[]{component});
        }
        catch (Exception exception) {
            Pixelshot.LOGGER.warn("Couldn't save screenshot", (Throwable)exception);
            return class_2561.method_43469((String)"screenshot.failure", (Object[])new Object[]{exception.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grabHugeScreenshot(class_310 minecraft, int windowWidth, int windowHeight, int imageWidth, int imageHeight, Consumer<class_2561> consumer) {
        class_1041 window = minecraft.method_22683();
        class_276 renderTarget = minecraft.method_1522();
        try {
            window.method_35642(imageWidth);
            window.method_35643(imageHeight);
            renderTarget.method_1234(imageWidth, imageHeight);
            minecraft.field_1773.method_3188(class_9779.field_51956);
            String screenshotName = LegacyScreenshot.getFile(minecraft.field_1697, "huge_", ".png").getName();
            class_318.method_22690((File)minecraft.field_1697, (String)screenshotName, (class_276)renderTarget, (int)1, consumer);
            consumer.accept((class_2561)COMPONENT_SCREENSHOT_TAKE);
        }
        finally {
            window.method_35642(windowWidth);
            window.method_35643(windowHeight);
            renderTarget.method_1234(windowWidth, windowHeight);
        }
    }
}

