/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pixelshot.client.handler;

import fuzs.pixelshot.Pixelshot;
import fuzs.pixelshot.client.gui.screens.AbstractCameraScreen;
import fuzs.pixelshot.client.handler.OrthoOverlayHandler;
import fuzs.pixelshot.client.helper.DirectionHelper;
import fuzs.pixelshot.config.ClientConfig;
import fuzs.puzzleslib.api.client.core.v1.context.KeyMappingsContext;
import fuzs.puzzleslib.api.client.key.v1.KeyActivationContext;
import fuzs.puzzleslib.api.client.key.v1.KeyMappingHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import net.minecraft.class_11400;
import net.minecraft.class_2535;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5498;
import net.minecraft.class_5636;
import net.minecraft.class_636;
import net.minecraft.class_7285;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class OrthoViewHandler {
    public static final OrthoViewHandler INSTANCE = new OrthoViewHandler();
    public static final float ZOOM_DEFAULT = 8.0f;
    public static final float ZOOM_MIN = 0.1f;
    public static final float ZOOM_MAX = 500.0f;
    public static final float ZOOM_STEP = 0.5f;
    public static final float X_ROTATION_DEFAULT = 30.0f;
    public static final float X_ROTATION_MIN = -90.0f;
    public static final float X_ROTATION_MAX = 90.0f;
    public static final float Y_ROTATION_DEFAULT = 135.0f;
    public static final float Y_ROTATION_MIN = -180.0f;
    public static final float Y_ROTATION_MAX = 180.0f;
    private static final float ROTATION_STEP_MIN = 8.0f;
    private static final float ROTATION_STEP_MAX = 24.0f;
    public static final float NEAR_CLIPPING_DISTANCE = 10.0f;
    public static final float FAR_CLIPPING_DISTANCE = 1000.0f;
    private static final float STEP_MULTIPLIER = 0.25f;
    static final int DECIMAL_PLACES = 1;
    public static final class_304 KEY_TOGGLE_VIEW = KeyMappingHelper.registerKeyMapping((class_2960)Pixelshot.id("orthographic_camera"), (int)296);
    public static final class_304 KEY_OPEN_MENU = KeyMappingHelper.registerKeyMapping((class_2960)Pixelshot.id("open_menu"), (int)297);
    public static final class_304 KEY_ZOOM_IN = KeyMappingHelper.registerKeyMapping((class_2960)Pixelshot.id("zoom_in"), (int)93);
    public static final class_304 KEY_ZOOM_OUT = KeyMappingHelper.registerKeyMapping((class_2960)Pixelshot.id("zoom_out"), (int)92);
    public static final class_304 KEY_ROTATE_LEFT = KeyMappingHelper.registerKeyMapping((class_2960)Pixelshot.id("rotate_left"), (int)263);
    public static final class_304 KEY_ROTATE_RIGHT = KeyMappingHelper.registerKeyMapping((class_2960)Pixelshot.id("rotate_right"), (int)262);
    public static final class_304 KEY_ROTATE_UP = KeyMappingHelper.registerKeyMapping((class_2960)Pixelshot.id("rotate_up"), (int)265);
    public static final class_304 KEY_ROTATE_DOWN = KeyMappingHelper.registerKeyMapping((class_2960)Pixelshot.id("rotate_down"), (int)264);
    public static final class_304 KEY_SWITCH_PRESET = KeyMappingHelper.registerUnboundKeyMapping((class_2960)Pixelshot.id("switch_preset"));
    private float zoom;
    private float xRot;
    private float yRot;
    private float oldZoom;
    private float oldXRot;
    private float oldYRot;
    private boolean isActive;
    private boolean followPlayerView;
    private boolean nearClipping;
    private boolean renderSky;
    private boolean renderPlayerEntity;
    private boolean freezeControls;
    private boolean tmpHideGui;
    private class_5498 tmpCameraType;

    public static void onRegisterKeyMappings(KeyMappingsContext context) {
        context.registerKeyMapping(KEY_TOGGLE_VIEW, KeyActivationContext.GAME);
        context.registerKeyMapping(KEY_OPEN_MENU, KeyActivationContext.GAME);
        context.registerKeyMapping(KEY_ZOOM_IN, KeyActivationContext.GAME);
        context.registerKeyMapping(KEY_ZOOM_OUT, KeyActivationContext.GAME);
        context.registerKeyMapping(KEY_ROTATE_LEFT, KeyActivationContext.GAME);
        context.registerKeyMapping(KEY_ROTATE_RIGHT, KeyActivationContext.GAME);
        context.registerKeyMapping(KEY_ROTATE_UP, KeyActivationContext.GAME);
        context.registerKeyMapping(KEY_ROTATE_DOWN, KeyActivationContext.GAME);
        context.registerKeyMapping(KEY_SWITCH_PRESET, KeyActivationContext.GAME);
    }

    public void onStartClientTick(class_310 minecraft) {
        if (this.oldZoom != this.zoom) {
            OrthoOverlayHandler.INSTANCE.setZoomOverlay(this.zoom, this.oldZoom);
            if (this.oldZoom < this.zoom) {
                class_310.method_1551().field_1769.method_3292();
            }
        }
        if (this.oldXRot != this.xRot) {
            OrthoOverlayHandler.INSTANCE.setXRotOverlay(this.xRot, this.oldXRot);
        } else {
            this.setXRot(class_3532.method_15393((float)this.xRot));
        }
        if (this.oldYRot != this.yRot) {
            OrthoOverlayHandler.INSTANCE.setYRotOverlay(this.yRot, this.oldYRot);
        } else {
            this.setYRot(class_3532.method_15393((float)this.yRot));
        }
        this.setOldValues();
        if (this.freezeControls) {
            return;
        }
        while (KEY_TOGGLE_VIEW.method_1436()) {
            if (class_437.method_25443()) {
                this.reloadCameraSettings(true);
                continue;
            }
            this.isActive = !this.isActive;
        }
        while (KEY_SWITCH_PRESET.method_1436()) {
            if (!this.isActive || this.followPlayerView) continue;
            Vector3f vector3f = DirectionHelper.cycle(this.xRot, this.yRot, !class_437.method_25443());
            this.setXRot(vector3f.x());
            this.setYRot(vector3f.z());
        }
        while (KEY_OPEN_MENU.method_1436()) {
            if (!this.isActive) continue;
            minecraft.method_1507(AbstractCameraScreen.openScreen());
        }
        this.updateZoomAndRotation();
    }

    private void updateZoomAndRotation() {
        if (!this.isActive) {
            return;
        }
        if (KEY_ZOOM_IN.method_1434()) {
            this.setZoom(this.zoom / 1.125f);
        }
        if (KEY_ZOOM_OUT.method_1434()) {
            this.setZoom(this.zoom * 1.125f);
        }
        if (this.followPlayerView) {
            return;
        }
        float rotationStep = class_3532.method_15363((float)this.zoom, (float)8.0f, (float)24.0f) * 0.25f;
        if (KEY_ROTATE_LEFT.method_1434()) {
            this.setYRot(this.yRot + rotationStep);
        }
        if (KEY_ROTATE_RIGHT.method_1434()) {
            this.setYRot(this.yRot - rotationStep);
        }
        if (KEY_ROTATE_UP.method_1434()) {
            this.setXRot(this.xRot + rotationStep);
        }
        if (KEY_ROTATE_DOWN.method_1434()) {
            this.setXRot(this.xRot - rotationStep);
        }
    }

    public void onBeforeGameRender(class_310 minecraft, class_757 gameRenderer, class_9779 deltaTracker) {
        if (this.isActive) {
            this.tmpHideGui = minecraft.field_1690.field_1842;
            minecraft.field_1690.field_1842 = true;
            this.tmpCameraType = minecraft.field_1690.method_31044();
            minecraft.field_1690.method_31043(class_5498.field_26664);
        }
    }

    public void onAfterGameRender(class_310 minecraft, class_757 gameRenderer, class_9779 deltaTracker) {
        if (this.isActive) {
            minecraft.field_1690.field_1842 = this.tmpHideGui;
            minecraft.field_1690.method_31043(this.tmpCameraType);
        }
    }

    public EventResult onRenderBlockOverlay(class_746 localPlayer, class_4587 poseStack, class_4597 multiBufferSource, class_2680 blockState) {
        return this.isActive ? EventResult.INTERRUPT : EventResult.PASS;
    }

    public void onSetupFog(class_4184 camera, float partialTick, @Nullable class_11400 fogEnvironment, class_5636 fogType, class_7285 fogData) {
        if (this.isActive && !this.renderSky) {
            fogData.field_60100 = Float.MAX_VALUE;
            fogData.field_60099 = Float.MAX_VALUE;
            fogData.field_60585 = Float.MAX_VALUE;
            fogData.field_60584 = Float.MAX_VALUE;
            fogData.field_60583 = Float.MAX_VALUE;
            fogData.field_60582 = Float.MAX_VALUE;
        }
    }

    public void onComputeFieldOfView(class_757 renderer, class_4184 camera, float partialTick, MutableFloat fieldOfView) {
        if (this.isActive) {
            if (!this.followPlayerView) {
                camera.method_19325(this.getYRot(partialTick), this.getXRot(partialTick));
            }
            if (this.renderPlayerEntity) {
                camera.field_18719 = true;
            }
        }
    }

    public void onLoggedIn(class_746 player, class_636 multiPlayerGameMode, class_2535 connection) {
        this.reloadCameraSettings(false);
    }

    public void reloadCameraSettings(boolean isActive) {
        this.isActive = isActive;
        this.renderSky = false;
        this.nearClipping = false;
        this.followPlayerView = false;
        this.renderPlayerEntity = ((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).orthographicCamera.initialPlayerRendering;
        this.setZoom((float)((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).orthographicCamera.initialZoomLevel);
        this.setXRot((float)((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).orthographicCamera.initialXRotation);
        this.setYRot((float)((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).orthographicCamera.initialYRotation);
        this.setOldValues();
    }

    private void setOldValues() {
        this.oldZoom = this.zoom;
        this.oldXRot = this.xRot;
        this.oldYRot = this.yRot;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean followPlayerView() {
        return this.followPlayerView;
    }

    public boolean nearClipping() {
        return this.nearClipping;
    }

    public boolean renderSky() {
        return this.renderSky;
    }

    public boolean renderPlayerEntity() {
        return this.renderPlayerEntity;
    }

    public void flipFollowPlayerView() {
        this.followPlayerView = !this.followPlayerView;
    }

    public void flipNearClipping() {
        this.nearClipping = !this.nearClipping;
    }

    public void flipRenderSky() {
        this.renderSky = !this.renderSky;
    }

    public void flipRenderPlayerEntity() {
        this.renderPlayerEntity = !this.renderPlayerEntity;
    }

    public void freezeControls(boolean freezeControls) {
        this.freezeControls = freezeControls;
    }

    public void setZoom(float zoom) {
        this.zoom = class_3532.method_15363((float)zoom, (float)0.1f, (float)500.0f);
    }

    public void setXRot(float xRot) {
        this.xRot = class_3532.method_15363((float)xRot, (float)-90.0f, (float)90.0f);
    }

    public void setYRot(float yRot) {
        this.yRot = yRot;
    }

    public float getZoom() {
        return this.getZoom(1.0f);
    }

    public float getXRot() {
        return this.getXRot(1.0f);
    }

    public float getYRot() {
        return this.getYRot(1.0f);
    }

    public float getZoom(float partialTick) {
        return partialTick == 1.0f ? this.zoom : class_3532.method_16439((float)partialTick, (float)this.oldZoom, (float)this.zoom);
    }

    public float getXRot(float partialTick) {
        return class_3532.method_15393((float)(partialTick == 1.0f ? this.xRot : class_3532.method_16439((float)partialTick, (float)this.oldXRot, (float)this.xRot)));
    }

    public float getYRot(float partialTick) {
        return class_3532.method_15393((float)(partialTick == 1.0f ? this.yRot : class_3532.method_16439((float)partialTick, (float)this.oldYRot, (float)this.yRot)));
    }

    public Matrix4f getProjectionMatrix(class_310 minecraft, float partialTick, boolean forFrustum) {
        float height = this.getZoom(partialTick) + (forFrustum ? 20.0f : 0.0f);
        float width = height * ((float)minecraft.method_22683().method_4489() / (float)minecraft.method_22683().method_4506());
        return new Matrix4f().setOrtho(-width, width, -height, height, !forFrustum && this.nearClipping ? -10.0f : -1000.0f, 1000.0f);
    }

    public static float roundValue(float value) {
        float roundingPrecision = (float)Math.pow(10.0, 1.0);
        return (float)Math.round(value * roundingPrecision) / roundingPrecision;
    }
}

